/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message.basic;

import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import xaero.map.mcworld.WorldMapClientWorldDataHelper;

public class ClientboundRulesPacket {
    public final boolean allowCaveModeOnServer;
    public final boolean allowNetherCaveModeOnServer;

    public ClientboundRulesPacket(boolean allowCaveModeOnServer, boolean allowNetherCaveModeOnServer) {
        this.allowCaveModeOnServer = allowCaveModeOnServer;
        this.allowNetherCaveModeOnServer = allowNetherCaveModeOnServer;
    }

    public void write(PacketBuffer u) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.putBoolean("cm", this.allowCaveModeOnServer);
        nbt.putBoolean("ncm", this.allowNetherCaveModeOnServer);
        u.writeNbt(nbt);
    }

    public static ClientboundRulesPacket read(PacketBuffer buffer) {
        CompoundNBT nbt = buffer.readNbt();
        return new ClientboundRulesPacket(nbt.getBoolean("cm"), nbt.getBoolean("ncm"));
    }

    public static class ClientHandler
    implements Consumer<ClientboundRulesPacket> {
        @Override
        public void accept(ClientboundRulesPacket message) {
            WorldMapClientWorldDataHelper.getCurrentWorldData().setSyncedRules(message);
        }
    }
}

