/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.misc;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.state.StateHolder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.gen.Heightmap;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.misc.CachedFunction;

public class CaveStartCalculator {
    private final BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
    private final CachedFunction<StateHolder<?, ?>, Boolean> transparentCache;
    private final MapWriter mapWriter;

    public CaveStartCalculator(MapWriter mapWriter) {
        this.mapWriter = mapWriter;
        this.transparentCache = new CachedFunction<StateHolder, Boolean>(state -> mapWriter.shouldOverlay((StateHolder<?, ?>)state));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCaving(double playerX, double playerY, double playerZ, World world) {
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        int autoCaveModeConfig = (Integer)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.AUTO_CAVE_MODE);
        if (autoCaveModeConfig == 0) {
            return Integer.MAX_VALUE;
        }
        int y = Math.max((int)playerY + 1, 0);
        int defaultCaveStart = y + 3;
        int defaultResult = Integer.MAX_VALUE;
        if (y > 255 || y < 0) {
            return defaultResult;
        }
        int x = MathHelper.floor((double)playerX);
        int z = MathHelper.floor((double)playerZ);
        int roofRadius = autoCaveModeConfig < 0 ? 1 : autoCaveModeConfig - 1;
        int roofDiameter = 1 + roofRadius * 2;
        int startX = x - roofRadius;
        int startZ = z - roofRadius;
        boolean ignoringHeightmaps = this.mapWriter.getMapProcessor().getMapWorld().isIgnoreHeightmaps();
        int bottom = y;
        int top = -1;
        Chunk prevBChunk = null;
        int potentialResult = defaultCaveStart;
        for (int o = 0; o < roofDiameter; ++o) {
            block1: for (int p = 0; p < roofDiameter; ++p) {
                int currentX = startX + o;
                int currentZ = startZ + p;
                this.mutableBlockPos.set(currentX, y, currentZ);
                Chunk bchunk = world.getChunk(currentX >> 4, currentZ >> 4);
                if (bchunk == null) {
                    return defaultResult;
                }
                int skyLight = world.getBrightness(LightType.SKY, (BlockPos)this.mutableBlockPos);
                if (!ignoringHeightmaps) {
                    if (skyLight >= 15) return defaultResult;
                    int insideX = currentX & 0xF;
                    int insideZ = currentZ & 0xF;
                    top = bchunk.getHeight(Heightmap.Type.WORLD_SURFACE, insideX, insideZ);
                } else if (bchunk != prevBChunk) {
                    ChunkSection[] sections = bchunk.getSections();
                    if (sections.length == 0) {
                        return defaultResult;
                    }
                    int playerSection = y >> 4;
                    boolean foundSomething = false;
                    for (int i = playerSection; i < sections.length; ++i) {
                        ChunkSection searchedSection = sections[i];
                        if (searchedSection == Chunk.EMPTY_SECTION) continue;
                        if (!foundSomething) {
                            bottom = Math.max(bottom, i << 4);
                            foundSomething = true;
                        }
                        top = (i << 4) + 15;
                    }
                    if (!foundSomething) {
                        return defaultResult;
                    }
                    prevBChunk = bchunk;
                }
                if (top < 0) {
                    return defaultResult;
                }
                if (top > 255) {
                    top = 255;
                }
                for (int i = bottom; i <= top; ++i) {
                    this.mutableBlockPos.setY(i);
                    BlockState state = world.getBlockState((BlockPos)this.mutableBlockPos);
                    if (state.isAir() || state.getMaterial().getPushReaction() == PushReaction.DESTROY || state.getBlock() instanceof FlowingFluidBlock || state.is((ITag)BlockTags.LEAVES) || this.transparentCache.apply((StateHolder<?, ?>)state).booleanValue() || state.getBlock() == Blocks.BARRIER) continue;
                    if (o != p || o != roofRadius) continue block1;
                    potentialResult = Math.min(i, defaultCaveStart);
                    continue block1;
                }
                return defaultResult;
            }
        }
        return potentialResult;
    }
}

