/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import java.nio.file.Path;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.profile.ConfigProfile;
import xaero.lib.common.config.server.ServerConfigManager;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.message.basic.ClientboundRulesPacket;
import xaero.map.message.basic.HandshakePacket;
import xaero.map.message.tracker.ClientboundPlayerTrackerResetPacket;
import xaero.map.server.MinecraftServerData;
import xaero.map.server.MineraftServerDataInitializer;
import xaero.map.server.level.LevelMapProperties;
import xaero.map.server.player.IServerPlayer;
import xaero.map.server.player.ServerPlayerData;

public class CommonEvents {
    protected void onPlayerClone(Player oldPlayer, Player newPlayer, boolean alive) {
        if (oldPlayer instanceof ServerPlayer) {
            ServerPlayer oldServerPlayer = (ServerPlayer)oldPlayer;
            ((IServerPlayer)newPlayer).setXaeroWorldMapPlayerData(ServerPlayerData.get(oldServerPlayer));
        }
    }

    public void onServerStarting(MinecraftServer server) {
        new MineraftServerDataInitializer().init(server);
    }

    public void onServerStopped(MinecraftServer server) {
    }

    public void onPlayerLogIn(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WorldMap.messageHandler.sendToPlayer(serverPlayer, (Object)new ClientboundPlayerTrackerResetPacket());
        }
    }

    public void onPlayerWorldJoin(ServerPlayer player) {
        WorldMap.messageHandler.sendToPlayer(player, (Object)new HandshakePacket());
        ServerConfigManager configManager = WorldMap.INSTANCE.getConfigs().getServerConfigManager();
        ConfigProfile defaultEnforcedProfile = configManager.getDefaultEnforcedProfile();
        boolean caveModeConfig = !Boolean.FALSE.equals(defaultEnforcedProfile.get((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED));
        Set caveModeDimensionsConfig = (Set)defaultEnforcedProfile.get(WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS);
        boolean allowOverworldCaveModeOnServer = caveModeConfig && (caveModeDimensionsConfig == null || caveModeDimensionsConfig.isEmpty() || caveModeDimensionsConfig.contains(Level.f_46428_.m_135782_()));
        boolean allowNetherCaveModeOnServer = caveModeConfig && (caveModeDimensionsConfig == null || caveModeDimensionsConfig.isEmpty() || caveModeDimensionsConfig.contains(Level.f_46429_.m_135782_()));
        WorldMap.messageHandler.sendToPlayer(player, (Object)new ClientboundRulesPacket(allowOverworldCaveModeOnServer, allowNetherCaveModeOnServer));
        Path propertiesPath = player.m_9236_().m_7654_().m_129843_(LevelResource.f_78178_).getParent().resolve("xaeromap.txt");
        try {
            MinecraftServerData serverData = MinecraftServerData.get(player.m_20194_());
            LevelMapProperties properties = serverData.getLevelProperties(propertiesPath);
            if (properties.isUsable()) {
                WorldMap.messageHandler.sendToPlayer(player, (Object)properties);
            }
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("suppressed exception", t);
            player.f_8906_.m_9942_((Component)Component.m_237115_((String)"gui.xaero_wm_error_loading_properties"));
        }
    }

    public void handlePlayerTickStart(Player player) {
        if (player instanceof ServerPlayer) {
            WorldMap.serverPlayerTickHandler.tick((ServerPlayer)player);
            return;
        }
        if (WorldMap.events != null) {
            WorldMap.events.handlePlayerTickStart(player);
        }
    }
}

