/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.common.config.util.ConfigUtils;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.world.MapWorld;

public class GuiPlayerTpCommand
extends ScreenBase {
    private MySmallButton confirmButton;
    private EditBox commandFormatTextField;
    private boolean usingDefault;
    private String commandFormat;

    public GuiPlayerTpCommand(Screen parent, Screen escape) {
        super(parent, escape, (Component)Component.m_237115_((String)"gui.xaero_wm_player_teleport_command"));
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        this.usingDefault = mapWorld.isUsingDefaultPlayerTeleport();
        this.commandFormat = mapWorld.getPlayerTeleportCommandFormat();
        this.canSkipWorldRender = true;
    }

    public void m_7856_() {
        super.m_7856_();
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        String defaultPlayerTeleportFormat = (String)configManager.getEffective(WorldMapProfiledConfigOptions.DEFAULT_PLAYER_TELEPORT_FORMAT);
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        this.commandFormatTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 60, 200, 20, (Component)Component.m_237115_((String)"gui.xaero_wm_player_teleport_command"));
        this.commandFormatTextField.m_94144_(this.usingDefault ? defaultPlayerTeleportFormat : this.commandFormat);
        this.commandFormatTextField.m_94199_(500);
        if (this.usingDefault) {
            this.commandFormatTextField.m_94202_(-11184811);
            this.commandFormatTextField.f_93623_ = false;
        } else {
            this.commandFormatTextField.m_94151_(text -> {
                this.commandFormat = text;
            });
        }
        this.m_7787_((GuiEventListener)this.commandFormatTextField);
        this.confirmButton = new MySmallButton(0, this.f_96543_ / 2 - 155, this.f_96544_ / 6 + 168, (Component)Component.m_237110_((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            if (!this.canConfirm()) {
                return;
            }
            if (!this.usingDefault && this.commandFormat.equals(defaultPlayerTeleportFormat)) {
                this.usingDefault = true;
            }
            mapWorld.setUseDefaultPlayerTeleport(this.usingDefault);
            mapWorld.setPlayerTeleportCommandFormat(this.commandFormat);
            mapWorld.saveConfig();
            this.goBack();
        });
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.m_142416_((GuiEventListener)new MySmallButton(1, this.f_96543_ / 2 + 5, this.f_96544_ / 6 + 168, (Component)Component.m_237110_((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.goBack()));
        this.m_142416_((GuiEventListener)new MySmallButton(202, this.f_96543_ / 2 - 75, this.f_96544_ / 7 + 20, (Component)CommonComponents.m_178393_((Component)Component.m_237115_((String)"gui.xaero_wm_use_default"), (Component)ConfigUtils.getDisplayForBoolean(null, (Boolean)this.usingDefault)), b -> {
            this.usingDefault = !this.usingDefault;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }));
    }

    public void m_280273_(GuiGraphics guiGraphics, int i, int j, float f) {
        super.m_280273_(guiGraphics, i, j, f);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, "{x} {y} {z} {name}", this.f_96543_ / 2, this.f_96544_ / 7 + 46, -5592406);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        this.renderEscapeScreen(guiGraphics, mouseX, mouseY, partial);
        super.m_88315_(guiGraphics, mouseX, mouseY, partial);
        this.commandFormatTextField.m_88315_(guiGraphics, mouseX, mouseY, partial);
    }

    private boolean canConfirm() {
        return this.commandFormat != null && this.commandFormat.length() > 0;
    }

    public void m_86600_() {
        super.m_86600_();
        this.confirmButton.f_93623_ = this.canConfirm();
    }

    public boolean m_7933_(int par1, int par2, int par3) {
        if (par1 == 257 && this.commandFormat != null && this.commandFormat.length() > 0) {
            this.confirmButton.m_5716_(0.0, 0.0);
        }
        return super.m_7933_(par1, par2, par3);
    }
}

