/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import org.joml.Matrix3x2fStack;
import xaero.lib.client.gui.util.GuiUtils;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementMenuHitbox;
import xaero.map.element.MapElementMenuScroll;
import xaero.map.element.MapElementRenderHandler;
import xaero.map.element.MenuHitboxReader;
import xaero.map.element.MenuScrollReader;
import xaero.map.element.render.ElementReader;
import xaero.map.element.render.ElementRenderLocation;
import xaero.map.element.render.ElementRenderProvider;
import xaero.map.element.render.ElementRenderer;
import xaero.map.gui.GuiMap;

public abstract class MapElementMenuRenderer<E, C> {
    private static final int MENU_RIGHT_PADDING = 27;
    public static final int MAX_MENU_SIZE = 10;
    public static final int MIN_MENU_SIZE = 2;
    protected final MapElementMenuScroll scrollUp = new MapElementMenuScroll("gui.xaero_wm_up", "\u25b3", 1);
    protected final MapElementMenuScroll scrollDown = new MapElementMenuScroll("gui.xaero_wm_down", "\u25bd", -1);
    protected final MapElementMenuHitbox extraHitbox;
    protected final MenuScrollReader scrollReader = new MenuScrollReader();
    protected final MenuHitboxReader hitboxReader;
    protected final C context;
    protected final ElementRenderProvider<E, C> provider;
    protected ArrayList<E> filteredElements;
    private EditBox filterField;
    public int menuOffset = 0;
    protected Pattern searchPattern = null;
    protected Pattern searchStartPattern = null;
    protected final Minecraft mc;

    protected MapElementMenuRenderer(C context, ElementRenderProvider<E, C> provider) {
        this.extraHitbox = new MapElementMenuHitbox(-150, 0, 177, 0);
        this.hitboxReader = new MenuHitboxReader();
        this.mc = Minecraft.getInstance();
        this.context = context;
        this.provider = provider;
    }

    public void onMapInit(GuiMap screen, Minecraft mc, int width, int height) {
        String searchText = this.filterField == null ? "" : this.filterField.getValue();
        this.filterField = new EditBox(mc.font, screen.width - 172, this.menuStartPos(height) + 3 + this.menuSearchPadding(), 150, 20, (Component)Component.translatable((String)this.getFilterPlaceholder()));
        this.filterField.setValue(searchText);
        this.filterField.setResponder(s -> this.updateSearch());
        screen.addWidget(this.filterField);
    }

    public HoveredMapElementHolder<?, ?> renderMenu(GuiGraphics guiGraphics, GuiMap gui, double scale, int width, int height, int mouseX, int mouseY, boolean leftMousePressed, boolean leftMouseClicked, HoveredMapElementHolder<?, ?> oldHovered, Minecraft mc) {
        int menuStartPos;
        if (this.filteredElements == null) {
            this.updateFilteredList();
        }
        ArrayList<E> elements = this.filteredElements;
        int menuElementCount = MapElementMenuRenderer.getMenuElementCount(this.menuStartPos(height));
        if (this.menuOffset + menuElementCount > elements.size()) {
            this.menuOffset = elements.size() - menuElementCount;
        }
        if (this.menuOffset < 0) {
            this.menuOffset = 0;
        }
        int offset = this.menuOffset;
        Object viewed = null;
        int yPos = menuStartPos = this.menuStartPos(height);
        int elementCount = MapElementMenuRenderer.getMenuElementCount(yPos);
        this.beforeMenuRender();
        viewed = this.renderMenuElement(guiGraphics, this.scrollDown, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, (Screen)gui, offset > 0, mc);
        yPos -= 8;
        for (int i = offset; i < elements.size(); ++i) {
            viewed = this.renderMenuElement(guiGraphics, elements.get(i), width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, (Screen)gui, true, mc);
            yPos -= 8;
            if (i - offset == elementCount - 1) break;
        }
        viewed = this.renderMenuElement(guiGraphics, this.scrollUp, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, (Screen)gui, offset < elements.size() - elementCount, mc);
        yPos -= 8;
        if (viewed != null && leftMouseClicked) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        if (leftMousePressed && viewed instanceof MapElementMenuScroll) {
            int direction = ((MapElementMenuScroll)viewed).scroll();
            this.menuOffset += direction;
        }
        if (viewed == null) {
            this.extraHitbox.setH(menuStartPos - yPos);
            this.extraHitbox.setY(yPos - menuStartPos);
            viewed = this.renderMenuElement(guiGraphics, this.extraHitbox, width, menuStartPos, mouseX, mouseY, viewed, leftMousePressed, (Screen)gui, true, mc);
        }
        this.afterMenuRender();
        return oldHovered != null && oldHovered.equals(viewed) ? oldHovered : (viewed == null ? null : MapElementRenderHandler.createResult(viewed, this.getAnyRenderer(viewed)));
    }

    protected abstract void beforeMenuRender();

    protected abstract void afterMenuRender();

    public void postMapRender(GuiGraphics guiGraphics, GuiMap gui, int scaledMouseX, int scaledMouseY, int width, int height, float partialTicks) {
        String searchText = this.filterField.getValue();
        boolean searchFieldPlaceHolder = searchText.isEmpty() && !this.filterField.isFocused();
        boolean invalidRegex = false;
        if (searchFieldPlaceHolder) {
            GuiUtils.setFieldText((EditBox)this.filterField, (String)I18n.get((String)this.getFilterPlaceholder(), (Object[])new Object[0]), (int)-11184811);
        } else if (!searchText.isEmpty() && this.searchPattern == null) {
            invalidRegex = true;
        }
        this.filterField.render(guiGraphics, scaledMouseX, scaledMouseY, partialTicks);
        if (searchFieldPlaceHolder) {
            GuiUtils.setFieldText((EditBox)this.filterField, (String)"");
        } else if (invalidRegex) {
            String errorMessage = I18n.get((String)"gui.xaero_wm_search_invalid_regex", (Object[])new Object[0]);
            guiGraphics.drawString(this.mc.font, errorMessage, width - 176 - this.mc.font.width(errorMessage), this.filterField.getY() + 6, -43691);
        }
    }

    public static int getMenuElementCount(int menuStartPos) {
        return Math.min(10, Math.max(2, (menuStartPos - 34) / 16 - 2));
    }

    private <O> Object renderMenuElement(GuiGraphics guiGraphics, O element, int width, int yPos, int mouseX, int mouseY, Object viewed, boolean leftMousePressed, Screen gui, boolean enabled, Minecraft mc) {
        boolean hovered;
        MenuScrollReader reader = element == this.scrollDown || element == this.scrollUp ? this.scrollReader : (element == this.extraHitbox ? this.hitboxReader : this.getAnyRenderer(element).getReader());
        int xPos = width - 27;
        boolean bl = hovered = viewed == null && reader.isMouseOverMenuElement(element, xPos, yPos, mouseX, mouseY, mc);
        if (hovered) {
            viewed = element;
        }
        if (element != this.extraHitbox) {
            this.renderMenuElement(reader, element, guiGraphics, gui, xPos, yPos, mouseX, mouseY, 1.0, enabled, hovered, mc, leftMousePressed);
        }
        return viewed;
    }

    public <O> void renderMenuElement(ElementReader<O, ?, ?> reader, O element, GuiGraphics guiGraphics, Screen gui, int x, int y, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed) {
        Matrix3x2fStack matrixStack = guiGraphics.pose();
        matrixStack.pushMatrix();
        if (hovered) {
            matrixStack.translate(pressed ? 1.0f : 2.0f, 0.0f);
        }
        matrixStack.translate((float)x, (float)y);
        matrixStack.scale((float)scale, (float)scale);
        matrixStack.translate(-4.0f, -4.0f);
        String name = reader.getMenuName(element);
        int len = mc.font.width(name);
        int textX = -3 - len;
        guiGraphics.fill(textX - 2 - reader.getMenuTextFillLeftPadding(element), -2, textX + len + 2, 11, 0x77000000);
        guiGraphics.drawString(mc.font, name, textX, 0, enabled ? -1 : -11184811);
        matrixStack.translate(4.0f, 4.0f);
        if (element == this.scrollUp || element == this.scrollDown) {
            this.renderScroll((MapElementMenuScroll)element, guiGraphics, gui, mouseX, mouseY, scale, enabled, hovered, mc, pressed);
        } else {
            O elementCast = element;
            this.renderInMenu(elementCast, guiGraphics, gui, mouseX, mouseY, scale, enabled, hovered, mc, pressed, textX);
        }
        matrixStack.popMatrix();
    }

    public void onMapMouseRelease(MouseButtonEvent event) {
        this.releaseScroll();
    }

    private void releaseScroll() {
        this.scrollUp.onMouseRelease();
        this.scrollDown.onMouseRelease();
    }

    private void renderScroll(MapElementMenuScroll scroll, GuiGraphics guiGraphics, Screen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed) {
        Matrix3x2fStack matrixStack = guiGraphics.pose();
        if (enabled && hovered) {
            matrixStack.translate(pressed ? 1.0f : 2.0f, 0.0f);
        }
        matrixStack.translate(-4.0f, -4.0f);
        int color = enabled ? -1 : -11184811;
        guiGraphics.drawString(mc.font, scroll.getIcon(), 5 - mc.font.width(scroll.getIcon()) / 2, 1, color);
    }

    private void updateSearch() {
        String search = this.filterField.getValue();
        try {
            this.searchPattern = Pattern.compile(search.toLowerCase());
            if (search.length() > 0) {
                this.searchStartPattern = search.charAt(0) == '^' ? this.searchPattern : Pattern.compile("^" + search.toString().toLowerCase());
            } else {
                this.searchStartPattern = null;
                this.searchPattern = null;
            }
        }
        catch (PatternSyntaxException e) {
            this.searchStartPattern = null;
            this.searchPattern = null;
        }
        this.updateFilteredList();
    }

    public boolean charTyped() {
        return this.filterField.isFocused();
    }

    public boolean keyPressed(GuiMap screen, int keyCode) {
        if (screen.getFocused() == this.filterField) {
            if (keyCode == 257) {
                this.filterField.setValue("");
            }
            return true;
        }
        return false;
    }

    public void mouseScrolled(int direction) {
        this.scroll(direction);
    }

    public void tick() {
    }

    public void unfocusAll() {
        if (this.filterField != null) {
            this.filterField.setFocused(false);
        }
    }

    public void onMenuClosed() {
        this.menuOffset = 0;
        this.searchPattern = null;
        this.searchStartPattern = null;
        this.updateFilteredList();
        this.filterField = null;
    }

    private void scroll(int direction) {
        this.menuOffset += direction;
    }

    public Pattern getSearchPattern() {
        return this.searchPattern;
    }

    public Pattern getSearchStartPattern() {
        return this.searchStartPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFilteredList() {
        ElementRenderProvider<E, C> provider = this.provider;
        if (provider == null) {
            this.filteredElements = null;
            return;
        }
        if (this.filteredElements == null) {
            this.filteredElements = new ArrayList();
        } else {
            this.filteredElements.clear();
        }
        Pattern regex = this.searchPattern;
        Pattern regexStartsWith = this.searchStartPattern;
        this.beforeFiltering();
        provider.begin(ElementRenderLocation.WORLD_MAP_MENU, this.context);
        try {
            while (provider.hasNext(ElementRenderLocation.WORLD_MAP_MENU, this.context)) {
                E e = provider.getNext(ElementRenderLocation.WORLD_MAP_MENU, this.context);
                if (regex == null) {
                    this.filteredElements.add(e);
                    continue;
                }
                String filterName = this.getRenderer(e).getReader().getFilterName(e).toLowerCase();
                if (regexStartsWith.matcher(filterName).find()) {
                    this.filteredElements.add(0, e);
                    continue;
                }
                if (!regex.matcher(filterName).find()) continue;
                this.filteredElements.add(e);
            }
        }
        finally {
            provider.end(ElementRenderLocation.WORLD_MAP_MENU, this.context);
        }
    }

    protected <O> ElementRenderer<? super O, ?, ?> getAnyRenderer(O element) {
        if (element == this.scrollDown || element == this.scrollUp || element == this.extraHitbox) {
            return null;
        }
        return this.getRenderer(element);
    }

    protected abstract ElementRenderer<? super E, ?, ?> getRenderer(E var1);

    public abstract int menuStartPos(int var1);

    public abstract int menuSearchPadding();

    public abstract void renderInMenu(E var1, GuiGraphics var2, Screen var3, int var4, int var5, double var6, boolean var8, boolean var9, Minecraft var10, boolean var11, int var12);

    protected abstract String getFilterPlaceholder();

    protected abstract void beforeFiltering();
}

