/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.server.radar.tracker;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import xaero.lib.XaeroLib;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.primary.option.LibPrimaryCommonConfigOptions;
import xaero.lib.common.config.single.SingleConfigManager;
import xaero.map.WorldMap;
import xaero.map.message.tracker.ClientboundTrackedPlayerPacket;
import xaero.map.server.MinecraftServerData;
import xaero.map.server.mods.SupportServerMods;
import xaero.map.server.player.ServerPlayerData;
import xaero.map.server.radar.tracker.ISyncedPlayerTrackerSystem;
import xaero.map.server.radar.tracker.SyncedTrackedPlayer;

public class SyncedPlayerTracker {
    public void onTick(MinecraftServer server, ServerPlayer player, MinecraftServerData serverData, ServerPlayerData playerData) {
        boolean opacReceiveMutualAllies;
        boolean shouldSyncToOthers;
        boolean playerHasMod;
        long currentTime = System.currentTimeMillis();
        if (currentTime - playerData.getLastTrackedPlayerSync() < 250L) {
            return;
        }
        playerData.setLastTrackedPlayerSync(currentTime);
        boolean shouldSyncToPlayer = playerHasMod = playerData.hasMod();
        if (SupportServerMods.hasMinimap() && SupportServerMods.getMinimap().supportsTrackedPlayers() && SupportServerMods.getMinimap().playerSupportsTrackedPlayers(player)) {
            if (playerData.getCurrentlySyncedPlayers() != null && !playerData.getCurrentlySyncedPlayers().isEmpty()) {
                for (UUID id : playerData.getCurrentlySyncedPlayers()) {
                    this.sendRemovePacket(player, playerData, id);
                }
                playerData.getCurrentlySyncedPlayers().clear();
            }
            shouldSyncToPlayer = false;
        }
        SingleConfigManager primaryCommonConfig = WorldMap.INSTANCE.getConfigs().getPrimaryCommonConfigManager();
        SingleConfigManager libPrimaryCommonConfig = XaeroLib.INSTANCE.getLibConfigChannel().getPrimaryCommonConfigManager();
        boolean everyoneIsTracked = (Boolean)libPrimaryCommonConfig.getEffective((ConfigOption)LibPrimaryCommonConfigOptions.EVERYONE_TRACKS_EVERYONE);
        Iterable<ISyncedPlayerTrackerSystem> playerTrackerSystems = serverData.getSyncedPlayerTrackerSystemManager().getSystems();
        Set<UUID> syncedPlayers = playerData.ensureCurrentlySyncedPlayers();
        HashSet<UUID> leftoverPlayers = new HashSet<UUID>(syncedPlayers);
        SyncedTrackedPlayer toSync = playerData.getLastSyncedData();
        boolean bl = shouldSyncToOthers = toSync == null || !toSync.matchesEnough((Player)player, 0.0);
        if (shouldSyncToOthers) {
            toSync = playerData.ensureLastSyncedData();
            toSync.update((Player)player);
        }
        boolean opacReceiveParty = shouldSyncToPlayer && SupportServerMods.hasOpac() && SupportServerMods.getOpac().getReceiveLocationsFromPartyConfigValue(player);
        boolean bl2 = opacReceiveMutualAllies = shouldSyncToPlayer && SupportServerMods.hasOpac() && SupportServerMods.getOpac().getReceiveLocationsFromMutualAlliesConfigValue(player);
        if (SupportServerMods.hasOpac()) {
            SupportServerMods.getOpac().updateShareLocationConfigValues(player, playerData);
        }
        for (ServerPlayer otherPlayer : server.getPlayerList().getPlayers()) {
            Set<UUID> otherPlayerSyncedPlayers;
            if (otherPlayer == player) continue;
            leftoverPlayers.remove(otherPlayer.getUUID());
            ServerPlayerData otherPlayerData = ServerPlayerData.get(otherPlayer);
            if (shouldSyncToOthers && (otherPlayerSyncedPlayers = otherPlayerData.getCurrentlySyncedPlayers()) != null && otherPlayerSyncedPlayers.contains(player.getUUID())) {
                this.sendTrackedPlayerPacket(otherPlayer, otherPlayerData, toSync);
            }
            if (!shouldSyncToPlayer) continue;
            boolean tracked = everyoneIsTracked;
            if (!tracked) {
                boolean opacConfigsAllowPartySync = !SupportServerMods.hasOpac() || SupportServerMods.getOpac().isPositionSyncAllowed(2, otherPlayerData, opacReceiveParty);
                boolean opacConfigsAllowAllySync = !SupportServerMods.hasOpac() || SupportServerMods.getOpac().isPositionSyncAllowed(1, otherPlayerData, opacReceiveMutualAllies);
                for (ISyncedPlayerTrackerSystem system : playerTrackerSystems) {
                    int trackingLevel = system.getTrackingLevel((Player)player, (Player)otherPlayer);
                    if (trackingLevel <= 0 || system.isPartySystem() && (trackingLevel != 1 || !opacConfigsAllowAllySync) && (trackingLevel <= 1 || !opacConfigsAllowPartySync)) continue;
                    tracked = true;
                    break;
                }
            }
            boolean alreadySynced = syncedPlayers.contains(otherPlayer.getUUID());
            if (!tracked) {
                if (!alreadySynced) continue;
                syncedPlayers.remove(otherPlayer.getUUID());
                this.sendRemovePacket(player, playerData, otherPlayer.getUUID());
                continue;
            }
            if (alreadySynced || otherPlayerData.getLastSyncedData() == null) continue;
            syncedPlayers.add(otherPlayer.getUUID());
            this.sendTrackedPlayerPacket(player, playerData, otherPlayerData.getLastSyncedData());
        }
        for (UUID offlineId : leftoverPlayers) {
            syncedPlayers.remove(offlineId);
            this.sendRemovePacket(player, playerData, offlineId);
        }
    }

    private void sendRemovePacket(ServerPlayer player, ServerPlayerData playerData, UUID toRemove) {
        WorldMap.messageHandler.sendToPlayer(player, (Object)new ClientboundTrackedPlayerPacket(true, toRemove, 0.0, 0.0, 0.0, null, playerData.getClientModNetworkVersion()));
    }

    private void sendTrackedPlayerPacket(ServerPlayer player, ServerPlayerData playerData, SyncedTrackedPlayer tracked) {
        WorldMap.messageHandler.sendToPlayer(player, (Object)new ClientboundTrackedPlayerPacket(false, tracked.getId(), tracked.getX(), tracked.getY(), tracked.getZ(), tracked.getDimension().identifier(), playerData.getClientModNetworkVersion()));
    }
}

