/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import xaero.map.WorldMap;
import xaero.map.controls.ControlsRegister;
import xaero.map.events.ClientEvents;

public class ClientEventsForge
extends ClientEvents {
    @SubscribeEvent
    public boolean guiOpen(ScreenEvent.Opening event) {
        Screen guiBefore = event.getNewScreen();
        Screen gui = this.handleGuiOpen(guiBefore);
        if (guiBefore != null && gui == null) {
            return true;
        }
        event.setNewScreen(gui);
        return false;
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent.Post event) throws Exception {
        this.handleRenderTick(false);
    }

    @SubscribeEvent
    public void screenRenderPost(ScreenEvent.Render.Post event) {
        super.handleDrawScreen(event.getScreen());
    }

    @SubscribeEvent
    public void worldUnload(LevelEvent.Unload event) {
        super.handleWorldUnload(event.getLevel());
    }

    @SubscribeEvent
    public boolean handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        if (e.getMessage() == null) {
            return false;
        }
        if (Minecraft.getInstance().getConnection() == null) {
            return false;
        }
        Component text = e.getMessage();
        PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(e.getSender());
        GameProfile gameProfile = playerInfo == null ? null : playerInfo.getProfile();
        return gameProfile != null && this.handleClientPlayerChatReceivedEvent(e.getBoundChatType(), text, gameProfile);
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent.Pre event) throws Exception {
        super.handleClientTickStart();
    }

    @SubscribeEvent
    public void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        if (WorldMap.controlsRegister == null) {
            WorldMap.controlsRegister = new ControlsRegister();
        }
        WorldMap.controlsRegister.register(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0), c -> {});
    }

    @SubscribeEvent
    public void handleTextureStitchEventPost(TextureStitchEvent.Post event) {
        super.handleTextureStitchEventPost(event.getAtlas());
    }
}

