/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import java.lang.reflect.Field;
import java.nio.IntBuffer;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_4536;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL30;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class ImprovedFramebuffer
extends class_276 {
    private static Field MAIN_RENDER_TARGET_FIELD = ReflectionUtils.getFieldReflection(class_310.class, (String)"mainRenderTarget", (String)"field_1689", (String)"Lnet/minecraft/class_276;", (String)"field_147124_at");
    private static class_276 mainRenderTargetBackup;
    private int type;
    public int colorAttachment;
    private int depthAttachment;
    private boolean superConstructorWorks;
    private static final int GL_FB_INCOMPLETE_ATTACHMENT = 36054;
    private static final int GL_FB_INCOMPLETE_MISS_ATTACH = 36055;
    private static final int GL_FB_INCOMPLETE_DRAW_BUFFER = 36059;
    private static final int GL_FB_INCOMPLETE_READ_BUFFER = 36060;

    public ImprovedFramebuffer(int width, int height, boolean useDepthIn) {
        super(width, height, useDepthIn, class_310.field_1703);
        if (!this.superConstructorWorks) {
            this.method_1234(width, height, class_310.field_1703);
        }
    }

    public void method_1234(int width, int height, boolean isMac) {
        this.superConstructorWorks = true;
        class_4493.method_22050();
        if (this.field_1476 >= 0) {
            this.method_1238();
        }
        this.method_1231(width, height, isMac);
        ImprovedFramebuffer.beginWrite(this.type, 36160, 0);
    }

    public void method_1231(int width, int height, boolean isMac) {
        this.field_1480 = width;
        this.field_1477 = height;
        this.field_1482 = width;
        this.field_1481 = height;
        this.field_1476 = this.genFrameBuffers();
        if (this.field_1476 == -1) {
            this.method_1230(isMac);
            return;
        }
        this.colorAttachment = class_4536.method_24956();
        if (this.colorAttachment == -1) {
            this.method_1230(isMac);
            return;
        }
        if (this.field_1478) {
            this.depthAttachment = this.genRenderbuffers();
            if (this.depthAttachment == -1) {
                this.method_1230(isMac);
                return;
            }
        }
        this.method_1232(9728);
        class_4493.method_22081((int)this.colorAttachment);
        class_4493.method_21954((int)3553, (int)0, (int)32856, (int)this.field_1482, (int)this.field_1481, (int)0, (int)6408, (int)5121, (IntBuffer)null);
        ImprovedFramebuffer.beginWrite(this.type, 36160, this.field_1476);
        ImprovedFramebuffer.framebufferTexture2D(this.type, 36160, 36064, 3553, this.colorAttachment, 0);
        if (this.field_1478) {
            ImprovedFramebuffer.bindRenderbuffer(this.type, 36161, this.depthAttachment);
            ImprovedFramebuffer.renderbufferStorage(this.type, 36161, 33190, this.field_1482, this.field_1481);
            ImprovedFramebuffer.framebufferRenderbuffer(this.type, 36160, 36096, 36161, this.depthAttachment);
        }
        this.method_1239();
        this.method_1230(isMac);
        this.method_1242();
    }

    private int genFrameBuffers() {
        int fbo = -1;
        this.type = -1;
        if (GL.getCapabilities().OpenGL30) {
            fbo = GL30.glGenFramebuffers();
            this.type = 0;
        } else if (GL.getCapabilities().GL_ARB_framebuffer_object) {
            fbo = ARBFramebufferObject.glGenFramebuffers();
            this.type = 1;
        } else if (GL.getCapabilities().GL_EXT_framebuffer_object) {
            fbo = EXTFramebufferObject.glGenFramebuffersEXT();
            this.type = 2;
        }
        return fbo;
    }

    public int genRenderbuffers() {
        int rbo = -1;
        switch (this.type) {
            case 0: {
                rbo = GL30.glGenRenderbuffers();
                break;
            }
            case 1: {
                rbo = ARBFramebufferObject.glGenRenderbuffers();
                break;
            }
            case 2: {
                rbo = EXTFramebufferObject.glGenRenderbuffersEXT();
            }
        }
        return rbo;
    }

    public void method_1238() {
        this.method_1242();
        this.method_1240();
        if (this.depthAttachment > -1) {
            this.deleteRenderbuffers(this.depthAttachment);
            this.depthAttachment = -1;
        }
        if (this.colorAttachment > -1) {
            class_4536.method_24957((int)this.colorAttachment);
            this.colorAttachment = -1;
        }
        if (this.field_1476 > -1) {
            ImprovedFramebuffer.beginWrite(this.type, 36160, 0);
            this.deleteFramebuffers(this.field_1476);
            this.field_1476 = -1;
        }
    }

    private void deleteFramebuffers(int framebufferIn) {
        switch (this.type) {
            case 0: {
                GL30.glDeleteFramebuffers((int)framebufferIn);
                break;
            }
            case 1: {
                ARBFramebufferObject.glDeleteFramebuffers((int)framebufferIn);
                break;
            }
            case 2: {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)framebufferIn);
            }
        }
    }

    private void deleteRenderbuffers(int renderbuffer) {
        switch (this.type) {
            case 0: {
                GL30.glDeleteRenderbuffers((int)renderbuffer);
                break;
            }
            case 1: {
                ARBFramebufferObject.glDeleteRenderbuffers((int)renderbuffer);
                break;
            }
            case 2: {
                EXTFramebufferObject.glDeleteRenderbuffersEXT((int)renderbuffer);
            }
        }
    }

    public void method_1239() {
        int i = this.checkFramebufferStatus(36160);
        if (i != 36053) {
            if (i == 36054) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i == 36055) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i == 36059) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i == 36060) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i);
        }
    }

    private int checkFramebufferStatus(int target) {
        switch (this.type) {
            case 0: {
                return GL30.glCheckFramebufferStatus((int)target);
            }
            case 1: {
                return ARBFramebufferObject.glCheckFramebufferStatus((int)target);
            }
            case 2: {
                return EXTFramebufferObject.glCheckFramebufferStatusEXT((int)target);
            }
        }
        return -1;
    }

    public static void beginWrite(int type, int target, int framebufferIn) {
        if (framebufferIn == -1) {
            framebufferIn = 0;
        }
        switch (type) {
            case 0: {
                GL30.glBindFramebuffer((int)target, (int)framebufferIn);
                break;
            }
            case 1: {
                ARBFramebufferObject.glBindFramebuffer((int)target, (int)framebufferIn);
                break;
            }
            case 2: {
                EXTFramebufferObject.glBindFramebufferEXT((int)target, (int)framebufferIn);
            }
        }
    }

    public static void bindDefaultFramebuffer(int type, int target, class_310 mc) {
        ImprovedFramebuffer.restoreMainRenderTarget();
        ImprovedFramebuffer.beginWrite(type, target, mc.method_1522().field_1476);
    }

    public static void framebufferTexture2D(int type, int target, int attachment, int textarget, int texture, int level) {
        switch (type) {
            case 0: {
                GL30.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                break;
            }
            case 1: {
                ARBFramebufferObject.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                break;
            }
            case 2: {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
            }
        }
    }

    public static void bindRenderbuffer(int type, int target, int renderbuffer) {
        switch (type) {
            case 0: {
                GL30.glBindRenderbuffer((int)target, (int)renderbuffer);
                break;
            }
            case 1: {
                ARBFramebufferObject.glBindRenderbuffer((int)target, (int)renderbuffer);
                break;
            }
            case 2: {
                EXTFramebufferObject.glBindRenderbufferEXT((int)target, (int)renderbuffer);
            }
        }
    }

    public static void renderbufferStorage(int type, int target, int internalFormat, int width, int height) {
        switch (type) {
            case 0: {
                GL30.glRenderbufferStorage((int)target, (int)internalFormat, (int)width, (int)height);
                break;
            }
            case 1: {
                ARBFramebufferObject.glRenderbufferStorage((int)target, (int)internalFormat, (int)width, (int)height);
                break;
            }
            case 2: {
                EXTFramebufferObject.glRenderbufferStorageEXT((int)target, (int)internalFormat, (int)width, (int)height);
            }
        }
    }

    public static void framebufferRenderbuffer(int type, int target, int attachment, int renderBufferTarget, int renderBuffer) {
        switch (type) {
            case 0: {
                GL30.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderBufferTarget, (int)renderBuffer);
                break;
            }
            case 1: {
                ARBFramebufferObject.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderBufferTarget, (int)renderBuffer);
                break;
            }
            case 2: {
                EXTFramebufferObject.glFramebufferRenderbufferEXT((int)target, (int)attachment, (int)renderBufferTarget, (int)renderBuffer);
            }
        }
    }

    public void method_1235(boolean p_147610_1_) {
        ImprovedFramebuffer.beginWrite(this.type, 36160, this.field_1476);
        if (p_147610_1_) {
            class_4493.method_22025((int)0, (int)0, (int)this.field_1480, (int)this.field_1477);
        }
    }

    public void method_1240() {
        ImprovedFramebuffer.beginWrite(this.type, 36160, 0);
    }

    public void method_1241() {
        class_4493.method_22081((int)this.colorAttachment);
    }

    public void method_1242() {
        class_4493.method_22081((int)0);
    }

    public void method_1232(int framebufferFilterIn) {
        this.field_1483 = framebufferFilterIn;
        class_4493.method_22081((int)this.colorAttachment);
        class_4493.method_21986((int)3553, (int)10241, (int)framebufferFilterIn);
        class_4493.method_21986((int)3553, (int)10240, (int)framebufferFilterIn);
        class_4493.method_21986((int)3553, (int)10242, (int)10496);
        class_4493.method_21986((int)3553, (int)10243, (int)10496);
        class_4493.method_22081((int)0);
    }

    public int getFramebufferTexture() {
        return this.colorAttachment;
    }

    public void setFramebufferTexture(int textureId) {
        if (textureId != this.colorAttachment) {
            this.colorAttachment = textureId;
            if (textureId != 0) {
                ImprovedFramebuffer.framebufferTexture2D(this.type, 36160, 36064, 3553, this.colorAttachment, 0);
            }
        }
    }

    public void generateMipmaps() {
        switch (this.type) {
            case 0: {
                GL30.glGenerateMipmap((int)3553);
                break;
            }
            case 1: {
                ARBFramebufferObject.glGenerateMipmap((int)3553);
                break;
            }
            case 2: {
                EXTFramebufferObject.glGenerateMipmapEXT((int)3553);
            }
        }
    }

    public int getType() {
        return this.type;
    }

    private void forceAsMainRenderTarget() {
        if (mainRenderTargetBackup == null) {
            mainRenderTargetBackup = (class_276)ReflectionUtils.getReflectFieldValue((Object)class_310.method_1551(), (Field)MAIN_RENDER_TARGET_FIELD);
        }
        ReflectionUtils.setReflectFieldValue((Object)class_310.method_1551(), (Field)MAIN_RENDER_TARGET_FIELD, (Object)((Object)this));
    }

    public static void restoreMainRenderTarget() {
        if (mainRenderTargetBackup != null) {
            ReflectionUtils.setReflectFieldValue((Object)class_310.method_1551(), (Field)MAIN_RENDER_TARGET_FIELD, (Object)mainRenderTargetBackup);
            mainRenderTargetBackup = null;
        }
    }

    public void bindAsMainTarget(boolean viewport) {
        this.method_1235(viewport);
        this.forceAsMainRenderTarget();
    }
}

