/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.serialization.data;

import java.util.function.Supplier;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import xaero.hud.category.serialization.data.ObjectCategoryData;
import xaero.hud.category.serialization.data.ObjectCategoryDataSerializer;

public class ObjectCategoryDataNbtSerializer<D extends ObjectCategoryData<D>, DB extends ObjectCategoryData.Builder<D, DB>>
extends ObjectCategoryDataSerializer<D, class_2487> {
    private final Supplier<DB> builderSupplier;

    protected ObjectCategoryDataNbtSerializer(Supplier<DB> builderSupplier) {
        this.builderSupplier = builderSupplier;
    }

    @Override
    public class_2487 serialize(D data) {
        class_2487 resultTag = new class_2487();
        resultTag.method_10582("n", ((ObjectCategoryData)data).getName());
        resultTag.method_10556("p", ((ObjectCategoryData)data).getProtection());
        class_2487 settingOverrides = new class_2487();
        ((ObjectCategoryData)data).getSettingOverrideIterator().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                return;
            }
            if (value instanceof Boolean) {
                settingOverrides.method_10556(key, ((Boolean)value).booleanValue());
                return;
            }
            if (value instanceof Double) {
                settingOverrides.method_10549(key, ((Double)value).doubleValue());
                return;
            }
            if (value instanceof Integer) {
                settingOverrides.method_10569(key, ((Integer)value).intValue());
                return;
            }
            throw new IllegalArgumentException("Unsupported category setting type: " + String.valueOf(value.getClass()));
        });
        resultTag.method_10566("v", (class_2520)settingOverrides);
        class_2499 subCategoriesTag = new class_2499();
        ((ObjectCategoryData)data).getSubCategoryIterator().forEachRemaining(sub -> {
            class_2487 subCategoryTag = this.serialize((D)sub);
            subCategoriesTag.add((Object)subCategoryTag);
        });
        resultTag.method_10566("s", (class_2520)subCategoriesTag);
        return resultTag;
    }

    @Override
    public final D deserialize(class_2487 serializedData) {
        return ((ObjectCategoryData.Builder)this.getConfiguredBuilder(serializedData)).build();
    }

    protected DB getConfiguredBuilder(class_2487 serializedData) {
        ObjectCategoryData.Builder builder = (ObjectCategoryData.Builder)this.builderSupplier.get();
        builder.setName(serializedData.method_10558("n"));
        builder.setProtection(serializedData.method_10577("p"));
        class_2487 settingOverrides = serializedData.method_10562("v");
        for (String key : settingOverrides.method_10541()) {
            class_2520 valueTag = settingOverrides.method_10580(key);
            if (valueTag instanceof class_2481) {
                builder.setSettingOverride(key, ((class_2481)valueTag).method_10698() == 1);
                continue;
            }
            if (valueTag instanceof class_2489) {
                builder.setSettingOverride(key, ((class_2489)valueTag).method_10697());
                continue;
            }
            if (valueTag instanceof class_2497) {
                builder.setSettingOverride(key, ((class_2497)valueTag).method_10701());
                continue;
            }
            throw new IllegalArgumentException("Unsupported category setting NBT tag type: " + String.valueOf(valueTag.getClass()));
        }
        class_2499 subCategoriesTag = serializedData.method_10554("s", 10);
        for (class_2520 subCategoryTag : subCategoriesTag) {
            builder.addSubCategoryBuilder(this.getConfiguredBuilder((class_2487)subCategoryTag));
        }
        return (DB)builder;
    }

    public static final class FinalBuilder<D extends ObjectCategoryData<D>, DB extends ObjectCategoryData.Builder<D, DB>>
    extends Builder<D, DB, FinalBuilder<D, DB>> {
        private FinalBuilder() {
        }

        @Override
        protected ObjectCategoryDataNbtSerializer<D, DB> buildInternally() {
            return new ObjectCategoryDataNbtSerializer(this.builderSupplier);
        }

        public static <D extends ObjectCategoryData<D>, DB extends ObjectCategoryData.Builder<D, DB>> FinalBuilder<D, DB> begin() {
            return (FinalBuilder)new FinalBuilder<D, DB>().setDefault();
        }
    }

    public static abstract class Builder<D extends ObjectCategoryData<D>, DB extends ObjectCategoryData.Builder<D, DB>, B extends Builder<D, DB, B>> {
        protected final B self = this;
        protected Supplier<DB> builderSupplier;

        protected Builder() {
        }

        public B setDefault() {
            this.setBuilderSupplier(null);
            return this.self;
        }

        public B setBuilderSupplier(Supplier<DB> builderSupplier) {
            this.builderSupplier = builderSupplier;
            return this.self;
        }

        public ObjectCategoryDataNbtSerializer<D, DB> build() {
            if (this.builderSupplier == null) {
                throw new IllegalStateException();
            }
            return this.buildInternally();
        }

        protected abstract ObjectCategoryDataNbtSerializer<D, DB> buildInternally();
    }
}

