/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_10366;
import net.minecraft.class_11278;
import net.minecraft.class_1297;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.anim.MultiplyAnimationHelper;
import xaero.common.core.IGuiRenderer;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.minimap.mcworld.MinimapClientWorldData;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.common.minimap.render.MinimapRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.misc.Misc;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.config.util.MinimapConfigClientUtils;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.player.tracker.synced.ClientSyncedTrackedPlayerManager;
import xaero.hud.minimap.radar.RadarSession;
import xaero.hud.minimap.radar.category.EntityRadarCategoryManager;
import xaero.hud.minimap.render.MinimapPipRenderState;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.graphics.IGameRenderer;
import xaero.lib.common.config.option.ConfigOption;

public class MinimapProcessor {
    public static final boolean DEBUG = false;
    public static final int FRAME = 9;
    private IXaeroMinimap modMain;
    private MinimapSession minimapSession;
    private MinimapWriter minimapWriter;
    private RadarSession radarSession;
    private Minimap minimap;
    private EntityRadarCategoryManager entityCategoryManager;
    private ClientSyncedTrackedPlayerManager syncedTrackedPlayerManager;
    private double minimapZoom;
    private boolean toResetImage;
    private boolean enlargedMap;
    private boolean manualCaveMode;
    private boolean noMinimapMessageReceived;
    private boolean fairPlayOnlyMessageReceived;
    private boolean consideringNetherFairPlayMessage;
    private double lastMapDimensionScale = 1.0;
    private class_5321<class_1937> lastMapDimension;
    private double lastPlayerDimDiv = 1.0;
    private class_1792 minimapItem;
    private final MinimapPipRenderState renderState;
    private final MinimapPipRenderState.Enlarged enlargedRenderState;

    public MinimapProcessor(IXaeroMinimap modMain, MinimapSession minimapSession, MinimapWriter minimapWriter, RadarSession radarSession, ClientSyncedTrackedPlayerManager syncedTrackedPlayerManager) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.minimapWriter = minimapWriter;
        this.radarSession = radarSession;
        this.minimapZoom = 1.0;
        this.toResetImage = true;
        this.minimap = modMain.getMinimap();
        this.syncedTrackedPlayerManager = syncedTrackedPlayerManager;
        this.updateMinimapItem();
        this.renderState = new MinimapPipRenderState();
        this.enlargedRenderState = new MinimapPipRenderState.Enlarged();
    }

    public int getMinimapSize() {
        int minimapSizeConfig = MinimapConfigClientUtils.getEffectiveMinimapSize();
        return this.enlargedMap ? 500 : minimapSizeConfig * 2;
    }

    public int getMinimapBufferSize(int minimapSize) {
        int bufferSize = 128 * (int)Math.pow(2.0, Math.ceil(Math.log((double)minimapSize / 128.0) / Math.log(2.0)));
        if (bufferSize < 128) {
            return 128;
        }
        if (bufferSize > 512) {
            return 512;
        }
        return bufferSize;
    }

    public boolean isEnlargedMap() {
        return this.enlargedMap;
    }

    public void setEnlargedMap(boolean enlargedMap) {
        this.enlargedMap = enlargedMap;
    }

    public double getMinimapZoom() {
        return this.minimapZoom;
    }

    public boolean isCaveModeDisplayed() {
        return this.minimapWriter.getLoadedCaving() != Integer.MAX_VALUE;
    }

    public double getTargetZoom() {
        int enlargedZoomConfig;
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        float target = ((Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.ZOOM)).intValue();
        if (this.enlargedMap && (enlargedZoomConfig = ((Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.ZOOM_ENLARGED)).intValue()) > 0) {
            target = enlargedZoomConfig;
        }
        if (this.isCaveModeDisplayed()) {
            target *= (float)((Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.CAVE_ZOOM)).intValue();
        }
        if (target > 5.0f) {
            target = 5.0f;
        }
        return target;
    }

    public void instantZoom() {
        this.minimapZoom = this.getTargetZoom();
    }

    public void updateZoom() {
        double target = this.getTargetZoom();
        double off = target - this.minimapZoom;
        off = off > 0.01 || off < -0.01 ? (double)((float)MultiplyAnimationHelper.animate(off, 0.8)) : 0.0;
        this.minimapZoom = target - off;
    }

    public MinimapWriter getMinimapWriter() {
        return this.minimapWriter;
    }

    public boolean canUseFrameBuffer() {
        return true;
    }

    public int getFBOBufferSize() {
        return 512;
    }

    public void onClientTick() {
        class_1937 world = null;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_37908() instanceof class_638) {
            world = player.method_37908();
        }
        class_1297 renderEntity = class_310.method_1551().method_1560();
        this.radarSession.update((class_638)world, renderEntity, (class_1657)player);
    }

    public void onPlayerTick() {
    }

    public void checkFBO() {
        if (this.minimap.getMinimapFBORenderer().isLoadedFBO() && !this.canUseFrameBuffer()) {
            this.minimap.getMinimapFBORenderer().setLoadedFBO(false);
            this.minimap.getMinimapFBORenderer().deleteFramebuffers();
            this.toResetImage = true;
        }
        boolean mapSafeMode = (Boolean)HudMod.INSTANCE.getHudConfigs().getClientConfigManager().getEffective((ConfigOption)MinimapProfiledConfigOptions.SAFE_MODE);
        if (!(this.minimap.getMinimapFBORenderer().isLoadedFBO() || mapSafeMode || this.minimap.getMinimapFBORenderer().isTriedFBO())) {
            if (class_310.method_1551().method_18506() != null) {
                return;
            }
            this.minimap.getMinimapFBORenderer().loadFrameBuffer(this);
        }
    }

    public void onRender(int x, int y, int width, int height, double scale, float minimapScale, int size, int boxSize, float partial, CustomVertexConsumers cvc, int pipWidth, int pipHeight) {
        MinimapRendererHelper.restoreDefaultShaderBlendState();
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().identity();
        RenderSystem.getModelViewStack().translate(0.0f, 0.0f, -11000.0f);
        try {
            class_310 mc = class_310.method_1551();
            IGuiRenderer guiRenderer = (IGuiRenderer)((IGameRenderer)mc.field_1773).xaero_lib_getGuiRenderer();
            class_11278 orthoProjectionCache = guiRenderer.xaero_mm_getGuiProjectionMatrixBuffer();
            RenderSystem.setProjectionMatrix((GpuBufferSlice)orthoProjectionCache.method_71092((float)pipWidth, (float)pipHeight), (class_10366)class_10366.field_54954);
            this.minimap.getMatrixStack().method_22903();
            this.minimap.getMatrixStack().method_22904(0.0, 0.0, 0.01);
            this.getRenderer().renderMinimap(this.minimapSession, this, x, y, width, height, scale, minimapScale, size, partial, cvc);
            this.minimap.getMatrixStack().method_22909();
        }
        catch (Throwable e) {
            this.minimap.setCrashedWith(e);
        }
        RenderSystem.getModelViewStack().popMatrix();
        MinimapRendererHelper.restoreDefaultShaderBlendState();
    }

    public MinimapRenderer getRenderer() {
        if (this.minimap.usingFBO()) {
            return this.minimap.getMinimapFBORenderer();
        }
        return this.minimap.getMinimapSafeModeRenderer();
    }

    public static boolean hasMinimapItem(class_1657 player) {
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (session == null) {
            return true;
        }
        MinimapProcessor processor = session.getProcessor();
        return processor.minimapItem == null || Misc.hasItem(player, processor.minimapItem);
    }

    public boolean isToResetImage() {
        return this.toResetImage;
    }

    public void setToResetImage(boolean toResetImage) {
        this.toResetImage = toResetImage;
    }

    public RadarSession getRadarSession() {
        return this.radarSession;
    }

    public void cleanup() {
        this.minimapWriter.cleanup();
    }

    public boolean isManualCaveMode() {
        return this.manualCaveMode || this.modMain.getSupportMods().shouldUseWorldMapCaveChunks() && this.modMain.getSupportMods().worldmapSupport.getManualCaveStart() != Integer.MAX_VALUE;
    }

    public void toggleManualCaveMode() {
        this.manualCaveMode = !this.isManualCaveMode();
    }

    public Minimap getMinimap() {
        return this.minimap;
    }

    public boolean getNoMinimapMessageReceived() {
        if (HudMod.INSTANCE.getHudConfigs().getClientConfigManager().getServerSynced().isChannelPresentOnServer()) {
            return false;
        }
        return this.noMinimapMessageReceived;
    }

    public void setNoMinimapMessageReceived(boolean noMinimapMessageReceived) {
        this.noMinimapMessageReceived = noMinimapMessageReceived;
    }

    public boolean getForcedFairPlay() {
        return this.fairPlayOnlyMessageReceived;
    }

    public void setFairPlayOnlyMessageReceived(boolean fairPlayOnlyMessageReceived) {
        this.fairPlayOnlyMessageReceived = fairPlayOnlyMessageReceived;
    }

    public ClientSyncedTrackedPlayerManager getSyncedTrackedPlayerManager() {
        return this.syncedTrackedPlayerManager;
    }

    public boolean serverHasMod() {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return worldData != null && worldData.serverLevelId != null;
    }

    public void setServerModNetworkVersion(int networkVersion) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        if (worldData == null) {
            return;
        }
        worldData.setServerModNetworkVersion(networkVersion);
    }

    public int getServerModNetworkVersion() {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        if (worldData == null) {
            return 0;
        }
        return worldData.getServerModNetworkVersion();
    }

    public double getLastMapDimensionScale() {
        return this.lastMapDimensionScale;
    }

    public void setLastMapDimensionScale(double lastMapDimensionScale) {
        this.lastMapDimensionScale = lastMapDimensionScale;
    }

    public class_5321<class_1937> getLastMapDimension() {
        return this.lastMapDimension;
    }

    public void setLastMapDimension(class_5321<class_1937> lastMapDimension) {
        this.lastMapDimension = lastMapDimension;
    }

    public MinimapSession getSession() {
        return this.minimapSession;
    }

    public void updateMinimapItem() {
        class_2960 minimapItemRL;
        String minimapItemString = ((String)HudMod.INSTANCE.getHudConfigs().getClientConfigManager().getEffective(MinimapProfiledConfigOptions.MINIMAP_ITEM)).trim();
        if (minimapItemString.isEmpty() || minimapItemString.equals("-")) {
            this.minimapItem = null;
            MinimapLogs.LOGGER.info("Minimap required item set to nothing.");
            return;
        }
        try {
            minimapItemRL = class_2960.method_60654((String)minimapItemString);
        }
        catch (class_151 rle) {
            this.minimapItem = null;
            MinimapLogs.LOGGER.error("Tried setting the minimap required item to a misformatted ID: {}; Error: {}", (Object)minimapItemString, (Object)rle.getMessage());
            return;
        }
        this.minimapItem = (class_1792)class_7923.field_41178.method_63535(minimapItemRL);
        if (this.minimapItem == class_1802.field_8162) {
            this.minimapItem = null;
            MinimapLogs.LOGGER.error("Tried setting the minimap required item to an invalid ID: {}", (Object)minimapItemString);
            return;
        }
        MinimapLogs.LOGGER.info("Minimap item set: " + this.minimapItem.method_63680().getString());
    }

    public class_1792 getMinimapItem() {
        return this.minimapItem;
    }

    public void setConsideringNetherFairPlayMessage(boolean consideringNetherFairPlay) {
        this.consideringNetherFairPlayMessage = consideringNetherFairPlay;
    }

    public boolean isConsideringNetherFairPlayMessage() {
        return this.consideringNetherFairPlayMessage;
    }

    public MinimapPipRenderState getRenderState() {
        return this.renderState;
    }

    public MinimapPipRenderState.Enlarged getEnlargedRenderState() {
        return this.enlargedRenderState;
    }
}

