/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiMinimapSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.lib.client.gui.CustomSettingEntry;
import xaero.lib.client.gui.GuiConstants;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.util.ConfigConstants;
import xaero.lib.common.gui.widget.TooltipInfo;

public class GuiMinimapBlockMapSettings
extends GuiMinimapSettings {
    public GuiMinimapBlockMapSettings(final IXaeroMinimap modMain, GuiScreen backScreen, GuiScreen escScreen, final IEditConfigScreenContext context) {
        super((ITextComponent)new TextComponentTranslation("gui.xaero_minimap_block_map_settings", new Object[0]), backScreen, escScreen, context);
        CustomSettingEntry ignoreHeightmapsEntry = new CustomSettingEntry(new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return false;
            }
        }, (ITextComponent)new TextComponentTranslation("gui.xaero_ignore_heightmaps", new Object[0]), context.isClientSide() ? new TooltipInfo("gui.xaero_box_ignore_heightmaps") : new TooltipInfo(GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT, false, true), false, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
                if (session == null) {
                    return null;
                }
                MinimapWorldRootContainer currentRootContainer = session.getWorldManager().getAutoRootContainer();
                return currentRootContainer.getConfig().isIgnoreHeightmaps();
            }
        }, 0, 1, (IntFunction)new IntFunction<Boolean>(){

            @Override
            public Boolean apply(int i) {
                return i == 1;
            }
        }, (Function)new Function<Boolean, ITextComponent>(){

            @Override
            public ITextComponent apply(Boolean v) {
                if (modMain.getSupportMods().shouldUseWorldMapChunks()) {
                    return new TextComponentTranslation("gui.xaero_world_map", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
                }
                return v != false ? ConfigConstants.ON : ConfigConstants.OFF;
            }
        }, (BiConsumer)new BiConsumer<Boolean, Boolean>(){

            @Override
            public void accept(Boolean oldValue, Boolean newValue) {
                if (modMain.getSupportMods().shouldUseWorldMapChunks()) {
                    modMain.getSupportMods().worldmapSupport.openSettings();
                    return;
                }
                MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
                if (session == null) {
                    return;
                }
                MinimapWorldRootContainer currentRootContainer = session.getWorldManager().getAutoRootContainer();
                currentRootContainer.getConfig().setIgnoreHeightmaps(newValue);
                currentRootContainer.getSession().getWorldManagerIO().getRootConfigIO().save(currentRootContainer);
            }
        }, new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return context.isClientSide() && BuiltInHudModules.MINIMAP.getCurrentSession() != null;
            }
        });
        this.entries = new ISettingEntry[]{this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.BLOCK_COLORS), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.BIOMES_IN_VANILLA_COLORS), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.CAVE_MODE_ALLOWED), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.BIOME_BLENDING), this.optionEntry(MinimapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.AUTO_CAVE_MODE), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.CAVE_MODE_DEPTH), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.MANUAL_CAVE_MODE_START), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.LEGIBLE_CAVE_MAPS), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.CAVE_MODE_TOGGLE_TIMER), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_WORLD_MAP_CHUNKS), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.TERRAIN_DEPTH), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_REDSTONE), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.TERRAIN_SLOPES), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_FLOWERS), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.BLOCK_TRANSPARENCY), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_STAINED_GLASS), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS), ignoreHeightmapsEntry, this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.ANTI_ALIASING)};
    }
}

