/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.waypoint.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.effect.Effects;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointUtil;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointGuiRenderContext;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.misc.Misc;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.config.util.MinimapConfigClientUtils;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointPurpose;
import xaero.hud.minimap.waypoint.WaypointSession;
import xaero.hud.minimap.waypoint.render.WaypointDeleter;
import xaero.hud.minimap.waypoint.render.WaypointMapRenderContext;
import xaero.hud.minimap.waypoint.render.WaypointReader;
import xaero.hud.minimap.waypoint.render.WaypointRenderProvider;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.render.TextureLocations;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.option.IndexedConfigOption;

public abstract class WaypointMapRenderer
extends MinimapElementRenderer<Waypoint, WaypointMapRenderContext> {
    private MinimapRendererHelper helper;
    private int scale;
    private boolean temporaryWaypointsGlobal;
    private double waypointsDistance;
    private boolean dimensionScaleDistance;
    private int opacity;

    protected WaypointMapRenderer(WaypointReader elementReader, WaypointRenderProvider provider, WaypointMapRenderContext context) {
        super(elementReader, provider, context);
    }

    @Override
    public boolean renderElement(Waypoint w, boolean highlighted, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo) {
        double waypointPosDivider = renderInfo.backgroundCoordinateScale / ((WaypointMapRenderContext)this.context).dimCoordinateScale;
        double wX = (double)w.getX(waypointPosDivider) + 0.5;
        double wZ = (double)w.getZ(waypointPosDivider) + 0.5;
        double offX = wX - renderInfo.renderPos.field_72450_a;
        double offZ = wZ - renderInfo.renderPos.field_72449_c;
        double distance2D = Math.sqrt(offX * offX + offZ * offZ);
        double distanceScale = this.dimensionScaleDistance ? renderInfo.backgroundCoordinateScale : 1.0;
        double scaledDistance2D = distance2D * distanceScale;
        if (!(w.isDestination() || w.getPurpose() == WaypointPurpose.DEATH || w.isGlobal() || w.isTemporary() && this.temporaryWaypointsGlobal || this.waypointsDistance == 0.0 || !(scaledDistance2D > this.waypointsDistance))) {
            return false;
        }
        MinimapElementRenderLocation location = renderInfo.location;
        GlStateManager.func_179137_b((double)-1.0, (double)-1.0, (double)optionalDepth);
        if (this.scale <= 0 || location != MinimapElementRenderLocation.OVER_MINIMAP) {
            GlStateManager.func_179152_a((float)optionalScale, (float)optionalScale, (float)1.0f);
        } else {
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
        }
        this.drawIconOnGUI(this.helper, w, 0, 0, this.opacity);
        return true;
    }

    @Override
    public void preRender(MinimapElementRenderInfo renderInfo) {
        this.helper = HudMod.INSTANCE.getMinimap().getMinimapFBORenderer().getHelper();
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorld currentWorld = session.getWorldManager().getCurrentWorld();
        ((WaypointMapRenderContext)this.context).dimCoordinateScale = session.getDimensionHelper().getDimCoordinateScale(currentWorld);
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        this.scale = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINT_ICON_SCALE_ON_MINIMAP);
        if (this.scale > 0) {
            this.scale = (int)MinimapConfigClientUtils.getUIScale(configManager, (IndexedConfigOption<Integer>)MinimapProfiledConfigOptions.WAYPOINT_ICON_SCALE_ON_MINIMAP, renderInfo.scaledResolution.func_78325_e());
        }
        this.temporaryWaypointsGlobal = (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.TEMPORARY_WAYPOINTS_GLOBAL);
        this.waypointsDistance = ((Integer)configManager.getEffective(MinimapProfiledConfigOptions.WAYPOINT_MAX_DISTANCE)).intValue();
        this.dimensionScaleDistance = (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINT_MAX_DISTANCE_DIMENSION_SCALE);
        this.opacity = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINT_OPACITY_ON_MINIMAP);
    }

    @Override
    public void postRender(MinimapElementRenderInfo renderInfo) {
    }

    @Deprecated
    public void updateWaypointCollection() {
    }

    @Deprecated
    public void drawIconOnGUI(MinimapRendererHelper rendererHelper, Waypoint w, int drawX, int drawY) {
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        int opacity = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINT_OPACITY_ON_MINIMAP);
        this.drawIconOnGUI(rendererHelper, w, drawX, drawY, opacity);
    }

    public void drawIconOnGUI(MinimapRendererHelper rendererHelper, Waypoint w, int drawX, int drawY, int opacity) {
        int color = w.getWaypointColor().getHex();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float a = (float)opacity / 100.0f;
        color = (int)(a * 255.0f) << 24 | r << 16 | g << 8 | b;
        int initialsWidth = w.getPurpose() == WaypointPurpose.DEATH ? 7 : Minecraft.func_71410_x().field_71466_p.func_78256_a(w.getInitials());
        int addedFrame = WaypointUtil.getAddedMinimapIconFrame(initialsWidth);
        int rectX1 = drawX - 4 - addedFrame;
        int rectY1 = drawY - 4;
        int rectX2 = drawX + 5 + addedFrame;
        int rectY2 = drawY + 5;
        Gui.func_73734_a((int)rectX1, (int)rectY1, (int)rectX2, (int)rectY2, (int)color);
        if (w.getPurpose() == WaypointPurpose.DEATH) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureLocations.GUI_TEXTURES);
            GlStateManager.func_179131_c((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(rectX1 + 1, rectY1 + 1, 0, 78, 9, 9);
            GlStateManager.func_179131_c((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(rectX1, rectY1, 0, 78, 9, 9);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return;
        }
        GlStateManager.func_179097_i();
        Minecraft.func_71410_x().field_71466_p.func_175063_a(w.getInitials(), (float)(drawX + 1 - initialsWidth / 2), (float)(drawY - 3), -1);
    }

    @Deprecated
    public void drawSetChange(WaypointsManager waypointsManager, ScaledResolution res) {
        this.drawSetChange((MinimapSession)waypointsManager, res);
    }

    public void drawSetChange(MinimapSession session, ScaledResolution res) {
        MinimapWorld minimapWorld = session.getWorldManager().getCurrentWorld();
        if (minimapWorld == null) {
            return;
        }
        WaypointSession waypointSession = session.getWaypointSession();
        if (waypointSession.getSetChangedTime() == 0L) {
            return;
        }
        int passed = (int)(System.currentTimeMillis() - waypointSession.getSetChangedTime());
        if (passed >= 1500) {
            waypointSession.setSetChangedTime(0L);
            return;
        }
        int fadeTime = 300;
        boolean fading = passed > 1500 - fadeTime;
        float fadeFactor = fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f;
        int alpha = 3 + (int)(252.0f * fadeFactor);
        int c = 0xFFFFFF | alpha << 24;
        GlStateManager.func_179097_i();
        Minecraft.func_71410_x().field_71456_v.func_73732_a(Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)minimapWorld.getCurrentWaypointSet().getName(), (Object[])new Object[0]), res.func_78326_a() / 2, res.func_78328_b() / 2 + 50, c);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    @Override
    public boolean shouldRender(MinimapElementRenderLocation location) {
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        if (!(location != MinimapElementRenderLocation.OVER_MINIMAP && location != MinimapElementRenderLocation.IN_MINIMAP || ((Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINTS_ON_MINIMAP)).booleanValue())) {
            return false;
        }
        return !Misc.hasEffect(Effects.NO_WAYPOINTS) && !Misc.hasEffect(Effects.NO_WAYPOINTS_HARMFUL);
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public static final class Builder {
        private WaypointDeleter waypointDeleter;
        private final IXaeroMinimap modMain;

        private Builder(IXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        private Builder setDefault() {
            this.setWaypointDeleter(null);
            return this;
        }

        public Builder setWaypointDeleter(WaypointDeleter waypointDeleter) {
            this.waypointDeleter = waypointDeleter;
            return this;
        }

        public WaypointMapRenderer build() {
            if (this.waypointDeleter == null) {
                throw new IllegalStateException();
            }
            WaypointGuiRenderContext context = new WaypointGuiRenderContext();
            return new WaypointsGuiRenderer(new xaero.common.minimap.waypoints.render.WaypointReader(), new xaero.common.minimap.waypoints.render.WaypointRenderProvider(), context);
        }

        public static Builder begin(IXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

