/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.node.options.text;

import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import xaero.common.misc.ListFactory;
import xaero.hud.category.ui.node.options.EditorOptionNode;

public final class TextFieldSuggestionsResolver {
    private ListFactory listFactory;

    private TextFieldSuggestionsResolver(@Nonnull ListFactory listFactory) {
        this.listFactory = listFactory;
    }

    public List<EditorOptionNode<String>> getSuggestions(String input, List<EditorOptionNode<String>> allOptions) {
        if (input.isEmpty()) {
            return this.listFactory.get();
        }
        final String lowerCaseInput = input.toLowerCase();
        List<EditorOptionNode<String>> result = allOptions.stream().filter(new Predicate<EditorOptionNode<String>>(){

            @Override
            public boolean test(EditorOptionNode<String> o) {
                return o.getValue() != null && o.getValue().toString().toLowerCase().contains(lowerCaseInput);
            }
        }).sorted(new Comparator<EditorOptionNode<String>>(){

            @Override
            public int compare(EditorOptionNode<String> o1, EditorOptionNode<String> o2) {
                boolean secondStarts;
                boolean firstStarts = o1.getValue().toString().toLowerCase().startsWith(lowerCaseInput);
                return firstStarts == (secondStarts = o2.getValue().toString().toLowerCase().startsWith(lowerCaseInput)) ? 0 : (firstStarts ? -1 : 1);
            }
        }).limit(100L).collect(new Supplier<List<EditorOptionNode<String>>>(){

            @Override
            public List<EditorOptionNode<String>> get() {
                return TextFieldSuggestionsResolver.this.listFactory.get();
            }
        }, new BiConsumer<List<EditorOptionNode<String>>, EditorOptionNode<String>>(){

            @Override
            public void accept(List<EditorOptionNode<String>> l, EditorOptionNode<String> e) {
                l.add(e);
            }
        }, new BiConsumer<List<EditorOptionNode<String>>, List<EditorOptionNode<String>>>(){

            @Override
            public void accept(List<EditorOptionNode<String>> l1, List<EditorOptionNode<String>> l2) {
                l1.addAll(l2);
            }
        });
        return result;
    }

    public static final class Builder {
        private final ListFactory listFactory;

        private Builder(ListFactory listFactory) {
            this.listFactory = listFactory;
        }

        public Builder setDefault() {
            return this;
        }

        public TextFieldSuggestionsResolver build() {
            if (this.listFactory == null) {
                throw new IllegalStateException("required fields not set!");
            }
            return new TextFieldSuggestionsResolver(this.listFactory);
        }

        public static Builder begin(ListFactory listFactory) {
            return new Builder(listFactory).setDefault();
        }
    }
}

