/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import java.nio.file.Path;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import xaero.common.HudMod;
import xaero.common.server.MinecraftServerData;
import xaero.common.server.MineraftServerDataInitializer;
import xaero.common.server.level.LevelMapProperties;
import xaero.common.server.level.LevelMapPropertiesIO;
import xaero.common.server.player.IServerPlayer;
import xaero.common.server.player.ServerPlayerData;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.packet.basic.ClientboundRulesPacket;
import xaero.hud.packet.basic.HandshakePacket;
import xaero.hud.packet.tracker.ClientboundPlayerTrackerResetPacket;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.profile.ConfigProfile;
import xaero.lib.common.config.server.ServerConfigManager;

public class CommonEvents {
    private final HudMod modMain;

    public CommonEvents(HudMod modMain) {
        this.modMain = modMain;
    }

    public void register() {
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity oldPlayer = event.getOriginal();
        if (oldPlayer instanceof ServerPlayerEntity) {
            PlayerEntity newPlayer = event.getPlayer();
            ((IServerPlayer)newPlayer).setXaeroMinimapPlayerData(ServerPlayerData.get((ServerPlayerEntity)oldPlayer));
        }
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        if (!this.modMain.isFirstStageLoaded()) {
            return;
        }
        new MineraftServerDataInitializer().init(event.getServer(), this.modMain);
    }

    @SubscribeEvent
    public void onServerStopped(FMLServerStoppedEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!this.modMain.isFirstStageLoaded()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            this.modMain.getMessageHandler().sendToPlayer((ServerPlayerEntity)player, (Object)new ClientboundPlayerTrackerResetPacket());
        }
    }

    public void onPlayerWorldJoin(ServerPlayerEntity player) {
        if (!this.modMain.isFirstStageLoaded()) {
            return;
        }
        this.modMain.getMessageHandler().sendToPlayer(player, (Object)new HandshakePacket());
        ServerConfigManager configManager = this.modMain.getHudConfigs().getServerConfigManager();
        ConfigProfile defaultEnforcedProfile = configManager.getDefaultEnforcedProfile();
        boolean caveModeConfig = !Boolean.FALSE.equals(defaultEnforcedProfile.get((ConfigOption)MinimapProfiledConfigOptions.CAVE_MODE_ALLOWED));
        Set caveModeDimensionsConfig = (Set)defaultEnforcedProfile.get(MinimapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS);
        boolean allowOverworldCaveModeOnServer = caveModeConfig && (caveModeDimensionsConfig == null || caveModeDimensionsConfig.isEmpty() || caveModeDimensionsConfig.contains(World.OVERWORLD.location()));
        boolean allowNetherCaveModeOnServer = caveModeConfig && (caveModeDimensionsConfig == null || caveModeDimensionsConfig.isEmpty() || caveModeDimensionsConfig.contains(World.NETHER.location()));
        boolean radarConfig = !Boolean.FALSE.equals(defaultEnforcedProfile.get((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_RADAR));
        this.modMain.getMessageHandler().sendToPlayer(player, (Object)new ClientboundRulesPacket(allowOverworldCaveModeOnServer, allowNetherCaveModeOnServer, radarConfig));
        Path propertiesPath = player.level.getServer().getWorldPath(LevelMapPropertiesIO.FILE_NAME);
        try {
            MinecraftServerData serverData = MinecraftServerData.get(player.getServer());
            LevelMapProperties properties = serverData.getLevelProperties(propertiesPath);
            this.modMain.getMessageHandler().sendToPlayer(player, (Object)properties);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("suppressed exception", t);
            player.connection.disconnect((ITextComponent)new TranslationTextComponent("gui.xaero_error_loading_properties"));
        }
    }

    @SubscribeEvent
    public void handlePlayerTickStart(TickEvent.PlayerTickEvent event) {
        if (!this.modMain.isFirstStageLoaded()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        PlayerEntity player = event.player;
        if (player instanceof ServerPlayerEntity) {
            this.modMain.getServerPlayerTickHandler().tick((ServerPlayerEntity)player);
            return;
        }
    }
}

