/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import xaero.hud.render.TextureLocations;
import xaero.lib.client.graphics.XaeroRenderType;

public class CustomRenderTypes
extends RenderType {
    public static final RenderType GUI_BILINEAR;
    public static final RenderType GUI_BILINEAR_PREMULTIPLIED;
    public static final RenderType GUI_BILINEAR_NO_DEPTH;
    public static final RenderType GUI_NEAREST;
    public static final RenderType COLORED_WAYPOINTS_BGS;
    public static final RenderType MAP_CHUNK_OVERLAY;
    public static final RenderType MAP_LINES;
    public static final RenderType RADAR_NAME_BGS;
    public static final RenderType DEPTH_CLEAR;

    public static RenderType entityIconRenderType(ResourceLocation texture, EntityIconLayerPhases layerPhases) {
        ImmutableList rendertype$state = new XaeroRenderType.MultiPhaseBuilder().texture(layerPhases.texture).transparency(layerPhases.transparency).depthTest(layerPhases.depthTest).writeMaskState(layerPhases.writeMask).diffuseLighting(NO_DIFFUSE_LIGHTING).alpha(DEFAULT_ALPHA).cull(layerPhases.cull).lightmap(LIGHTMAP).overlay(OVERLAY).target(XaeroRenderType.KEEP_TARGET).fog(NO_FOG).build();
        return new XaeroRenderType.MultiPhaseRenderType("xaero_entity_icon", DefaultVertexFormats.NEW_ENTITY, 7, 256, true, true, rendertype$state);
    }

    public CustomRenderTypes(String name, VertexFormat vertexFormat, int drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static EntityIconLayerPhases getBasicEntityIconLayerPhases(ResourceLocation texture) {
        return new EntityIconLayerPhases(new RenderState.TextureState(texture, true, false), TRANSLUCENT_TRANSPARENCY, LEQUAL_DEPTH_TEST, COLOR_DEPTH_WRITE, NO_CULL);
    }

    static {
        ImmutableList multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().texture(new RenderState.TextureState(TextureLocations.GUI_TEXTURES, false, false)).transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).diffuseLighting(NO_DIFFUSE_LIGHTING).alpha(XaeroRenderType.ALMOST_ZERO_ALPHA).cull(NO_CULL).target(XaeroRenderType.KEEP_TARGET).fog(NO_FOG).build();
        GUI_NEAREST = new XaeroRenderType.MultiPhaseRenderType("xaero_gui_nearest", DefaultVertexFormats.POSITION_TEX_COLOR, 7, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().texture(new RenderState.TextureState(TextureLocations.GUI_TEXTURES, true, false)).transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).diffuseLighting(NO_DIFFUSE_LIGHTING).alpha(XaeroRenderType.ALMOST_ZERO_ALPHA).cull(NO_CULL).target(XaeroRenderType.KEEP_TARGET).fog(NO_FOG).build();
        GUI_BILINEAR = new XaeroRenderType.MultiPhaseRenderType("xaero_gui_bilinear", DefaultVertexFormats.POSITION_TEX_COLOR, 7, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().texture(new RenderState.TextureState(TextureLocations.GUI_TEXTURES, true, false)).transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).diffuseLighting(NO_DIFFUSE_LIGHTING).alpha(XaeroRenderType.ALMOST_ZERO_ALPHA).cull(NO_CULL).target(XaeroRenderType.KEEP_TARGET).fog(NO_FOG).depthTest(NO_DEPTH_TEST).build();
        GUI_BILINEAR_NO_DEPTH = new XaeroRenderType.MultiPhaseRenderType("xaero_gui_bilinear_no_depth", DefaultVertexFormats.POSITION_COLOR_TEX, 7, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().texture(new RenderState.TextureState(TextureLocations.GUI_TEXTURES, true, false)).transparency(XaeroRenderType.PREMULTIPLIED_TRANSPARENCY).diffuseLighting(NO_DIFFUSE_LIGHTING).alpha(XaeroRenderType.ALMOST_ZERO_ALPHA).cull(NO_CULL).target(XaeroRenderType.KEEP_TARGET).fog(NO_FOG).build();
        GUI_BILINEAR_PREMULTIPLIED = new XaeroRenderType.MultiPhaseRenderType("xaero_gui_bilinear_pre", DefaultVertexFormats.POSITION_COLOR_TEX, 7, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).diffuseLighting(NO_DIFFUSE_LIGHTING).alpha(XaeroRenderType.ALMOST_ZERO_ALPHA).target(XaeroRenderType.KEEP_TARGET).layering(XaeroRenderType.DEFAULT_POLYGON_OFFSET_LAYERING).fog(NO_FOG).build();
        COLORED_WAYPOINTS_BGS = new XaeroRenderType.MultiPhaseRenderType("xaero_colored_waypoints", DefaultVertexFormats.POSITION_COLOR, 7, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).diffuseLighting(NO_DIFFUSE_LIGHTING).alpha(XaeroRenderType.ALMOST_ZERO_ALPHA).target(XaeroRenderType.KEEP_TARGET).layering(XaeroRenderType.DEFAULT_POLYGON_OFFSET_LAYERING).fog(NO_FOG).build();
        RADAR_NAME_BGS = new XaeroRenderType.MultiPhaseRenderType("xaero_radar_name_bg", DefaultVertexFormats.POSITION_COLOR, 7, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).diffuseLighting(NO_DIFFUSE_LIGHTING).alpha(XaeroRenderType.ALMOST_ZERO_ALPHA).target(XaeroRenderType.KEEP_TARGET).fog(NO_FOG).build();
        MAP_CHUNK_OVERLAY = new XaeroRenderType.MultiPhaseRenderType("xaero_chunk_overlay", DefaultVertexFormats.POSITION_COLOR, 7, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().transparency(XaeroRenderType.LINES_TRANSPARENCY).diffuseLighting(NO_DIFFUSE_LIGHTING).alpha(XaeroRenderType.ALMOST_ZERO_ALPHA).target(XaeroRenderType.KEEP_TARGET).fog(NO_FOG).build();
        MAP_LINES = new XaeroRenderType.MultiPhaseRenderType("xaero_lines", DefaultVertexFormats.POSITION_COLOR, 1, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).target(XaeroRenderType.KEEP_TARGET).depthTest(XaeroRenderType.GREATER_DEPTH_TEST).alpha(NO_ALPHA).writeMaskState(DEPTH_WRITE).build();
        DEPTH_CLEAR = new XaeroRenderType.MultiPhaseRenderType("xaero_depth_clear", DefaultVertexFormats.POSITION_COLOR, 7, 256, false, false, multiPhaseParameters);
    }

    public static class EntityIconLayerPhases {
        public RenderState.TextureState texture;
        public RenderState.TransparencyState transparency;
        public RenderState.DepthTestState depthTest;
        public RenderState.WriteMaskState writeMask;
        public RenderState.CullState cull;

        public EntityIconLayerPhases(RenderState.TextureState texture, RenderState.TransparencyState transparency, RenderState.DepthTestState depthTest, RenderState.WriteMaskState writeMask, RenderState.CullState cull) {
            this.texture = texture;
            this.transparency = transparency;
            this.depthTest = depthTest;
            this.writeMask = writeMask;
            this.cull = cull;
        }
    }
}

