/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiChoosePreset;
import xaero.common.gui.GuiInstructions;
import xaero.hud.module.HudModule;
import xaero.hud.module.ModuleManager;
import xaero.hud.module.ModuleSession;
import xaero.hud.module.ModuleTransform;
import xaero.hud.preset.HudPreset;
import xaero.hud.pushbox.PushboxHandler;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.client.gui.widget.Tooltip;

public class GuiEditMode
extends ScreenBase {
    public static final ITextComponent CENTERED_COMPONENT = new TranslationTextComponent("gui.xaero_centered");
    public static final ITextComponent FLIPPED_COMPONENT = new TranslationTextComponent("gui.xaero_flipped");
    public static final ITextComponent TRUE_COMPONENT = new TranslationTextComponent("gui.yes");
    public static final ITextComponent FALSE_COMPONENT = new TranslationTextComponent("gui.no");
    public static final ITextComponent PRESS_C_COMPONENT = new TranslationTextComponent("gui.xaero_press_c");
    public static final ITextComponent PRESS_F_COMPONENT = new TranslationTextComponent("gui.xaero_press_f");
    public static final ITextComponent NOT_INGAME = new TranslationTextComponent("gui.xaero_not_ingame");
    private final int NORMAL_COLOR = 1354612157;
    private final int HOVERED_COLOR = 0x64FFFFFF;
    private final int SELECTED_COLOR = -2097152001;
    private final boolean instructions;
    private final ITextComponent message;
    private HudModule<?> draggedModule;
    private HudModule<?> selectedModule;
    private HudModule<?> lastFrameHoveredModule;
    private int dragOffsetX;
    private int dragOffsetY;
    private final IXaeroMinimap modMain;

    public GuiEditMode(IXaeroMinimap modMain, Screen parent, Screen escape, boolean instructions, ITextComponent message) {
        super(parent, escape, (ITextComponent)new TranslationTextComponent("gui.xaero_edit_mode"));
        this.modMain = modMain;
        this.instructions = instructions;
        this.message = message;
    }

    protected void init() {
        super.init();
        this.draggedModule = null;
        this.selectedModule = null;
        this.addButton((Widget)new MySmallButton(200, this.width / 2 - 155, this.height / 6 + 143, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm"), b -> this.confirm()));
        this.addButton((Widget)new MySmallButton(202, this.width / 2 + 5, this.height / 6 + 143, (ITextComponent)new TranslationTextComponent("gui.xaero_choose_a_preset"), b -> this.minecraft.setScreen((Screen)new GuiChoosePreset(this.modMain, (Screen)this, this.escape))));
        if (this.instructions) {
            this.addButton((Widget)new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_cancel"), b -> this.cancel()));
            this.addButton((Widget)new MySmallButton(203, this.width / 2 - 155, this.height / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_instructions"), b -> this.minecraft.setScreen((Screen)new GuiInstructions(this.modMain, (Screen)this, this.escape))));
            return;
        }
        this.addButton((Widget)new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_cancel"), b -> this.cancel()));
    }

    private void confirm() {
        for (HudPreset hudPreset : this.modMain.getHud().getPresetManager().getPresets()) {
            hudPreset.confirm();
        }
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        for (HudModule<?> hudModule : manager.getModules()) {
            hudModule.confirmTransform();
        }
        try {
            this.modMain.getSettings().saveSettings();
        }
        catch (IOException iOException) {
            HudMod.LOGGER.error("suppressed exception", (Throwable)iOException);
        }
        this.minecraft.setScreen(this.parent);
    }

    private void cancel() {
        for (HudPreset preset : this.modMain.getHud().getPresetManager().getPresets()) {
            preset.cancel();
        }
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        for (HudModule<?> module : manager.getModules()) {
            module.cancelTransform();
        }
        this.goBack();
    }

    private void applyPushes() {
        double screenScale = this.minecraft.getWindow().getGuiScale();
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        for (HudModule<?> module : manager.getModules()) {
            Object session = module.getCurrentSession();
            if (!((ModuleSession)session).isActive()) continue;
            PushboxHandler.State pushState = module.getPushState();
            pushState.resetForModule((ModuleSession<?>)session, this.width, this.height, screenScale);
            this.modMain.getHudRenderer().getPushboxHandler().applyScreenEdges(pushState, this.width, this.height, screenScale);
        }
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.minecraft.player == null) {
            super.renderBackground(matrixStack);
            GuiEditMode.drawCenteredString((MatrixStack)matrixStack, (FontRenderer)this.font, (ITextComponent)NOT_INGAME, (int)(this.width / 2), (int)(this.height / 6 + 128), (int)0xFFFFFF);
        } else {
            GuiEditMode.drawCenteredString((MatrixStack)matrixStack, (FontRenderer)this.font, (ITextComponent)this.message, (int)(this.width / 2), (int)(this.height / 6 + 128), (int)0xFFFFFF);
        }
        if (XaeroMinimapSession.getCurrentSession() == null) {
            super.render(matrixStack, mouseX, mouseY, partialTicks);
            return;
        }
        double screenScale = this.minecraft.getWindow().getGuiScale();
        this.handleDraggedModule(mouseX, mouseY, screenScale);
        this.applyPushes();
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        this.lastFrameHoveredModule = this.getHoveredModule(mouseX, mouseY);
        HudModule<?> hoveredModule = this.lastFrameHoveredModule;
        for (HudModule<?> module : manager.getModules()) {
            if (!((ModuleSession)module.getCurrentSession()).isActive()) continue;
            this.renderModuleBox(module, hoveredModule, screenScale, matrixStack);
        }
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        if (hoveredModule != null && this.draggedModule == null) {
            Tooltip tooltip = new Tooltip(this.getTooltipText(hoveredModule));
            tooltip.setStartWidth(150);
            matrixStack.translate(0.0, 0.0, 1.0);
            tooltip.drawBox(matrixStack, mouseX, mouseY, this.width, this.height);
            matrixStack.translate(0.0, 0.0, -1.0);
        }
    }

    private <MS extends ModuleSession<MS>> void renderModuleBox(HudModule<MS> module, HudModule<?> hoveredModule, double screenScale, MatrixStack matrixStack) {
        MS session = module.getCurrentSession();
        int moduleW = ((ModuleSession)session).getWidth(screenScale);
        int moduleH = ((ModuleSession)session).getHeight(screenScale);
        boolean hovered = hoveredModule == module;
        PushboxHandler.State pushState = module.getPushState();
        int boxX = pushState.x;
        int boxY = pushState.y;
        GuiEditMode.fill((MatrixStack)matrixStack, (int)boxX, (int)boxY, (int)(boxX + moduleW), (int)(boxY + moduleH), (int)(this.selectedModule == module ? -2097152001 : (hovered ? 0x64FFFFFF : 1354612157)));
    }

    private HudModule<?> getHoveredModule(int mouseX, int mouseY) {
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        HudModule<?> result = null;
        int resultSize = 0;
        for (HudModule<?> module : manager.getModules()) {
            if (!((ModuleSession)module.getCurrentSession()).isActive() || !this.isHovered(module, mouseX, mouseY)) continue;
            int moduleW = module.getPushState().w;
            int moduleH = module.getPushState().h;
            if (module != this.selectedModule && result != null && moduleW * moduleH > resultSize) continue;
            result = module;
            resultSize = moduleW * moduleH;
        }
        return result;
    }

    private boolean isHovered(HudModule<?> module, int mouseX, int mouseY) {
        PushboxHandler.State pushState = module.getPushState();
        int boxX = pushState.x;
        int boxY = pushState.y;
        return mouseX >= boxX && mouseX < boxX + pushState.w && mouseY >= boxY && mouseY < boxY + pushState.h;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clickResult = super.mouseClicked(mouseX, mouseY, button);
        if (clickResult || XaeroMinimapSession.getCurrentSession() == null) {
            return true;
        }
        this.applyPushes();
        this.draggedModule = this.getHoveredModule((int)mouseX, (int)mouseY);
        this.selectedModule = this.draggedModule;
        if (this.draggedModule != null) {
            this.dragOffsetX = this.draggedModule.getPushState().x - (int)mouseX;
            this.dragOffsetY = this.draggedModule.getPushState().y - (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggedModule = null;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean keyPressed(int code, int $$1, int $$2) {
        HudModule<?> affectedModule;
        HudModule<?> hudModule = affectedModule = this.selectedModule != null ? this.selectedModule : this.lastFrameHoveredModule;
        if (affectedModule != null && (code == 67 || code == 70 || code == 83)) {
            ModuleTransform transform = affectedModule.getUnconfirmedTransform();
            switch (code) {
                case 67: {
                    int oldModuleY = ((ModuleSession)affectedModule.getCurrentSession()).getEffectiveY(this.height, this.minecraft.getWindow().getGuiScale());
                    boolean bl = transform.centered = !transform.centered;
                    if (this.draggedModule == null) break;
                    int newModuleY = ((ModuleSession)affectedModule.getCurrentSession()).getEffectiveY(this.height, this.minecraft.getWindow().getGuiScale());
                    this.dragOffsetY += newModuleY - oldModuleY;
                    break;
                }
                case 70: {
                    boolean curFlippedHor = transform.flippedHor;
                    transform.flippedHor = !transform.flippedVer;
                    transform.flippedVer = curFlippedHor;
                    break;
                }
                case 83: {
                    Screen configScreen = affectedModule.getConfigScreenFactory().apply((Screen)this);
                    if (configScreen == null) break;
                    this.minecraft.setScreen(configScreen);
                }
            }
        }
        return super.keyPressed(code, $$1, $$2);
    }

    private void handleDraggedModule(int mouseX, int mouseY, double screenScale) {
        if (this.draggedModule == null) {
            return;
        }
        Object session = this.draggedModule.getCurrentSession();
        if (session == null) {
            return;
        }
        ModuleTransform transform = this.draggedModule.getUnconfirmedTransform();
        transform.y = mouseY + this.dragOffsetY;
        transform.fromBottom = false;
        int moduleH = ((ModuleSession)session).getHeight(screenScale);
        int yFromBottom = this.height - transform.y - moduleH;
        if (transform.y > yFromBottom) {
            transform.fromBottom = true;
            transform.y = yFromBottom;
        }
        if (transform.centered) {
            return;
        }
        transform.x = mouseX + this.dragOffsetX;
        transform.fromRight = false;
        int moduleW = ((ModuleSession)session).getWidth(screenScale);
        int xFromRight = this.width - transform.x - moduleW;
        if (transform.x > xFromRight) {
            transform.fromRight = true;
            transform.x = xFromRight;
        }
    }

    private ITextComponent getTooltipText(HudModule<?> hoveredModule) {
        ModuleTransform transform = hoveredModule.getUnconfirmedTransform();
        TranslationTextComponent centeredLine = new TranslationTextComponent("%s %s %s", new Object[]{CENTERED_COMPONENT, transform.centered ? TRUE_COMPONENT : FALSE_COMPONENT, PRESS_C_COMPONENT});
        TranslationTextComponent flippedLine = new TranslationTextComponent("%s %s %s %s", new Object[]{FLIPPED_COMPONENT, transform.flippedHor ? TRUE_COMPONENT : FALSE_COMPONENT, transform.flippedVer ? TRUE_COMPONENT : FALSE_COMPONENT, PRESS_F_COMPONENT});
        return new TranslationTextComponent("%s \n %s \n %s", new Object[]{hoveredModule.getDisplayName(), centeredLine, flippedLine});
    }
}

