/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.HudMod;
import xaero.hud.minimap.common.config.MinimapConfigConstants;
import xaero.hud.minimap.common.config.info.config.InfoDisplayConfigData;
import xaero.hud.minimap.common.config.info.config.InfoDisplayManagerConfigData;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.info.InfoDisplay;
import xaero.hud.minimap.info.InfoDisplayManager;
import xaero.hud.minimap.info.config.InfoDisplayConfigClientUtils;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownContainer;
import xaero.lib.common.config.Config;

public class GuiInfoDisplayEdit
extends ScreenBase {
    private static final int FRAME_TOP_SIZE = 30;
    private static final int FRAME_BOTTOM_SIZE = 61;
    private static final int SELECTION_ITEM_HEIGHT = 24;
    private static final ITextComponent HELP_COMPONENT = new TranslationTextComponent("gui.xaero_minimap_info_display_manager_help");
    private static final ITextComponent SERVER_ENFORCED_COMPONENT = new TranslationTextComponent("gui.xaero_info_display_editor_server_enforced").withStyle(TextFormatting.YELLOW);
    private SelectionList selectionList;
    private final InfoDisplayManager manager;
    private List<String> currentOrder;
    private int selected;
    private int subSelected;
    private final Map<String, MoveableEntry<?>> moveableEntries;
    private final boolean clientSide;
    private InfoDisplayManagerConfigData inputConfig;
    private final Config config;
    private final Runnable onChange;
    private final boolean viewingEnforced;
    private boolean madeChanges;

    public GuiInfoDisplayEdit(EditConfigScreen parent, Screen escape, Config config, Runnable onChange, boolean viewingEnforced) {
        super((Screen)parent, escape, (ITextComponent)new TranslationTextComponent("gui.xaero_minimap_info_display_manager"));
        this.config = config;
        this.onChange = onChange;
        this.clientSide = parent.getContext().isClientSide();
        this.viewingEnforced = viewingEnforced;
        this.manager = HudMod.INSTANCE.getMinimap().getInfoDisplays().getManager();
        this.inputConfig = (InfoDisplayManagerConfigData)config.get(MinimapProfiledConfigOptions.INFO_DISPLAY_CONFIG);
        if (this.inputConfig == null || this.inputConfig == InfoDisplayManagerConfigData.EMPTY) {
            this.inputConfig = InfoDisplayConfigClientUtils.createDefaultConfig(this.manager, null, this.clientSide);
        }
        this.currentOrder = this.manager.adaptOrder(this.inputConfig.getOrderStream());
        this.moveableEntries = new HashMap();
        this.selected = -1;
        this.subSelected = -1;
    }

    protected void init() {
        super.init();
        this.selectionList = new SelectionList();
        this.addWidget((IGuiEventListener)this.selectionList);
        this.addButton((Widget)new Button(this.width / 2 - 100, this.height - 34, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done", new Object[0]), b -> this.goBack()));
        if (this.moveableEntries.isEmpty()) {
            for (String id : this.currentOrder) {
                InfoDisplay<?> infoDisplay = this.manager.get(id);
                MoveableEntry<?> moveable = this.createEntryFor(infoDisplay);
                this.moveableEntries.put(id, moveable);
            }
        }
        this.moveableEntries.values().forEach(this::refreshEntry);
    }

    private <T> MoveableEntry<T> createEntryFor(InfoDisplay<T> infoDisplay) {
        MoveableEntry<T> moveable = new MoveableEntry<T>(infoDisplay);
        InfoDisplayConfigData infoDisplayConfig = this.inputConfig.get(infoDisplay.getId());
        if (infoDisplayConfig == null) {
            infoDisplayConfig = InfoDisplayConfigClientUtils.createDefaultConfig(infoDisplay, null, this.clientSide);
        }
        String configStateString = infoDisplayConfig.getState();
        ((MoveableEntry)moveable).textColor = infoDisplayConfig.getTextColor();
        ((MoveableEntry)moveable).backgroundColor = infoDisplayConfig.getBackgroundColor();
        ((MoveableEntry)moveable).state = configStateString == null ? null : infoDisplay.getCodec().decode(configStateString, null, null);
        return moveable;
    }

    private <T> void refreshEntry(MoveableEntry<T> moveable) {
        ((MoveableEntry)moveable).clearSubElements();
        this.addSubElements(moveable);
    }

    public void onExit(Screen screen) {
        super.onExit(screen);
        if (this.madeChanges) {
            this.onChange.run();
        }
    }

    private void saveToConfigProfile() {
        InfoDisplayManagerConfigData.Builder builder = InfoDisplayManagerConfigData.Builder.begin();
        for (String id : this.currentOrder) {
            MoveableEntry<?> editorEntry = this.moveableEntries.get(id);
            String stateString = this.encodeState(editorEntry);
            builder.add(id, new InfoDisplayConfigData(((MoveableEntry)editorEntry).backgroundColor, ((MoveableEntry)editorEntry).textColor, stateString));
        }
        InfoDisplayManagerConfigData outputConfig = builder.build();
        this.config.set(MinimapProfiledConfigOptions.INFO_DISPLAY_CONFIG, (Object)outputConfig);
        this.madeChanges = true;
    }

    private <T> String encodeState(MoveableEntry<T> editorEntry) {
        return ((MoveableEntry)editorEntry).state == null ? null : ((MoveableEntry)editorEntry).infoDisplay.getCodec().encode(((MoveableEntry)editorEntry).state, null, null);
    }

    public String[] createColorOptions(String symbol, boolean noneOption, boolean nullOption) {
        int firstColorIndex = (noneOption ? 1 : 0) + (nullOption ? 1 : 0);
        String[] options = new String[MinimapConfigConstants.COLOR_NAMES.length + firstColorIndex];
        if (nullOption) {
            options[0] = "~";
        }
        if (noneOption) {
            options[firstColorIndex - 1] = "\u25a1\u25a1";
        }
        for (int i = 0; i < MinimapConfigConstants.COLOR_NAMES.length; ++i) {
            options[i + firstColorIndex] = "\u00a7" + MinimapConfigConstants.COLOR_CODES[i] + symbol;
        }
        return options;
    }

    private <T> void addSubElements(MoveableEntry<T> moveable) {
        int currentSelectedBackground;
        int currentSelectedTextColor;
        boolean includeNull;
        boolean bl = includeNull = !this.clientSide || this.viewingEnforced;
        if (!(includeNull || moveable.state != null && moveable.textColor != null && moveable.backgroundColor != null)) {
            throw new IllegalArgumentException();
        }
        Widget stateWidget = moveable.infoDisplay.createWidget(this.width / 2 + 150 - 102, 0, 100, 20, moveable, this::saveToConfigProfile, includeNull);
        if (stateWidget != null) {
            moveable.addSubElement(stateWidget);
        }
        int n = currentSelectedTextColor = moveable.textColor == null ? -1 : moveable.textColor % MinimapConfigConstants.COLOR_NAMES.length;
        if (includeNull) {
            ++currentSelectedTextColor;
        }
        if (currentSelectedTextColor < 0) {
            currentSelectedTextColor = 0;
            moveable.textColor = includeNull ? null : Integer.valueOf(0);
        }
        DropDownWidget textColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("Aa", false, includeNull)).setX(this.width / 2 - 147).setW(20).setSelected(Integer.valueOf(currentSelectedTextColor)).setContainer((IDropDownContainer)this).setCallback((menu, index) -> {
            if (includeNull && index == 0) {
                moveable.textColor = null;
            } else {
                moveable.textColor = index - (includeNull ? 1 : 0);
            }
            this.saveToConfigProfile();
            return true;
        }).setNarrationTitle((ITextComponent)new TranslationTextComponent("gui.xaero_dropdown_info_display_text_color")).build();
        moveable.addSubElement((Widget)textColorWidget);
        int n2 = moveable.backgroundColor == null ? 0 : (currentSelectedBackground = (moveable.backgroundColor < 0 ? moveable.backgroundColor : moveable.backgroundColor % MinimapConfigConstants.COLOR_NAMES.length) + 1 + (includeNull ? 1 : 0));
        if (currentSelectedBackground < 0) {
            currentSelectedBackground = 0;
            moveable.backgroundColor = includeNull ? null : Integer.valueOf(-1);
        }
        DropDownWidget backgroundColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("\u25a0\u25a0", true, includeNull)).setX(this.width / 2 - 124).setW(20).setSelected(Integer.valueOf(currentSelectedBackground)).setContainer((IDropDownContainer)this).setCallback((menu, index) -> {
            if (includeNull && index == 0) {
                moveable.backgroundColor = null;
            } else {
                moveable.backgroundColor = index - 1 - (includeNull ? 1 : 0);
            }
            this.saveToConfigProfile();
            return true;
        }).setNarrationTitle((ITextComponent)new TranslationTextComponent("gui.xaero_dropdown_info_display_background_color")).build();
        moveable.addSubElement((Widget)backgroundColorWidget);
        if (this.viewingEnforced) {
            if (stateWidget != null) {
                stateWidget.active = false;
            }
            textColorWidget.active = false;
            backgroundColorWidget.active = false;
        }
    }

    public boolean mouseReleased(double d, double e, int i) {
        if (this.selectionList != null) {
            this.selectionList.releaseDrag();
        }
        return super.mouseReleased(d, e, i);
    }

    public void setFocused(IGuiEventListener guiEventListener) {
        super.setFocused(guiEventListener);
        if (this.selectionList != null && guiEventListener == this.selectionList) {
            this.selectionList.narrateSelection();
        }
    }

    public void render(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.selectionList.render(poseStack, mouseX, mouseY, partialTicks);
        GuiInfoDisplayEdit.drawCenteredString((MatrixStack)poseStack, (FontRenderer)this.font, (ITextComponent)this.title, (int)(this.width / 2), (int)5, (int)-1);
        if (this.clientSide) {
            GuiInfoDisplayEdit.drawCenteredString((MatrixStack)poseStack, (FontRenderer)this.font, (ITextComponent)HELP_COMPONENT, (int)(this.width / 2), (int)(this.height - 52), (int)-1);
        }
        if (this.viewingEnforced) {
            GuiInfoDisplayEdit.drawCenteredString((MatrixStack)poseStack, (FontRenderer)this.font, (ITextComponent)SERVER_ENFORCED_COMPONENT, (int)(this.width / 2), (int)15, (int)-1);
        }
        super.render(poseStack, mouseX, mouseY, partialTicks);
    }

    class SelectionList
    extends ExtendedList<Entry> {
        private boolean dragging;
        private int dragStartX;
        private int dragStartY;
        private int dragged;
        private int draggedOffsetX;
        private int draggedOffsetY;

        public SelectionList() {
            super(GuiInfoDisplayEdit.this.minecraft, GuiInfoDisplayEdit.this.width, GuiInfoDisplayEdit.this.height, 30, GuiInfoDisplayEdit.this.height - 61, 24);
            this.createEntries();
            if (GuiInfoDisplayEdit.this.selected != -1) {
                this.setSelected((Entry)this.getEntry(GuiInfoDisplayEdit.this.selected));
            }
            this.dragged = -1;
        }

        public boolean isFocused() {
            return GuiInfoDisplayEdit.this.getFocused() == this;
        }

        public void setSelected(Entry entry) {
            Entry oldSelected;
            if (GuiInfoDisplayEdit.this.subSelected != -1 && (oldSelected = (Entry)this.getSelected()) != null) {
                MoveableEntry moveable = oldSelected.getMoveable();
                ((Widget)moveable.subElements.get(GuiInfoDisplayEdit.this.subSelected)).changeFocus(true);
            }
            GuiInfoDisplayEdit.this.selected = entry == null ? -1 : entry.index;
            GuiInfoDisplayEdit.this.subSelected = -1;
            super.setSelected((AbstractList.AbstractListEntry)entry);
            super.setFocused((IGuiEventListener)entry);
            this.narrateSelection();
        }

        private void narrateSelection() {
            Entry entry = (Entry)this.getSelected();
            if (!this.isFocused()) {
                return;
            }
            if (entry == null) {
                return;
            }
            String infoDisplayId = (String)GuiInfoDisplayEdit.this.currentOrder.get(entry.index);
            InfoDisplay<?> infoDisplay = GuiInfoDisplayEdit.this.manager.get(infoDisplayId);
            String narration = entry == null ? I18n.get((String)"gui.xaero_narrator_select_nothing", (Object[])new Object[0]) : infoDisplay.getName().getString();
            NarratorChatListener.INSTANCE.sayNow(I18n.get((String)"narrator.select", (Object[])new Object[]{narration}) + " . " + I18n.get((String)"narration.xaero_ui_list_left_right_usage", (Object[])new Object[0]));
        }

        private void createEntries() {
            for (int i = 0; i < GuiInfoDisplayEdit.this.currentOrder.size(); ++i) {
                Entry entry = new Entry(i);
                this.addEntry((AbstractList.AbstractListEntry)entry);
            }
        }

        private void releaseDrag() {
            this.dragging = false;
            this.dragged = -1;
        }

        protected int getScrollbarPosition() {
            return this.width / 2 + 164;
        }

        public int getRowWidth() {
            return 300;
        }

        public void render(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.render(poseStack, mouseX, mouseY, partialTicks);
            if (this.dragging) {
                int hoveredIndex;
                Entry draggedEntry = (Entry)this.getEntry(this.dragged);
                draggedEntry.renderNonInteractable(poseStack, mouseX + this.draggedOffsetX, mouseY + this.draggedOffsetY);
                Entry hoveredEntry = (Entry)this.getEntryAtPosition(mouseX, mouseY);
                int n = hoveredIndex = hoveredEntry == null ? -1 : hoveredEntry.index;
                if (hoveredIndex != -1 && hoveredIndex != this.dragged) {
                    String draggedId = (String)GuiInfoDisplayEdit.this.currentOrder.get(this.dragged);
                    int slideDirection = hoveredIndex < this.dragged ? 1 : -1;
                    for (int i = this.dragged; i != hoveredIndex; i -= slideDirection) {
                        GuiInfoDisplayEdit.this.currentOrder.set(i, GuiInfoDisplayEdit.this.currentOrder.get(i - slideDirection));
                    }
                    GuiInfoDisplayEdit.this.currentOrder.set(hoveredIndex, draggedId);
                    this.dragged = hoveredIndex;
                    GuiInfoDisplayEdit.this.saveToConfigProfile();
                }
            } else if (this.dragged != -1 && (Math.abs(mouseX - this.dragStartX) > 5 || Math.abs(mouseY - this.dragStartY) > 5)) {
                this.dragging = true;
                this.setSelected((Entry)null);
            }
        }

        public class Entry
        extends ExtendedList.AbstractListEntry<Entry> {
            private final int index;
            private int lastRenderX;
            private int lastRenderY;

            public Entry(int index) {
                this.index = index;
            }

            private void renderNonInteractable(MatrixStack poseStack, int x, int y) {
                String infoDisplayId = (String)GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                InfoDisplay<?> infoDisplay = GuiInfoDisplayEdit.this.manager.get(infoDisplayId);
                AbstractGui.drawString((MatrixStack)poseStack, (FontRenderer)GuiInfoDisplayEdit.this.font, (ITextComponent)infoDisplay.getName(), (int)(x + 48), (int)(y + 6), (int)-1);
            }

            private MoveableEntry<?> getMoveable() {
                String infoDisplayId = (String)GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                return (MoveableEntry)GuiInfoDisplayEdit.this.moveableEntries.get(infoDisplayId);
            }

            public void render(MatrixStack poseStack, int index, int y, int x, int l, int m, int mouseX, int mouseY, boolean bl, float partialTicks) {
                this.lastRenderX = x;
                this.lastRenderY = y;
                if (SelectionList.this.dragging && SelectionList.this.dragged == index) {
                    return;
                }
                this.renderNonInteractable(poseStack, x, y);
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (Widget subElement : ((MoveableEntry)moveableEntry).subElements) {
                    subElement.y = y - 2 + 12 - subElement.getHeight() / 2;
                    if (subElement instanceof DropDownWidget) {
                        --subElement.y;
                    }
                    subElement.render(poseStack, mouseX, mouseY, partialTicks);
                }
            }

            public boolean mouseClicked(double d, double e, int i) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (Widget subElement : ((MoveableEntry)moveableEntry).subElements) {
                    if (!subElement.isMouseOver(d, e) || !subElement.mouseClicked(d, e, i)) continue;
                    return true;
                }
                if (i == 0) {
                    if (SelectionList.this.getSelected() != this) {
                        SelectionList.this.setSelected(this);
                    } else {
                        SelectionList.this.setSelected((Entry)null);
                    }
                    SelectionList.this.dragging = false;
                    if (!GuiInfoDisplayEdit.this.clientSide || GuiInfoDisplayEdit.this.viewingEnforced) {
                        return true;
                    }
                    SelectionList.this.dragged = this.index;
                    SelectionList.this.draggedOffsetX = (int)((double)this.lastRenderX - d);
                    SelectionList.this.draggedOffsetY = (int)((double)this.lastRenderY - e);
                    SelectionList.this.dragStartX = (int)d;
                    SelectionList.this.dragStartY = (int)e;
                } else {
                    SelectionList.this.setSelected((Entry)null);
                }
                return super.mouseClicked(d, e, i);
            }

            public boolean mouseReleased(double d, double e, int i) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (Widget subElement : ((MoveableEntry)moveableEntry).subElements) {
                    subElement.mouseReleased(d, e, i);
                }
                return super.mouseReleased(d, e, i);
            }

            public void mouseMoved(double d, double e) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (Widget subElement : ((MoveableEntry)moveableEntry).subElements) {
                    if (!subElement.isMouseOver(d, e)) continue;
                    subElement.mouseMoved(d, e);
                }
                super.mouseMoved(d, e);
            }

            public boolean mouseDragged(double d, double e, int i, double f, double g) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (Widget subElement : ((MoveableEntry)moveableEntry).subElements) {
                    if (!subElement.isMouseOver(d, e) || !subElement.mouseDragged(d, e, i, f, g)) continue;
                    return true;
                }
                return super.mouseDragged(d, e, i, f, g);
            }

            public boolean mouseScrolled(double d, double e, double f) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (Widget subElement : ((MoveableEntry)moveableEntry).subElements) {
                    if (!subElement.isMouseOver(d, e) || !subElement.mouseScrolled(d, e, f)) continue;
                    return true;
                }
                return super.mouseScrolled(d, e, f);
            }

            public boolean keyPressed(int i, int j, int k) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                if (i == 262 || i == 263) {
                    if (GuiInfoDisplayEdit.this.subSelected != -1) {
                        ((Widget)((MoveableEntry)moveableEntry).subElements.get(GuiInfoDisplayEdit.this.subSelected)).changeFocus(true);
                    }
                    if (i == 262) {
                        GuiInfoDisplayEdit.this.subSelected++;
                        if (GuiInfoDisplayEdit.this.subSelected == ((MoveableEntry)moveableEntry).subElements.size()) {
                            GuiInfoDisplayEdit.this.subSelected = -1;
                        }
                    } else {
                        GuiInfoDisplayEdit.this.subSelected--;
                        if (GuiInfoDisplayEdit.this.subSelected < -1) {
                            GuiInfoDisplayEdit.this.subSelected = ((MoveableEntry)moveableEntry).subElements.size() - 1;
                        }
                    }
                    if (GuiInfoDisplayEdit.this.subSelected != -1) {
                        ((Widget)((MoveableEntry)moveableEntry).subElements.get(GuiInfoDisplayEdit.this.subSelected)).changeFocus(true);
                    }
                } else if (GuiInfoDisplayEdit.this.subSelected != -1 && ((Widget)((MoveableEntry)moveableEntry).subElements.get(GuiInfoDisplayEdit.this.subSelected)).keyPressed(i, j, k)) {
                    return true;
                }
                return super.keyPressed(i, j, k);
            }

            public boolean keyReleased(int i, int j, int k) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                if (GuiInfoDisplayEdit.this.subSelected != -1 && ((Widget)((MoveableEntry)moveableEntry).subElements.get(GuiInfoDisplayEdit.this.subSelected)).keyReleased(i, j, k)) {
                    return true;
                }
                return super.keyReleased(i, j, k);
            }

            public boolean charTyped(char c, int i) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                if (GuiInfoDisplayEdit.this.subSelected != -1 && ((Widget)((MoveableEntry)moveableEntry).subElements.get(GuiInfoDisplayEdit.this.subSelected)).charTyped(c, i)) {
                    return true;
                }
                return super.charTyped(c, i);
            }
        }
    }

    public class MoveableEntry<T> {
        private final List<Widget> subElements;
        private final InfoDisplay<T> infoDisplay;
        private T state;
        private Integer textColor;
        private Integer backgroundColor;

        public MoveableEntry(InfoDisplay<T> infoDisplay) {
            this.infoDisplay = infoDisplay;
            this.subElements = new ArrayList<Widget>();
        }

        public void addSubElement(Widget widget) {
            this.subElements.add(widget);
        }

        public T getState() {
            return this.state;
        }

        public void setState(T state) {
            this.state = state;
        }

        private void clearSubElements() {
            this.subElements.clear();
        }
    }
}

