/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.MySmallButton;

public class GuiNewSet
extends ScreenBase {
    private TextFieldWidget nameTextField;
    private MinimapSession session;
    private MinimapWorldManager manager;
    private MinimapWorld minimapWorld;
    private Button confirmButton;

    @Deprecated
    public GuiNewSet(IXaeroMinimap modMain, XaeroMinimapSession session, Screen par1GuiScreen, WaypointWorld waypointWorld) {
        this(modMain, session, par1GuiScreen, null, waypointWorld);
    }

    @Deprecated
    public GuiNewSet(IXaeroMinimap modMain, XaeroMinimapSession session, Screen par1GuiScreen, Screen escapeScreen, WaypointWorld waypointWorld) {
        this(modMain, BuiltInHudModules.MINIMAP.getCurrentSession(), par1GuiScreen, escapeScreen, (MinimapWorld)waypointWorld);
    }

    public GuiNewSet(IXaeroMinimap modMain, MinimapSession session, Screen par1GuiScreen, Screen escapeScreen, MinimapWorld minimapWorld) {
        super(par1GuiScreen, escapeScreen, (ITextComponent)new TranslationTextComponent("gui.xaero_create_set"));
        this.session = session;
        this.manager = this.session.getWorldManager();
        this.minimapWorld = minimapWorld;
        this.canSkipWorldRender = true;
    }

    public void init() {
        super.init();
        this.nameTextField = new TextFieldWidget(this.font, this.width / 2 - 100, 60, 200, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_set_name"));
        this.setFocused((IGuiEventListener)this.nameTextField);
        this.nameTextField.setFocus(true);
        this.children.add(this.nameTextField);
        this.confirmButton = new MySmallButton(200, this.width / 2 - 155, this.height / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm", new Object[0]), b -> {
            if (this.canConfirm()) {
                String setName = this.nameTextField.getValue().replace(":", "\u00a7\u00a7");
                this.minimapWorld.setCurrentWaypointSetId(setName);
                this.minimapWorld.addWaypointSet(setName);
                try {
                    this.session.getWorldManagerIO().saveWorld(this.minimapWorld);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
                this.goBack();
            }
        });
        this.addButton((Widget)this.confirmButton);
        this.addButton((Widget)new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_cancel", new Object[0]), b -> this.goBack()));
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
        this.updateConfirmButton();
    }

    public void removed() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(false);
    }

    private boolean canConfirm() {
        return this.nameTextField.getValue().length() > 0 && this.minimapWorld.getWaypointSet(this.nameTextField.getValue()) == null;
    }

    private void updateConfirmButton() {
        ((Button)this.buttons.get((int)0)).active = this.canConfirm();
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        boolean result = super.keyPressed(par1, par2, par3);
        if (par1 == 257 && this.canConfirm()) {
            ((Widget)this.buttons.get(0)).onClick(0.0, 0.0);
            return true;
        }
        return result;
    }

    public void tick() {
        this.updateConfirmButton();
        this.nameTextField.tick();
    }

    public void render(MatrixStack matrixStack, int par1, int par2, float par3) {
        this.renderEscapeScreen(matrixStack, par1, par2, par3);
        this.renderBackground(matrixStack);
        AbstractGui.drawCenteredString((MatrixStack)matrixStack, (FontRenderer)this.font, (ITextComponent)this.title, (int)(this.width / 2), (int)20, (int)0xFFFFFF);
        this.nameTextField.render(matrixStack, par1, par2, par3);
        super.render(matrixStack, par1, par2, par3);
    }
}

