/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.region;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;
import xaero.common.graphics.PixelBuffers;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.region.MinimapTile;
import xaero.common.misc.BufferCompatibilityFix;

public class MinimapChunk {
    public static final int SIZE_TILES = 4;
    public static final int INT_BUFFER_SIZE = 4096;
    public static final int LIGHT_LEVELS = 5;
    private boolean blockTextureUpload;
    private int X;
    private int Z;
    private boolean hasSomething;
    private MinimapTile[][] tiles;
    private int[] glTexture;
    private boolean[] refreshRequired;
    private boolean refreshed;
    private IntBuffer[] buffer;
    private boolean changed;
    private int levelsBuffered = 0;
    private int workaroundPBO;

    public MinimapChunk(int X, int Z) {
        this.X = X;
        this.Z = Z;
        this.tiles = new MinimapTile[4][4];
        this.glTexture = new int[5];
        this.refreshRequired = new boolean[5];
        this.buffer = new IntBuffer[5];
    }

    public void reset(int X, int Z) {
        int i;
        this.X = X;
        this.Z = Z;
        this.hasSomething = false;
        for (i = 0; i < this.glTexture.length; ++i) {
            this.glTexture[i] = 0;
            this.refreshRequired[i] = false;
            if (this.buffer[i] == null) continue;
            BufferCompatibilityFix.clear(this.buffer[i]);
        }
        this.refreshed = false;
        this.changed = false;
        this.levelsBuffered = 0;
        for (i = 0; i < this.tiles.length; ++i) {
            for (int j = 0; j < this.tiles.length; ++j) {
                this.tiles[i][j] = null;
            }
        }
        this.blockTextureUpload = false;
    }

    public void recycleTiles() {
        for (int i = 0; i < this.tiles.length; ++i) {
            for (int j = 0; j < this.tiles.length; ++j) {
                MinimapTile tile = this.tiles[i][j];
                if (tile == null) continue;
                if (!tile.isWasTransfered()) {
                    tile.recycle();
                    continue;
                }
                tile.setWasTransfered(false);
            }
        }
    }

    public int getLevelToRefresh(int currentLevel) {
        if (this.refreshed || this.levelsBuffered == 0 || currentLevel == -1) {
            return -1;
        }
        int prev = currentLevel - 1;
        if (prev < 0) {
            prev = this.levelsBuffered - 1;
        }
        int i = currentLevel;
        while (true) {
            if (this.refreshRequired[i]) {
                return i;
            }
            if (i == prev) break;
            i = (i + 1) % this.levelsBuffered;
        }
        this.refreshed = true;
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bindTexture(int level) {
        MinimapChunk minimapChunk = this;
        synchronized (minimapChunk) {
            int levelTexture;
            int levelToRefresh;
            if (!this.hasSomething) {
                GlStateManager._bindTexture((int)0);
                return 0;
            }
            if (!this.blockTextureUpload && (levelToRefresh = this.getLevelToRefresh(Math.min(level, this.levelsBuffered - 1))) != -1) {
                boolean result = false;
                if (this.glTexture[levelToRefresh] == 0) {
                    this.glTexture[levelToRefresh] = GL11.glGenTextures();
                    result = true;
                }
                GlStateManager._bindTexture((int)this.glTexture[levelToRefresh]);
                if (result) {
                    GL11.glTexParameteri((int)3553, (int)33085, (int)0);
                    GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                    GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
                    GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
                    GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
                    GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)64, (int)64, (int)0, (int)32993, (int)32821, (ByteBuffer)null);
                }
                if (this.workaroundPBO == 0) {
                    this.workaroundPBO = PixelBuffers.glGenBuffers();
                }
                PixelBuffers.glBindBuffer(35052, this.workaroundPBO);
                PixelBuffers.glBufferData(35052, 16384L, 35040);
                IntBuffer mappedPBO = PixelBuffers.glMapBuffer(35052, 35001, 16384L, null).asIntBuffer();
                mappedPBO.put(this.buffer[levelToRefresh]);
                PixelBuffers.glUnmapBuffer(35052);
                GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)64, (int)64, (int)32993, (int)32821, (long)0L);
                PixelBuffers.glBindBuffer(35052, 0);
                this.refreshRequired[levelToRefresh] = false;
            }
            if ((levelTexture = this.glTexture[level]) != 0) {
                GlStateManager._bindTexture((int)levelTexture);
            }
            return levelTexture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBuffers(int levelsToLoad, int[][] intArrayBuffer) {
        this.refreshed = true;
        for (int l = 0; l < levelsToLoad; ++l) {
            this.refreshRequired[l] = false;
            if (this.buffer[l] != null) continue;
            this.buffer[l] = IntBuffer.allocate(4096);
        }
        for (int o = 0; o < this.tiles.length; ++o) {
            int offX = o * 16;
            for (int p = 0; p < this.tiles.length; ++p) {
                MinimapTile tile = this.tiles[o][p];
                int offZ = p * 16;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        for (int i = 0; i < levelsToLoad; ++i) {
                            if (tile == null) {
                                this.putColour(offX + x, offZ + z, 0, 0, 0, intArrayBuffer[i], 64);
                                continue;
                            }
                            this.putColour(offX + x, offZ + z, tile.getRed(i, x, z), tile.getGreen(i, x, z), tile.getBlue(i, x, z), intArrayBuffer[i], 64);
                        }
                    }
                }
            }
        }
        for (int i = 0; i < levelsToLoad; ++i) {
            MinimapChunk minimapChunk = this;
            synchronized (minimapChunk) {
                this.blockTextureUpload = true;
            }
            BufferCompatibilityFix.clear(this.buffer[i]);
            this.buffer[i].put(intArrayBuffer[i]);
            BufferCompatibilityFix.flip(this.buffer[i]);
            this.refreshRequired[i] = true;
            minimapChunk = this;
            synchronized (minimapChunk) {
                this.blockTextureUpload = false;
                continue;
            }
        }
        this.refreshed = false;
    }

    public void putColour(int x, int y, int red, int green, int blue, int[] texture, int size) {
        int pos = y * size + x;
        texture[pos] = blue << 24 | green << 16 | red << 8 | 0xFF;
    }

    public void copyBuffer(int level, IntBuffer toCopy) {
        if (this.buffer[level] == null) {
            this.buffer[level] = IntBuffer.allocate(4096);
        } else {
            BufferCompatibilityFix.clear(this.buffer[level]);
        }
        this.buffer[level].put(toCopy);
        BufferCompatibilityFix.flip(this.buffer[level]);
    }

    public int getLevelsBuffered() {
        return this.levelsBuffered;
    }

    public boolean isHasSomething() {
        return this.hasSomething;
    }

    public void setHasSomething(boolean hasSomething) {
        this.hasSomething = hasSomething;
    }

    public int getX() {
        return this.X;
    }

    public int getZ() {
        return this.Z;
    }

    public int getGlTexture(int l) {
        return this.glTexture[l];
    }

    public void setGlTexture(int l, int t) {
        this.glTexture[l] = t;
    }

    public MinimapTile getTile(int x, int z) {
        return this.tiles[x][z];
    }

    public void setTile(int x, int z, MinimapTile t) {
        this.tiles[x][z] = t;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setLevelsBuffered(int levelsBuffered) {
        this.levelsBuffered = levelsBuffered;
    }

    public boolean isBlockTextureUpload() {
        return this.blockTextureUpload;
    }

    public void setBlockTextureUpload(boolean blockTextureUpload) {
        this.blockTextureUpload = blockTextureUpload;
    }

    public boolean isRefreshRequired(int l) {
        return this.refreshRequired[l];
    }

    public void setRefreshRequired(int l, boolean r) {
        this.refreshRequired[l] = r;
    }

    public IntBuffer getBuffer(int l) {
        return this.buffer[l];
    }

    public void cleanup(MinimapInterface minimapInterface) {
        for (int l = 0; l < this.glTexture.length; ++l) {
            if (this.glTexture[l] != 0) {
                GL11.glDeleteTextures((int)this.glTexture[l]);
            }
            if (this.workaroundPBO == 0) continue;
            PixelBuffers.glDeleteBuffers(this.workaroundPBO);
        }
    }
}

