/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import xaero.common.HudMod;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.MinimapSafeModeRenderer;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;
import xaero.hud.entity.EntityUtils;
import xaero.hud.gui.util.GuiUtils;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.common.config.MinimapConfigConstants;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.compass.render.CompassRenderer;
import xaero.hud.minimap.config.util.MinimapConfigClientUtils;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.radar.RadarSession;
import xaero.hud.minimap.radar.category.EntityRadarCategory;
import xaero.hud.minimap.radar.category.EntityRadarCategoryManager;
import xaero.hud.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.hud.minimap.radar.color.RadarColor;
import xaero.hud.minimap.waypoint.render.WaypointMapRenderer;
import xaero.hud.render.TextureLocations;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.option.IndexedConfigOption;

public abstract class MinimapRenderer {
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    protected HudMod modMain;
    protected Minecraft mc;
    protected Minimap minimap;
    protected MinimapRendererHelper helper;
    protected WaypointMapRenderer waypointMapRenderer;
    private int lastMinimapSize;
    protected double zoom = 1.0;
    private BlockPos.Mutable mutableBlockPos;
    protected final CompassRenderer compassRenderer;

    public MinimapRenderer(HudMod modMain, Minecraft mc, WaypointMapRenderer waypointMapRenderer, Minimap minimap, CompassRenderer compassRenderer) {
        this.modMain = modMain;
        this.mc = mc;
        this.waypointMapRenderer = waypointMapRenderer;
        this.minimap = minimap;
        this.helper = new MinimapRendererHelper();
        this.mutableBlockPos = new BlockPos.Mutable();
        this.compassRenderer = compassRenderer;
    }

    public double getRenderAngle(boolean lockedNorth) {
        if (lockedNorth) {
            return 90.0;
        }
        return this.getActualAngle();
    }

    private double getActualAngle() {
        double rotation = this.mc.gameRenderer.getMainCamera().getYRot();
        return -90.0 - rotation;
    }

    protected abstract void renderChunks(MinimapSession var1, MatrixStack var2, MinimapProcessor var3, Vector3d var4, RegistryKey<World> var5, double var6, int var8, int var9, float var10, float var11, int var12, boolean var13, boolean var14, int var15, double var16, double var18, boolean var20, boolean var21, ModSettings var22, CustomVertexConsumers var23);

    public void renderMinimap(MinimapSession minimapSession, MatrixStack matrixStack, MinimapProcessor minimap, int x, int y, int width, int height, double scale, int size, float partial, CustomVertexConsumers cvc) {
        boolean crosshairDisplayed;
        int specW;
        int frameType;
        boolean renderFrame;
        ModSettings settings = this.modMain.getSettings();
        int minimapSizeConfig = MinimapConfigClientUtils.getEffectiveMinimapSize();
        if (minimapSizeConfig != this.lastMinimapSize) {
            this.lastMinimapSize = minimapSizeConfig;
            minimap.setToResetImage(true);
        }
        this.mc.gui.setBlitOffset(0);
        minimap.getRadarSession().getStateUpdater().setLastRenderViewEntity(this.mc.getCameraEntity());
        int mapSize = minimapSession.getProcessor().getMinimapSize();
        int bufferSize = minimapSession.getProcessor().getMinimapBufferSize(mapSize);
        if (this.minimap.usingFBO()) {
            bufferSize = minimap.getFBOBufferSize();
        }
        ClientConfigManager configManager = this.modMain.getHudConfigs().getClientConfigManager();
        float minimapScale = GuiUtils.getMinimapScale(configManager);
        float mapScale = (float)(scale / (double)minimapScale);
        minimap.updateZoom();
        this.zoom = minimap.getMinimapZoom();
        RenderHelper.turnOff();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.pixelStore((int)3317, (int)4);
        RenderSystem.pixelStore((int)3316, (int)0);
        RenderSystem.pixelStore((int)3315, (int)0);
        RenderSystem.pixelStore((int)3314, (int)0);
        float sizeFix = (float)bufferSize / 512.0f;
        int shape = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.SHAPE);
        boolean lockedNorth = MinimapConfigClientUtils.getEffectiveNorthLocked(mapSize / 2, shape);
        double angle = Math.toRadians(this.getRenderAngle(lockedNorth));
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        boolean useWorldMap = this.modMain.getSupportMods().shouldUseWorldMapChunks() && !minimap.getMinimapWriter().isLoadedNonWorldMap();
        boolean lightingConfig = (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.LIGHTING);
        int lightLevel = (int)((1.0f - Math.min(1.0f, this.getSunBrightness(minimap, lightingConfig))) * (float)(minimap.getMinimapWriter().getLoadedLevels() - 1));
        boolean cave = minimap.isCaveModeDisplayed();
        boolean circleShape = shape == 1;
        double playerX = EntityUtils.getEntityX(this.mc.getCameraEntity(), partial);
        double playerY = EntityUtils.getEntityY(this.mc.getCameraEntity(), partial);
        double playerZ = EntityUtils.getEntityZ(this.mc.getCameraEntity(), partial);
        double renderX = playerX;
        double renderZ = playerZ;
        double mapDimensionScale = this.mc.level.dimensionType().coordinateScale();
        RegistryKey<World> mapDimension = this.mc.level.dimension();
        double playerDimDiv = 1.0;
        if (useWorldMap) {
            double playerCoordinateScale = mapDimensionScale;
            mapDimensionScale = this.modMain.getSupportMods().worldmapSupport.getMapDimensionScale();
            mapDimension = this.modMain.getSupportMods().worldmapSupport.getMapDimension();
            if (mapDimensionScale == 0.0) {
                mapDimensionScale = minimap.getLastMapDimensionScale();
                mapDimension = minimap.getLastMapDimension();
            }
            playerDimDiv = mapDimensionScale / playerCoordinateScale;
            renderX /= playerDimDiv;
            renderZ /= playerDimDiv;
        }
        minimap.setLastMapDimensionScale(mapDimensionScale);
        minimap.setLastMapDimension(mapDimension);
        minimap.setLastPlayerDimDiv(playerDimDiv);
        Vector3d renderPos = new Vector3d(renderX, playerY, renderZ);
        this.renderChunks(minimapSession, matrixStack, minimap, renderPos, mapDimension, mapDimensionScale, mapSize, bufferSize, sizeFix, partial, lightLevel, useWorldMap, lockedNorth, shape, ps, pc, cave, circleShape, settings, cvc);
        if (this.minimap.usingFBO()) {
            sizeFix = 1.0f;
        }
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GL11.glScalef((float)(1.0f / mapScale), (float)(1.0f / mapScale), (float)1.0f);
        int scaledX = (int)((float)x * mapScale);
        int scaledY = (int)((float)y * mapScale);
        int minimapFrameSize = (int)((float)(mapSize / 2) / sizeFix);
        int circleSides = Math.max(32, (int)Math.ceil(Math.PI * (double)(minimapFrameSize + 8) / 8.0 / 4.0) * 4);
        double circleSeamAngle = -0.7853981633974483;
        int circleSeamWidth = 32;
        int circleFrameThickness = 4;
        double circleStartAngle = 0.0;
        if (!circleShape) {
            this.getHelper().drawMyTexturedModalRect((int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, minimapFrameSize, 256.0f);
        } else {
            float outerRadius = mapSize / 4 + circleFrameThickness;
            circleStartAngle = circleSeamAngle - (double)((float)(circleSeamWidth / 2) / outerRadius);
            this.getHelper().drawTexturedElipseInsideRectangle(circleStartAngle, circleSides, (int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, 256.0f);
        }
        RenderSystem.defaultBlendFunc();
        if (!this.minimap.usingFBO()) {
            GL11.glScalef((float)(1.0f / sizeFix), (float)(1.0f / sizeFix), (float)1.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        boolean bl = renderFrame = (frameType = ((Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.FRAME)).intValue()) < MinimapConfigConstants.FRAME_NAMES.length - 1;
        if (frameType > 0) {
            int frameColorConfig = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.FRAME_COLOR);
            int frameColor = MinimapConfigConstants.COLORS[frameColorConfig];
            GlStateManager._color4f((float)((float)(frameColor >> 16 & 0xFF) / 255.0f), (float)((float)(frameColor >> 8 & 0xFF) / 255.0f), (float)((float)(frameColor & 0xFF) / 255.0f), (float)1.0f);
        }
        MinimapRendererHelper helper = this.getHelper();
        if (renderFrame) {
            this.mc.getTextureManager().bind(TextureLocations.MINIMAP_FRAME_TEXTURES);
        }
        if (renderFrame && !circleShape) {
            int rightCornerStartX = scaledX + 9 + mapSize / 2 + 4 - 16;
            int bottomCornerStartY = scaledY + 9 + mapSize / 2 + 4 - 16;
            Tessellator tessellator = Tessellator.getInstance();
            BufferBuilder vertexBuffer = tessellator.getBuilder();
            vertexBuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
            int cornerTextureX = frameType == 0 ? 192 : (frameType == 1 ? 208 : 224);
            helper.addTexturedRectToExistingBuffer((IVertexBuilder)vertexBuffer, scaledX + 9 - 4, scaledY + 9 - 4, cornerTextureX, 97, 16, 16);
            helper.addTexturedRectToExistingBuffer((IVertexBuilder)vertexBuffer, rightCornerStartX, scaledY + 9 - 4, cornerTextureX, 113, 16, 16);
            helper.addTexturedRectToExistingBuffer((IVertexBuilder)vertexBuffer, scaledX + 9 - 4, bottomCornerStartY, cornerTextureX, 129, 16, 16);
            helper.addTexturedRectToExistingBuffer((IVertexBuilder)vertexBuffer, rightCornerStartX, bottomCornerStartY, cornerTextureX, 145, 16, 16);
            int horLineStartX = scaledX + 9 - 4 + 16;
            int horLineWidth = rightCornerStartX - horLineStartX;
            int horPieceTextureY = frameType == 0 ? 0 : (frameType == 1 ? 32 : 64);
            int horPieceWidth = 226;
            int horLineLength = (int)Math.ceil((double)horLineWidth / (double)horPieceWidth);
            for (int i = 0; i < horLineLength; ++i) {
                int pieceX = scaledX + 9 - 4 + 16 + i * horPieceWidth;
                int pieceW = horPieceWidth;
                if (i == horLineLength - 1 && pieceX + pieceW > rightCornerStartX) {
                    pieceW = rightCornerStartX - pieceX;
                }
                helper.addTexturedRectToExistingBuffer((IVertexBuilder)vertexBuffer, pieceX, scaledY + 9 - 4, 0, horPieceTextureY, pieceW, 16);
                helper.addTexturedRectToExistingBuffer((IVertexBuilder)vertexBuffer, pieceX, scaledY + 9 + mapSize / 2 - 12, 0, horPieceTextureY + 16, pieceW, 16);
            }
            int verLineStartY = scaledY + 9 - 4 + 16;
            int verLineHeight = bottomCornerStartY - verLineStartY;
            int verPieceTextureX = frameType == 0 ? 0 : (frameType == 1 ? 64 : 128);
            int verPieceHeight = 113;
            int vertLineLength = (int)Math.ceil((double)verLineHeight / (double)verPieceHeight);
            for (int i = 0; i < vertLineLength; ++i) {
                int pieceY = scaledY + 9 - 4 + 16 + i * verPieceHeight;
                int pieceU = verPieceTextureX + 32 * (i & 1);
                int pieceH = verPieceHeight;
                if (i == vertLineLength - 1 && pieceY + pieceH > bottomCornerStartY) {
                    pieceH = bottomCornerStartY - pieceY;
                }
                helper.addTexturedRectToExistingBuffer((IVertexBuilder)vertexBuffer, scaledX + 9 - 4, pieceY, pieceU, 97, 16, pieceH);
                helper.addTexturedRectToExistingBuffer((IVertexBuilder)vertexBuffer, scaledX + 9 + mapSize / 2 - 12, pieceY, pieceU + 16, 97, 16, pieceH);
            }
            tessellator.end();
        } else if (renderFrame) {
            int frameTextureY = frameType == 0 ? 210 : (frameType == 1 ? 214 : 218);
            double shadeStartAngle = 0.7853981633974483 - circleStartAngle;
            int shadeStartIndex = (int)(shadeStartAngle / 2.0 / Math.PI * (double)circleSides);
            int circleLeftX = scaledX + 9;
            int circleTopY = scaledY + 9;
            int innerCircleDiameter = mapSize / 2;
            helper.drawTexturedElipseInsideRectangleFrame(false, false, circleStartAngle, 0, shadeStartIndex, circleSides, circleFrameThickness, circleLeftX, circleTopY, 0, frameTextureY, innerCircleDiameter, 73.0f, circleFrameThickness, circleSeamWidth, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(true, false, circleStartAngle, shadeStartIndex, shadeStartIndex + circleSides / 4, circleSides, circleFrameThickness, circleLeftX, circleTopY, 138, frameTextureY, innerCircleDiameter, 68.0f, circleFrameThickness, 20, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(true, true, circleStartAngle, shadeStartIndex + circleSides / 4, shadeStartIndex + circleSides / 2, circleSides, circleFrameThickness, circleLeftX, circleTopY, 138, frameTextureY, innerCircleDiameter, 68.0f, circleFrameThickness, 20, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(false, false, circleStartAngle, shadeStartIndex + circleSides / 2, circleSides, circleSides, circleFrameThickness, circleLeftX, circleTopY, 0, frameTextureY, innerCircleDiameter, 73.0f, circleFrameThickness, circleSeamWidth, 256.0f);
        }
        this.mc.getTextureManager().bind(TextureLocations.GUI_TEXTURES);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.pushPose();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
        RenderSystem.scalef((float)(1.0f / minimapScale), (float)(1.0f / minimapScale), (float)1.0f);
        int halfFrame = (int)((float)mapSize * minimapScale / 2.0f / 2.0f);
        RenderSystem.translatef((float)halfFrame, (float)halfFrame, (float)0.5f);
        int specH = specW = halfFrame + (int)(3.0f * minimapScale);
        boolean safeMode = this instanceof MinimapSafeModeRenderer;
        IRenderTypeBuffer.Impl renderTypeBuffers = this.modMain.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers = minimapSession.getMultiTextureRenderTypeRenderers();
        double scaledZoom = this.zoom * (double)minimapScale / 2.0;
        matrixStack.pushPose();
        boolean compassOverEverythingConfig = (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.COMPASS_OVER_EVERYTHING);
        if (!compassOverEverythingConfig) {
            this.renderCompass(matrixStack, settings, configManager, renderTypeBuffers, specW, specH, halfFrame, ps, pc, circleShape, minimapScale);
        }
        this.minimap.getOverMapRendererHandler().prepareRender(ps, pc, scaledZoom, specW, specH, halfFrame, halfFrame, circleShape, minimapScale);
        this.minimap.getOverMapRendererHandler().render(matrixStack, renderPos, partial, null, mapDimensionScale, mapDimension);
        if (compassOverEverythingConfig) {
            this.renderCompass(matrixStack, settings, configManager, renderTypeBuffers, specW, specH, halfFrame, ps, pc, circleShape, minimapScale);
        }
        renderTypeBuffers.endBatch();
        RenderSystem.popMatrix();
        matrixStack.popPose();
        int depthClearerX = scaledX - 25;
        int depthClearerY = scaledY - 25;
        int depthClearerW = 18 + mapSize / 2 + 50;
        CustomRenderTypes.DEPTH_CLEAR.setupRenderState();
        AbstractGui.fill((MatrixStack)matrixStack, (int)depthClearerX, (int)depthClearerY, (int)(depthClearerX + depthClearerW), (int)(depthClearerY + depthClearerW), (int)-16777216);
        CustomRenderTypes.DEPTH_CLEAR.clearRenderState();
        RenderSystem.enableBlend();
        int mainEntityAs = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.RADAR_MAIN_ENTITY);
        boolean bl2 = crosshairDisplayed = mainEntityAs == 0 && !lockedNorth;
        if (crosshairDisplayed) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            RenderSystem.disableTexture();
            RenderSystem.translatef((float)(mapSize / 2), (float)(mapSize / 2), (float)0.0f);
            RenderSystem.blendFuncSeparate((int)775, (int)0, (int)1, (int)0);
            this.getHelper().drawMyColoredRect(-5.0f, -1.0f, 5.0f, 1.0f);
            this.getHelper().drawMyColoredRect(-1.0f, 3.0f, 1.0f, 5.0f);
            this.getHelper().drawMyColoredRect(-1.0f, -5.0f, 1.0f, -3.0f);
            RenderSystem.blendFunc((int)770, (int)771);
            RadarSession radarSession = minimap.getRadarSession();
            EntityRadarCategoryManager categoryManager = radarSession.getCategoryManager();
            EntityRadarCategory mainEntityCategory = categoryManager.getRuleResolver().resolve(categoryManager.getRootCategory(), this.mc.getCameraEntity(), this.mc.player);
            if (mainEntityCategory == null) {
                mainEntityCategory = categoryManager.getRootCategory();
            }
            RadarColor crosshairRadarColor = RadarColor.fromIndex(mainEntityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue());
            RadarColor crosshairFallbackColor = radarSession.getColorHelper().getFallbackColor(mainEntityCategory, null);
            int crosshairColor = radarSession.getColorHelper().getEntityColor(this.mc.getCameraEntity(), 0.0f, false, 100, 100, false, crosshairRadarColor, crosshairFallbackColor);
            RenderSystem.color4f((float)((float)(crosshairColor >> 16 & 0xFF) / 255.0f), (float)((float)(crosshairColor >> 8 & 0xFF) / 255.0f), (float)((float)(crosshairColor & 0xFF) / 255.0f), (float)1.0f);
            this.getHelper().drawMyColoredRect(1.0f, -1.0f, 3.0f, 1.0f);
            this.getHelper().drawMyColoredRect(-3.0f, -1.0f, -1.0f, 1.0f);
            this.getHelper().drawMyColoredRect(-1.0f, 1.0f, 1.0f, 3.0f);
            this.getHelper().drawMyColoredRect(-1.0f, -3.0f, 1.0f, -1.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableTexture();
            RenderSystem.enableBlend();
            RenderSystem.popMatrix();
        }
        double centerX = 2 * scaledX + 18 + mapSize / 2;
        double centerY = 2 * scaledY + 18 + mapSize / 2;
        RenderSystem.pushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GlStateManager._translated((double)centerX, (double)centerY, (double)0.0);
        this.mc.getTextureManager().bind(TextureLocations.GUI_TEXTURES);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        Entity mainEntity = this.mc.getCameraEntity();
        if (!safeMode && !crosshairDisplayed) {
            this.minimap.getMinimapFBORenderer().renderMainEntityDot(matrixStack, mainEntity, cave, cvc.getBetterPVPRenderTypeBuffers());
        }
        RenderSystem.enableBlend();
        if (lockedNorth || mainEntityAs == 2) {
            float a;
            float b;
            float g;
            float r;
            int arrowColour;
            float arrowAngle = lockedNorth ? mainEntity.getViewYRot(partial) : 180.0f;
            int arrowOpacityInt = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.ARROW_OPACITY);
            float arrowOpacity = (float)arrowOpacityInt / 100.0f;
            if (arrowOpacity == 1.0f) {
                this.drawArrow(matrixStack, arrowAngle, 0.0, 1.0, 0.0f, 0.0f, 0.0f, 0.5f, configManager);
            }
            if ((arrowColour = ((Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.ARROW_COLOR)).intValue()) != -1) {
                float[] c = MinimapConfigConstants.ARROW_COLORS[arrowColour];
                r = c[0];
                g = c[1];
                b = c[2];
                a = c[3];
            } else {
                int rgb = minimap.getRadarSession().getColorHelper().getTeamColor((Entity)(this.mc.player == null ? mainEntity : this.mc.player));
                if (rgb != -1) {
                    r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                    g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                    b = (float)(rgb & 0xFF) / 255.0f;
                    a = 1.0f;
                } else {
                    float[] c = MinimapConfigConstants.ARROW_COLORS[0];
                    r = c[0];
                    g = c[1];
                    b = c[2];
                    a = c[3];
                }
            }
            this.drawArrow(matrixStack, arrowAngle, 0.0, 0.0, r, g, b, a *= arrowOpacity, configManager);
        }
        matrixStack.popPose();
        RenderSystem.popMatrix();
        this.mc.getTextureManager().bind(TextureLocations.GUI_TEXTURES);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        int playerBlockX = OptimizedMath.myFloor(mainEntity.getX());
        int playerBlockY = OptimizedMath.myFloor(mainEntity.getY());
        int playerBlockZ = OptimizedMath.myFloor(mainEntity.getZ());
        BlockPos.Mutable pos = this.mutableBlockPos.set(playerBlockX, playerBlockY, playerBlockZ);
        this.minimap.getInfoDisplays().getRenderer().render(matrixStack, minimapSession, this.minimap, height, size, (BlockPos)pos, scaledX, scaledY, mapScale, renderTypeBuffers);
        GL11.glScalef((float)mapScale, (float)mapScale, (float)1.0f);
    }

    private void renderCompass(MatrixStack matrixStack, ModSettings settings, ClientConfigManager configManager, IRenderTypeBuffer.Impl renderTypeBuffers, int specW, int specH, int halfFrame, double ps, double pc, boolean circleShape, float minimapScale) {
        IVertexBuilder nameBgBuilder = renderTypeBuffers.getBuffer(CustomRenderTypes.RADAR_NAME_BGS);
        int compassScale = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.COMPASS_SCALE);
        int compassLocation = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.COMPASS_LOCATION);
        compassScale = compassScale <= 0 ? (compassLocation == 1 ? (int)Math.ceil(minimapScale / 2.0f) : (int)minimapScale) : (int)MinimapConfigClientUtils.getUIScale(configManager, (IndexedConfigOption<Integer>)MinimapProfiledConfigOptions.COMPASS_SCALE);
        if (compassLocation == 1) {
            if (Minecraft.getInstance().isEnforceUnicode()) {
                compassScale *= 2;
            }
            halfFrame = (int)((float)halfFrame - 7.0f * minimapScale / 2.0f);
            this.compassRenderer.drawCompass(matrixStack, halfFrame - 3 * compassScale, halfFrame - 3 * compassScale, ps, pc, 1.0, circleShape, compassScale, true, renderTypeBuffers, nameBgBuilder);
        } else if (compassLocation == 2) {
            this.compassRenderer.drawCompass(matrixStack, specW, specH, ps, pc, this.zoom, circleShape, compassScale, false, renderTypeBuffers, null);
        }
    }

    private void drawArrow(MatrixStack matrixStack, float angle, double arrowX, double arrowY, float r, float g, float b, float a, ClientConfigManager configManager) {
        RenderSystem.pushMatrix();
        GL11.glTranslated((double)arrowX, (double)arrowY, (double)0.0);
        RenderSystem.rotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        double arrowScale = (Double)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.ARROW_SCALE);
        GL11.glScaled((double)(0.5 * arrowScale), (double)(0.5 * arrowScale), (double)1.0);
        int offsetY = -6;
        int h = 28;
        int ty = 0;
        GL11.glTranslated((double)-13.0, (double)offsetY, (double)0.0);
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.mc.gui.blit(matrixStack, 0, 0, 49, ty, 26, h);
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public float getSunBrightness(MinimapProcessor minimap, boolean lighting) {
        ClientWorld world = this.mc.level;
        float sunBrightness = (world.getSkyDarken(1.0f) - 0.2f) / 0.8f;
        float ambient = world.dimensionType().brightness(0) * 24.0f / 15.0f;
        if (ambient > 1.0f) {
            ambient = 1.0f;
        }
        return ambient + (1.0f - ambient) * MathHelper.clamp((float)sunBrightness, (float)0.0f, (float)1.0f);
    }

    public MinimapRendererHelper getHelper() {
        return this.helper;
    }

    @Deprecated
    public double getLastPlayerDimDiv() {
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (session == null) {
            return 1.0;
        }
        return session.getProcessor().getLastPlayerDimDiv();
    }
}

