/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.opengl.GL11;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.misc.Misc;

public class MinimapRendererHelper {
    public void drawMyTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height, float factor) {
        this.drawMyTexturedModalRect(x, y, textureX, textureY, width, height, height, factor);
    }

    public void drawMyTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuilder();
        vertexBuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        vertexBuffer.vertex((double)(x + 0.0f), (double)(y + height), 0.0).uv((float)(textureX + 0) * f, (float)(textureY + 0) * f1).endVertex();
        vertexBuffer.vertex((double)(x + width), (double)(y + height), 0.0).uv(((float)textureX + width) * f, (float)(textureY + 0) * f1).endVertex();
        vertexBuffer.vertex((double)(x + width), (double)(y + 0.0f), 0.0).uv(((float)textureX + width) * f, ((float)textureY + theight) * f1).endVertex();
        vertexBuffer.vertex((double)(x + 0.0f), (double)(y + 0.0f), 0.0).uv((float)(textureX + 0) * f, ((float)textureY + theight) * f1).endVertex();
        tessellator.end();
    }

    public void drawMyTexturedModalRect(Matrix4f matrix, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuilder();
        vertexBuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        vertexBuffer.vertex(matrix, x + 0.0f, y + height, 0.0f).uv((float)(textureX + 0) * f, (float)(textureY + 0) * f1).endVertex();
        vertexBuffer.vertex(matrix, x + width, y + height, 0.0f).uv(((float)textureX + width) * f, (float)(textureY + 0) * f1).endVertex();
        vertexBuffer.vertex(matrix, x + width, y + 0.0f, 0.0f).uv(((float)textureX + width) * f, ((float)textureY + theight) * f1).endVertex();
        vertexBuffer.vertex(matrix, x + 0.0f, y + 0.0f, 0.0f).uv((float)(textureX + 0) * f, ((float)textureY + theight) * f1).endVertex();
        tessellator.end();
    }

    public void prepareMyTexturedColoredModalRect(Matrix4f matrix, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, int textureId, float r, float g, float b, float a, MultiTextureRenderTypeRenderer renderer) {
        float f;
        float f1 = f = 1.0f / factor;
        BufferBuilder vertexBuffer = renderer.begin(textureId);
        vertexBuffer.vertex(matrix, x + 0.0f, y + height, 0.0f).uv((float)(textureX + 0) * f, (float)(textureY + 0) * f1).color(r, g, b, a).endVertex();
        vertexBuffer.vertex(matrix, x + width, y + height, 0.0f).uv(((float)textureX + width) * f, (float)(textureY + 0) * f1).color(r, g, b, a).endVertex();
        vertexBuffer.vertex(matrix, x + width, y + 0.0f, 0.0f).uv(((float)textureX + width) * f, ((float)textureY + theight) * f1).color(r, g, b, a).endVertex();
        vertexBuffer.vertex(matrix, x + 0.0f, y + 0.0f, 0.0f).uv((float)(textureX + 0) * f, ((float)textureY + theight) * f1).color(r, g, b, a).endVertex();
    }

    public void prepareMyTexturedModalRect(Matrix4f matrix, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, int textureId, MultiTextureRenderTypeRenderer renderer) {
        float f;
        float f1 = f = 1.0f / factor;
        BufferBuilder vertexBuffer = renderer.begin(textureId);
        vertexBuffer.vertex(matrix, x + 0.0f, y + height, 0.0f).uv((float)(textureX + 0) * f, (float)(textureY + 0) * f1).endVertex();
        vertexBuffer.vertex(matrix, x + width, y + height, 0.0f).uv(((float)textureX + width) * f, (float)(textureY + 0) * f1).endVertex();
        vertexBuffer.vertex(matrix, x + width, y + 0.0f, 0.0f).uv(((float)textureX + width) * f, ((float)textureY + theight) * f1).endVertex();
        vertexBuffer.vertex(matrix, x + 0.0f, y + 0.0f, 0.0f).uv((float)(textureX + 0) * f, ((float)textureY + theight) * f1).endVertex();
    }

    void drawTexturedElipseInsideRectangle(double startAngle, int sides, float x, float y, int textureX, int textureY, float width, float widthFactor) {
        this.drawTexturedElipseInsideRectangle(startAngle, sides, x, y, textureX, textureY, width, width, widthFactor);
    }

    void drawTexturedElipseInsideRectangle(double startAngle, int sides, float x, float y, int textureX, int textureY, float width, float theight, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuilder();
        float halfWidth = width / 2.0f;
        double centerX = x + halfWidth;
        double centerY = y + halfWidth;
        float centerU = ((float)textureX + halfWidth) * f;
        float centerV = (float)(((double)textureY + (double)theight * 0.5) * (double)f1);
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalV = 0.0f;
        vertexBuffer.begin(4, DefaultVertexFormats.POSITION_TEX);
        for (int i = 0; i <= sides; ++i) {
            double angle = startAngle + (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalV = (float)((double)theight * (1.0 - 0.5 * (1.0 - cos)));
            if (i > 0) {
                vertexBuffer.vertex((double)(x + vertexLocalX), (double)(y + vertexLocalY), 0.0).uv(((float)textureX + vertexLocalX) * f, ((float)textureY + vertexLocalV) * f1).endVertex();
                vertexBuffer.vertex((double)(x + prevVertexLocalX), (double)(y + prevVertexLocalY), 0.0).uv(((float)textureX + prevVertexLocalX) * f, ((float)textureY + prevVertexLocalV) * f1).endVertex();
                vertexBuffer.vertex(centerX, centerY, 0.0).uv(centerU, centerV).endVertex();
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalV = vertexLocalV;
        }
        tessellator.end();
    }

    void drawTexturedElipseInsideRectangleFrame(boolean resetTexture, boolean reverseTexture, double startAngle, int startIndex, int endIndex, int sides, float thickness, float x, float y, int textureX, int textureY, float width, float twidth, float theight, int seamWidth, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuilder();
        float halfWidth = width / 2.0f;
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalOuterX = 0.0f;
        float prevVertexLocalOuterY = 0.0f;
        float prevSegmentTextureX = 0.0f;
        vertexBuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        float outerRadius = halfWidth + thickness;
        float segmentOuterWidth = (float)(fullCircle / (double)sides * (double)outerRadius);
        startIndex = Math.max(Math.min(startIndex, sides), 0);
        endIndex = Math.max(Math.min(endIndex, sides), startIndex);
        int textureStartIndex = resetTexture ? (reverseTexture ? endIndex : startIndex) : 0;
        float seamThreshold = reverseTexture ? (float)seamWidth + segmentOuterWidth : (float)seamWidth;
        for (int i = startIndex; i <= endIndex; ++i) {
            double angle = startAngle + (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalOuterX = halfWidth + (float)((double)outerRadius * sin);
            float vertexLocalOuterY = (float)((double)halfWidth - (double)outerRadius * cos);
            float segmentTextureStartX = textureX;
            float offsetX = Math.abs(segmentOuterWidth * (float)(i - textureStartIndex));
            if (offsetX >= seamThreshold) {
                segmentTextureStartX = textureX + seamWidth;
                if ((offsetX -= seamThreshold) >= twidth) {
                    offsetX %= twidth;
                }
            }
            float segmentTextureX = segmentTextureStartX + offsetX;
            if (i > startIndex) {
                vertexBuffer.vertex((double)(x + prevVertexLocalX), (double)(y + prevVertexLocalY), 0.0).uv(prevSegmentTextureX * f, ((float)textureY + theight) * f1).endVertex();
                vertexBuffer.vertex((double)(x + vertexLocalX), (double)(y + vertexLocalY), 0.0).uv(segmentTextureX * f, ((float)textureY + theight) * f1).endVertex();
                vertexBuffer.vertex((double)(x + vertexLocalOuterX), (double)(y + vertexLocalOuterY), 0.0).uv(segmentTextureX * f, (float)textureY * f1).endVertex();
                vertexBuffer.vertex((double)(x + prevVertexLocalOuterX), (double)(y + prevVertexLocalOuterY), 0.0).uv(prevSegmentTextureX * f, (float)textureY * f1).endVertex();
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalOuterX = vertexLocalOuterX;
            prevVertexLocalOuterY = vertexLocalOuterY;
            prevSegmentTextureX = segmentTextureX;
        }
        tessellator.end();
    }

    public void addTexturedRectToExistingBuffer(IVertexBuilder vertexBuffer, float x, float y, int u, int v, int w, int h) {
        float f = 0.00390625f;
        float normalizedU1 = (float)u * f;
        float normalizedV1 = (float)v * f;
        float normalizedU2 = (float)(u + w) * f;
        float normalizedV2 = (float)(v + h) * f;
        vertexBuffer.vertex((double)x, (double)(y + (float)h), 0.0).uv(normalizedU1, normalizedV2).endVertex();
        vertexBuffer.vertex((double)(x + (float)w), (double)(y + (float)h), 0.0).uv(normalizedU2, normalizedV2).endVertex();
        vertexBuffer.vertex((double)(x + (float)w), (double)y, 0.0).uv(normalizedU2, normalizedV1).endVertex();
        vertexBuffer.vertex((double)x, (double)y, 0.0).uv(normalizedU1, normalizedV1).endVertex();
    }

    public void drawMyColoredRect(float x1, float y1, float x2, float y2) {
        this.fillRect(x1, y1, x2, y2);
    }

    public void fillRect(float x1, float y1, float x2, float y2) {
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuilder();
        vertexBuffer.begin(7, DefaultVertexFormats.POSITION);
        vertexBuffer.vertex((double)x1, (double)y2, 0.0).endVertex();
        vertexBuffer.vertex((double)x2, (double)y2, 0.0).endVertex();
        vertexBuffer.vertex((double)x2, (double)y1, 0.0).endVertex();
        vertexBuffer.vertex((double)x1, (double)y1, 0.0).endVertex();
        tessellator.end();
    }

    public void addColoredLineToExistingBuffer(Matrix4f matrix, IVertexBuilder vertexBuffer, float x1, float y1, float x2, float y2, float r, float g, float b, float a) {
        vertexBuffer.vertex(matrix, x1, y1, 0.0f).color(r, g, b, a).endVertex();
        vertexBuffer.vertex(matrix, x2, y2, 0.0f).color(r, g, b, a).endVertex();
    }

    public void drawMyColoredRect(Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuilder();
        vertexBuffer.begin(7, DefaultVertexFormats.POSITION_COLOR);
        vertexBuffer.vertex(matrix, x1, y2, 0.0f).color(r, g, b, a).endVertex();
        vertexBuffer.vertex(matrix, x2, y2, 0.0f).color(r, g, b, a).endVertex();
        vertexBuffer.vertex(matrix, x2, y1, 0.0f).color(r, g, b, a).endVertex();
        vertexBuffer.vertex(matrix, x1, y1, 0.0f).color(r, g, b, a).endVertex();
        tessellator.end();
    }

    void bindTextureBuffer(ByteBuffer image, int width, int height, int par0) {
        GlStateManager._bindTexture((int)par0);
        GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)width, (int)height, (int)0, (int)6407, (int)5121, (ByteBuffer)image);
    }

    void putColor(byte[] bytes, int x, int y, int red, int green, int blue, int size) {
        int pixel = (y * size + x) * 3;
        bytes[pixel] = (byte)red;
        bytes[++pixel] = (byte)green;
        bytes[++pixel] = (byte)blue;
    }

    void gridOverlay(int[] result, int grid, int red, int green, int blue) {
        result[0] = (red * 3 + (grid >> 16 & 0xFF)) / 4;
        result[1] = (green * 3 + (grid >> 8 & 0xFF)) / 4;
        result[2] = (blue * 3 + (grid & 0xFF)) / 4;
    }

    void slimeOverlay(int[] result, int red, int green, int blue) {
        result[0] = (red + 82) / 2;
        result[1] = (green + 241) / 2;
        result[2] = (blue + 64) / 2;
    }

    public void defaultOrtho(Framebuffer framebuffer, boolean raw) {
        Misc.defaultOrtho(framebuffer, raw);
    }
}

