/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.write.biome;

import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;

public class BiomeBlendCalculator
implements IBlockDisplayReader {
    private World original;
    private int startI;
    private int endI;
    private int startJ;
    private int endJ;

    public void prepare(World original, boolean biomeBlending) {
        this.original = original;
        this.endJ = 0;
        this.startJ = 0;
        this.endI = 0;
        this.startI = 0;
        if (biomeBlending) {
            this.startI = -1;
            this.endI = 1;
            this.startJ = -1;
            this.endJ = 1;
        }
    }

    public TileEntity getBlockEntity(BlockPos blockPos) {
        return this.original.getBlockEntity(blockPos);
    }

    public BlockState getBlockState(BlockPos blockPos) {
        return this.original.getBlockState(blockPos);
    }

    public FluidState getFluidState(BlockPos blockPos) {
        return this.original.getFluidState(blockPos);
    }

    public float getShade(Direction direction, boolean bl) {
        return this.original.getShade(direction, bl);
    }

    public WorldLightManager getLightEngine() {
        return this.original.getLightEngine();
    }

    public int getBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        int x = blockPos.getX();
        int y = blockPos.getY();
        int z = blockPos.getZ();
        int redAccumulator = 0;
        int greenAccumulator = 0;
        int blueAccumulator = 0;
        World original = this.original;
        int total = 0;
        for (int i = this.startI; i <= this.endI; ++i) {
            for (int j = this.startJ; j <= this.endJ; ++j) {
                if (i != 0 && j != 0) continue;
                mutableBlockPos.set(x + i, y, z + j);
                Biome biome = original.getBiome((BlockPos)mutableBlockPos);
                int colorSample = colorResolver.getColor(biome, (double)mutableBlockPos.getX(), (double)mutableBlockPos.getZ());
                redAccumulator += colorSample & 0xFF0000;
                greenAccumulator += colorSample & 0xFF00;
                blueAccumulator += colorSample & 0xFF;
                ++total;
            }
        }
        int red = redAccumulator / total;
        int green = greenAccumulator / total;
        int blue = blueAccumulator / total;
        return 0xFF000000 | red & 0xFF0000 | green & 0xFF00 | blue;
    }
}

