/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.ForgeHooksClient;

public class Misc {
    public static double getMouseX(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.mouseHandler.xpos();
        }
        return mc.mouseHandler.xpos() * (double)mc.getWindow().getWidth() / (double)mc.getWindow().getScreenWidth();
    }

    public static double getMouseY(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.mouseHandler.ypos();
        }
        return mc.mouseHandler.ypos() * (double)mc.getWindow().getHeight() / (double)mc.getWindow().getScreenHeight();
    }

    public static void drawNormalText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (IRenderTypeBuffer)renderTypeBuffer, false, 0, 0xF000F0);
    }

    public static void drawNormalText(MatrixStack matrices, ITextComponent name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (IRenderTypeBuffer)renderTypeBuffer, false, 0, 0xF000F0);
    }

    public static void drawPiercingText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (IRenderTypeBuffer)renderTypeBuffer, true, 0, 0xF000F0);
    }

    public static void drawPiercingText(MatrixStack matrices, ITextComponent name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (IRenderTypeBuffer)renderTypeBuffer, true, 0, 0xF000F0);
    }

    public static void drawCenteredPiercingText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.getInstance().font.width(name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void drawCenteredPiercingText(MatrixStack matrices, ITextComponent name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.getInstance().font.width((ITextProperties)name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void minecraftOrtho(Minecraft mc, boolean raw) {
        MainWindow mainwindow = mc.getWindow();
        int width = raw ? mainwindow.getScreenWidth() : mainwindow.getWidth();
        int height = raw ? mainwindow.getScreenHeight() : mainwindow.getHeight();
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)((double)width / mainwindow.getGuiScale()), (double)((double)height / mainwindow.getGuiScale()), (double)0.0, (double)1000.0, (double)ForgeHooksClient.getGuiFarPlane());
    }

    public static void defaultOrtho(Framebuffer framebuffer, boolean raw) {
        if (framebuffer != null) {
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)framebuffer.width, (double)framebuffer.height, (double)0.0, (double)1000.0, (double)3000.0);
        } else {
            Misc.minecraftOrtho(Minecraft.getInstance(), raw);
        }
    }

    public static long getChunkPosAsLong(Chunk chunk) {
        return chunk.getPos().toLong();
    }

    public static boolean hasItem(PlayerEntity player, Item item) {
        return Misc.hasItem((NonNullList<ItemStack>)player.inventory.offhand, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.inventory.armor, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.inventory.items, 9, item);
    }

    public static boolean hasItem(NonNullList<ItemStack> inventory, int limit, Item item) {
        for (int i = 0; i < inventory.size() && (limit == -1 || i < limit); ++i) {
            if (inventory.get(i) == null || ((ItemStack)inventory.get(i)).getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static ITextComponent getFixedDisplayName(Entity e) {
        ITextComponent baseName = e.getName();
        if (baseName == null) {
            return null;
        }
        return e.getTeam() == null ? baseName.copy() : e.getTeam().getFormattedName((ITextComponent)baseName.copy());
    }

    public static boolean hasEffect(PlayerEntity player, Effect effect) {
        return effect != null && player.hasEffect(effect);
    }

    public static boolean hasEffect(Effect effect) {
        return Misc.hasEffect((PlayerEntity)Minecraft.getInstance().player, effect);
    }
}

