/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.server.radar.tracker;

import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class SyncedTrackedPlayer {
    private final UUID id;
    private double x;
    private double y;
    private double z;
    private RegistryKey<World> dimension;

    public SyncedTrackedPlayer(UUID id, double x, double y, double z, RegistryKey<World> dimension) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public SyncedTrackedPlayer setPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public SyncedTrackedPlayer setDimension(RegistryKey<World> dimension) {
        this.dimension = dimension;
        return this;
    }

    public UUID getId() {
        return this.id;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    @Deprecated
    public ResourceLocation getDimension() {
        return this.dimension.location();
    }

    public RegistryKey<World> getDimensionKey() {
        return this.dimension;
    }

    public boolean matchesEnough(PlayerEntity player, double maxAxisDistance) {
        return Math.abs(player.getX() - this.x) <= maxAxisDistance && Math.abs(player.getY() - this.y) <= maxAxisDistance && Math.abs(player.getZ() - this.z) <= maxAxisDistance && player.level.dimension().location().equals(this.dimension);
    }

    public void update(PlayerEntity player) {
        this.setPos(player.getX(), player.getY(), player.getZ()).setDimension((RegistryKey<World>)player.level.dimension());
    }

    public void copyFrom(SyncedTrackedPlayer trackedPlayer) {
        this.setPos(trackedPlayer.getX(), trackedPlayer.getY(), trackedPlayer.getZ()).setDimension(trackedPlayer.getDimensionKey());
    }
}

