/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.serialization.data;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import xaero.hud.category.rule.ExcludeListMode;
import xaero.hud.category.serialization.data.FilterObjectCategoryData;
import xaero.hud.category.serialization.data.ObjectCategoryDataNbtSerializer;

public class FilterObjectCategoryDataNbtSerializer<D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>>
extends ObjectCategoryDataNbtSerializer<D, DB> {
    protected FilterObjectCategoryDataNbtSerializer(Supplier<DB> builderSupplier) {
        super(builderSupplier);
    }

    @Override
    public CompoundNBT serialize(D data) {
        CompoundNBT resultTag = super.serialize(data);
        resultTag.putString("h", ((FilterObjectCategoryData)data).getHardInclude());
        resultTag.putBoolean("i", ((FilterObjectCategoryData)data).getIncludeListInSuperCategory());
        resultTag.putString("m", ((FilterObjectCategoryData)data).getExcludeMode().name());
        ListNBT includeListTag = new ListNBT();
        ((FilterObjectCategoryData)data).getIncludeListIterator().forEachRemaining(includeEntry -> includeListTag.add((Object)StringNBT.valueOf((String)includeEntry)));
        resultTag.put("l", (INBT)includeListTag);
        ListNBT excludeListTag = new ListNBT();
        ((FilterObjectCategoryData)data).getExcludeListIterator().forEachRemaining(excludeEntry -> excludeListTag.add((Object)StringNBT.valueOf((String)excludeEntry)));
        resultTag.put("e", (INBT)excludeListTag);
        return resultTag;
    }

    @Override
    protected DB getConfiguredBuilder(CompoundNBT serializedData) {
        FilterObjectCategoryData.Builder builder = (FilterObjectCategoryData.Builder)super.getConfiguredBuilder(serializedData);
        builder.setHardInclude(serializedData.getString("h"));
        builder.setIncludeListInSuperCategory(serializedData.getBoolean("i"));
        builder.setExcludeMode(ExcludeListMode.valueOf(serializedData.getString("m")));
        ListNBT includeListTag = serializedData.getList("l", 8);
        for (INBT includeEntryTag : includeListTag) {
            builder.addToIncludeList(includeEntryTag.getAsString());
        }
        ListNBT excludeListTag = serializedData.getList("e", 8);
        for (INBT excludeEntryTag : excludeListTag) {
            builder.addToExcludeList(excludeEntryTag.getAsString());
        }
        return (DB)builder;
    }

    public static final class FinalBuilder<D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>>
    extends Builder<D, DB, FinalBuilder<D, DB>> {
        private FinalBuilder() {
        }

        @Override
        protected FilterObjectCategoryDataNbtSerializer<D, DB> buildInternally() {
            return new FilterObjectCategoryDataNbtSerializer(this.builderSupplier);
        }

        public static <D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>> FinalBuilder<D, DB> begin() {
            return (FinalBuilder)new FinalBuilder<D, DB>().setDefault();
        }
    }

    public static abstract class Builder<D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>, B extends Builder<D, DB, B>>
    extends ObjectCategoryDataNbtSerializer.Builder<D, DB, B> {
        protected Builder() {
        }

        @Override
        public FilterObjectCategoryDataNbtSerializer<D, DB> build() {
            return (FilterObjectCategoryDataNbtSerializer)super.build();
        }
    }
}

