/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.hud.category.ObjectCategory;
import xaero.hud.category.ui.EditorCategoryNodeConverter;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.ConnectionLineType;
import xaero.hud.category.ui.entry.EditorListEntry;
import xaero.hud.category.ui.entry.EditorListRootEntry;
import xaero.hud.category.ui.node.EditorCategoryNode;
import xaero.hud.category.ui.node.EditorNode;
import xaero.hud.category.ui.node.EditorSettingsNode;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.Tooltip;

public abstract class GuiCategoryEditor<C extends ObjectCategory<?, C>, ED extends EditorCategoryNode<C, SD, ED>, CB extends ObjectCategory.Builder<C, CB>, SD extends EditorSettingsNode<?>, SDB extends EditorSettingsNode.Builder<SD, SDB>, EDB extends EditorCategoryNode.Builder<C, ED, SD, SDB, EDB>>
extends ScreenBase {
    public static final ITextComponent READ_ONLY_COMPONENT = new TranslationTextComponent("gui.xaero_category_editor_read_only").withStyle(TextFormatting.YELLOW);
    private static final int FRAME_TOP_SIZE = 32;
    private static final int FRAME_BOTTOM_SIZE = 48;
    public static final int ROW_HEIGHT = 24;
    public static final int ROW_WIDTH = 220;
    private SettingRowList rowList;
    private final EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter;
    private ED editorData;
    protected ED cutCategory;
    protected ED cutCategorySuper;
    protected final IXaeroMinimap modMain;
    protected final boolean readOnly;

    protected GuiCategoryEditor(IXaeroMinimap modMain, Screen parent, Screen escape, ITextComponent title, EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter, boolean readOnly) {
        super(parent, escape, title);
        this.modMain = modMain;
        this.dataConverter = dataConverter;
        this.readOnly = readOnly;
        this.editorData = this.constructEditorData(dataConverter);
    }

    protected abstract ED constructEditorData(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract ED constructDefaultData(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract void onConfigConfirmed(C var1);

    protected void init() {
        super.init();
        if (this.readOnly) {
            this.addButton((Widget)new Button(this.width / 2 - 100, this.height - 32, 200, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_back"), b -> this.cancel(this.parent)));
        } else {
            this.addButton((Widget)new Button(this.width / 2 + 5, this.height - 32, 150, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_cancel"), b -> this.minecraft.setScreen((Screen)new ConfirmScreen(result -> {
                if (result) {
                    this.cancel(this.parent);
                } else {
                    this.minecraft.setScreen((Screen)this);
                }
            }, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_cancel_confirm"), (ITextComponent)new StringTextComponent("")))));
            this.addButton((Widget)new Button(this.width / 2 - 155, this.height - 32, 150, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_confirm"), b -> this.confirm()));
        }
        Button resetButton = new Button(6, 6, 120, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_reset"), b -> {
            if (this.readOnly) {
                return;
            }
            this.minecraft.setScreen((Screen)new ConfirmScreen(result -> {
                if (result) {
                    this.editorData = this.constructDefaultData(this.dataConverter);
                }
                this.minecraft.setScreen((Screen)this);
            }, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_reset_confirm1"), (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_reset_confirm2")));
        });
        resetButton.active = !this.readOnly;
        this.addButton((Widget)resetButton);
        this.rowList = new SettingRowList(this.dataConverter);
        this.children.add(this.rowList);
    }

    private void confirm() {
        super.onExit(this.parent);
        if (!this.readOnly) {
            this.onConfigConfirmed(((ObjectCategory.Builder)this.dataConverter.getConfiguredBuilder(this.editorData)).build());
        }
    }

    public void onExit(Screen screen) {
        if (this.readOnly) {
            super.onExit(screen);
            return;
        }
        this.minecraft.setScreen((Screen)new ConfirmScreen(result -> {
            if (result) {
                this.confirm();
            }
            this.cancel(screen);
        }, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_save_confirm"), (ITextComponent)new StringTextComponent("")){

            public boolean keyPressed(int i, int j, int k) {
                if (i == 256) {
                    return true;
                }
                return super.keyPressed(i, j, k);
            }
        });
    }

    protected void cancel(Screen screen) {
        super.onExit(screen);
    }

    public void render(MatrixStack poseStack, int i, int j, float f) {
        this.rowList.render(poseStack, i, j, f);
        GuiCategoryEditor.drawCenteredString((MatrixStack)poseStack, (FontRenderer)this.minecraft.font, (ITextComponent)this.title, (int)(this.width / 2), (int)5, (int)0xFFFFFF);
        super.render(poseStack, i, j, f);
        if (this.readOnly) {
            GuiCategoryEditor.drawString((MatrixStack)poseStack, (FontRenderer)this.font, (ITextComponent)READ_ONLY_COMPONENT, (int)(this.width - 5 - this.font.width((ITextProperties)READ_ONLY_COMPONENT)), (int)5, (int)-1);
        }
        if (this.rowList.hovered == null) {
            return;
        }
        Supplier<Tooltip> tooltipSupplier = this.rowList.hovered.getTooltipSupplier();
        if (tooltipSupplier == null) {
            return;
        }
        Tooltip tooltip = tooltipSupplier.get();
        if (tooltip == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, 0.1);
        tooltip.drawBox(poseStack, i, j, this.width, this.height);
        poseStack.popPose();
    }

    public boolean keyPressed(int i, int j, int k) {
        if (this.rowList.isFocused() && i == 257 && this.rowList.confirmSelection()) {
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    public void tick() {
        this.rowList.tick();
        super.tick();
    }

    public void setFocused(IGuiEventListener guiEventListener) {
        super.setFocused(guiEventListener);
        if (guiEventListener != null && guiEventListener == this.rowList) {
            this.rowList.narrateSelection();
        }
    }

    public SettingRowList getRowList() {
        return this.rowList;
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (super.mouseClicked(d, e, i)) {
            return true;
        }
        return this.rowList.mouseClicked(d, e, i);
    }

    public boolean mouseReleased(double d, double e, int i) {
        if (super.mouseReleased(d, e, i)) {
            return true;
        }
        return this.rowList.mouseReleased(d, e, i);
    }

    public boolean mouseDragged(double d, double e, int i, double f, double g) {
        if (super.mouseDragged(d, e, i, f, g)) {
            return true;
        }
        return this.rowList.mouseDragged(d, e, i, f, g);
    }

    public boolean mouseScrolled(double d, double e, double f) {
        if (super.mouseScrolled(d, e, f)) {
            return true;
        }
        return this.rowList.mouseScrolled(d, e, f);
    }

    public class SettingRowList
    extends ExtendedList<xaero.hud.category.ui.GuiCategoryEditor$SettingRowList.Entry> {
        private EditorNode lastExpandedData;
        private boolean restoreScrollAfterUpdate;
        private EditorListEntry hovered;
        private final EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter;
        public final boolean readOnly;

        public SettingRowList(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter) {
            super(GuiCategoryEditor.this.minecraft, GuiCategoryEditor.this.width, GuiCategoryEditor.this.height, 32, Math.max(36, GuiCategoryEditor.this.height - 48), 24);
            this.dataConverter = dataConverter;
            this.readOnly = GuiCategoryEditor.this.readOnly;
            this.updateEntries();
            this.setRenderSelection(false);
        }

        public boolean hasCut() {
            if (GuiCategoryEditor.this.cutCategory == null) {
                return false;
            }
            if (((EditorCategoryNode)GuiCategoryEditor.this.cutCategorySuper).getSubCategories().contains(GuiCategoryEditor.this.cutCategory)) {
                return true;
            }
            this.setCutCategory(null, null);
            return false;
        }

        public ED getCut() {
            return GuiCategoryEditor.this.cutCategory;
        }

        public boolean isCut(ED category) {
            if (GuiCategoryEditor.this.cutCategory == category) {
                return this.hasCut();
            }
            return false;
        }

        public void setCutCategory(ED cutCategory, ED cutCategorySuper) {
            GuiCategoryEditor.this.cutCategory = cutCategory;
            GuiCategoryEditor.this.cutCategorySuper = cutCategorySuper;
        }

        public void pasteTo(ED destination) {
            if (GuiCategoryEditor.this.cutCategory == null) {
                return;
            }
            if (destination == GuiCategoryEditor.this.cutCategory || destination == GuiCategoryEditor.this.cutCategorySuper) {
                this.setCutCategory(null, null);
                this.updateEntries();
                return;
            }
            ((EditorNode)destination).getExpandAction(this).run();
            this.setLastExpandedData((EditorNode)GuiCategoryEditor.this.cutCategory);
            ((EditorCategoryNode)GuiCategoryEditor.this.cutCategorySuper).getSubCategories().remove(GuiCategoryEditor.this.cutCategory);
            ((EditorCategoryNode)destination).getSubCategories().add(0, GuiCategoryEditor.this.cutCategory);
            this.setCutCategory(null, null);
        }

        public boolean isFocused() {
            return GuiCategoryEditor.this.getFocused() == this;
        }

        public void setLastExpandedData(EditorNode lastExpandedData) {
            this.lastExpandedData = lastExpandedData;
        }

        public void restoreScrollAfterUpdate() {
            this.restoreScrollAfterUpdate = true;
        }

        public void updateEntries() {
            double scrollBackup = this.getScrollAmount();
            this.clearEntries();
            GuiCategoryEditor.this.editorData.setExpanded(true);
            this.addEntriesForExpanded(GuiCategoryEditor.this.editorData, null);
            if (this.getSelected() != null) {
                this.centerScrollOn(this.getSelected());
            }
            if (this.restoreScrollAfterUpdate) {
                this.setScrollAmount(scrollBackup);
                this.restoreScrollAfterUpdate = false;
            }
        }

        private void addEntriesForExpanded(EditorNode data, EditorNode parent) {
            int nextIndex = this.children().size();
            List<EditorNode> subExpandables = data.getSubNodes();
            if (subExpandables == null) {
                return;
            }
            EditorNode expandedData = null;
            for (EditorNode sed : subExpandables) {
                if (!sed.isExpanded()) continue;
                expandedData = sed;
                break;
            }
            EditorListRootEntry wrappedEntry = data.getListEntryFactory().get(data, parent, nextIndex, nextIndex == 0 ? ConnectionLineType.NONE : ConnectionLineType.PATH, this, this.width, expandedData == null);
            Entry currentEntry = new Entry(wrappedEntry, nextIndex++);
            this.addEntry((AbstractList.AbstractListEntry)currentEntry);
            if (data == this.lastExpandedData) {
                this.setSelected(currentEntry);
            }
            if (expandedData != null) {
                this.addEntriesForExpanded(expandedData, data);
                return;
            }
            if (this.lastExpandedData == null && data.isExpanded()) {
                this.setSelected(currentEntry);
            }
            boolean first = true;
            for (EditorNode sed : subExpandables) {
                wrappedEntry = sed.getListEntryFactory().get(sed, data, nextIndex, first ? ConnectionLineType.HEAD_LEAF : ConnectionLineType.TAIL_LEAF, this, this.width, false);
                Entry leafEntry = new Entry(wrappedEntry, nextIndex++);
                this.addEntry((AbstractList.AbstractListEntry)leafEntry);
                if (sed == this.lastExpandedData) {
                    this.setSelected(leafEntry);
                }
                first = false;
            }
        }

        public boolean mouseClicked(double d, double e, int i) {
            if (!this.isMouseOver(d, e)) {
                this.setSelected((Entry)null);
            }
            return super.mouseClicked(d, e, i);
        }

        public void mouseMoved(double d, double e) {
            if (this.getSelected() != null) {
                ((Entry)this.getSelected()).mouseMoved(d, e);
            }
            super.mouseMoved(d, e);
        }

        public boolean keyReleased(int i, int j, int k) {
            if (this.getSelected() != null && ((Entry)this.getSelected()).keyReleased(i, j, k)) {
                return true;
            }
            return super.keyReleased(i, j, k);
        }

        public boolean charTyped(char c, int i) {
            boolean result;
            if (this.getSelected() != null && (result = ((Entry)this.getSelected()).charTyped(c, i))) {
                return true;
            }
            return super.charTyped(c, i);
        }

        public void tick() {
            if (this.getSelected() != null) {
                ((Entry)this.getSelected()).tick();
            }
        }

        public boolean confirmSelection() {
            Entry entry = (Entry)this.getSelected();
            if (entry == null) {
                return false;
            }
            EditorListEntry selectedSubEntry = entry.wrappedEntry.confirmSelection();
            return selectedSubEntry != null;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public void setSelected(Entry entry) {
            if (this.getSelected() != null) {
                ((Entry)this.getSelected()).wrappedEntry.unfocusRecursively();
            }
            if (this.getFocused() != null) {
                ((Entry)this.getFocused()).changeFocus(false);
            }
            if (entry != null) {
                entry.wrappedEntry.focusFirstRecursively();
            }
            super.setSelected((AbstractList.AbstractListEntry)entry);
            super.setFocused((IGuiEventListener)entry);
            this.narrateSelection();
        }

        public void setFocused(IGuiEventListener guiEventListener) {
        }

        public int getRowWidth() {
            return this.width;
        }

        protected int getScrollbarPosition() {
            return this.width / 2 + 164;
        }

        public void narrateSelection() {
            if (!this.isFocused()) {
                return;
            }
            Entry entry = (Entry)this.getSelected();
            if (entry == null) {
                return;
            }
            String selectedNarrationString = entry.wrappedEntry.getSelectedNarration();
            if (selectedNarrationString == null || selectedNarrationString.isEmpty()) {
                return;
            }
            String narration = entry == null ? I18n.get((String)"gui.xaero_narrator_select_nothing", (Object[])new Object[0]) : selectedNarrationString;
            NarratorChatListener.INSTANCE.sayNow(I18n.get((String)"narrator.select", (Object[])new Object[]{narration}) + " . " + I18n.get((String)"narration.xaero_ui_list_left_right_usage", (Object[])new Object[0]));
        }

        public void render(MatrixStack poseStack, int i, int j, float f) {
            this.hovered = null;
            super.render(poseStack, i, j, f);
        }

        public EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> getDataConverter() {
            return this.dataConverter;
        }

        public class Entry
        extends ExtendedList.AbstractListEntry<xaero.hud.category.ui.GuiCategoryEditor$SettingRowList.Entry> {
            private EditorListRootEntry wrappedEntry;
            private int index;
            private int lastX;
            private int lastY;

            public Entry(EditorListRootEntry entryInfo, int index) {
                this.wrappedEntry = entryInfo;
                this.index = index;
            }

            public void render(MatrixStack poseStack, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                this.lastX = x;
                this.lastY = y;
                poseStack.pushPose();
                poseStack.translate((double)x, (double)y, 0.0);
                boolean includesSelected = SettingRowList.this.getSelected() == this;
                this.wrappedEntry.preRender(poseStack, includesSelected, true);
                EditorListEntry hoveredInRow = this.wrappedEntry.render(poseStack, index, rowWidth, rowHeight, mouseX - x - this.wrappedEntry.getEntryRelativeX(), mouseY - y - this.wrappedEntry.getEntryRelativeY(), isMouseOver, partialTicks, GuiCategoryEditor.this.font, mouseX, mouseY, includesSelected, true);
                this.wrappedEntry.postRender(poseStack);
                poseStack.popPose();
                if (hoveredInRow != null) {
                    SettingRowList.this.hovered = hoveredInRow;
                }
            }

            public boolean mouseClicked(double mouseX, double mouseY, int i) {
                SettingRowList.this.setSelected(this);
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                double relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY();
                this.wrappedEntry.mouseClicked(this, relativeMouseX, relativeMouseY, i);
                return true;
            }

            public boolean mouseReleased(double mouseX, double mouseY, int i) {
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                double relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY();
                this.wrappedEntry.mouseReleased(relativeMouseX, relativeMouseY, i);
                return super.mouseReleased(mouseX, mouseY, i);
            }

            public boolean mouseScrolled(double mouseX, double mouseY, double f) {
                double relativeMouseY;
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                if (this.wrappedEntry.mouseScrolled(relativeMouseX, relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY(), f)) {
                    return true;
                }
                return super.mouseScrolled(mouseX, mouseY, f);
            }

            public boolean mouseDragged(double mouseX, double mouseY, int i, double f, double g) {
                double relativeMouseY;
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                if (this.wrappedEntry.mouseDragged(relativeMouseX, relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY(), i, f, g)) {
                    return true;
                }
                return super.mouseDragged(mouseX, mouseY, i, f, g);
            }

            public boolean keyPressed(int i, int j, int k) {
                if (this.wrappedEntry.keyPressed(i, j, k, true)) {
                    return true;
                }
                return super.keyPressed(i, j, k);
            }

            public boolean keyReleased(int i, int j, int k) {
                if (this.wrappedEntry.keyReleased(i, j, k)) {
                    return true;
                }
                return super.keyReleased(i, j, k);
            }

            public boolean charTyped(char c, int i) {
                if (this.wrappedEntry.charTyped(c, i)) {
                    return true;
                }
                return super.charTyped(c, i);
            }

            public void mouseMoved(double d, double e) {
                this.wrappedEntry.mouseMoved(d, e);
                super.mouseMoved(d, e);
            }

            public boolean changeFocus(boolean bl) {
                this.wrappedEntry.changeFocus(bl);
                return super.changeFocus(bl);
            }

            public void tick() {
                this.wrappedEntry.tick();
            }
        }
    }
}

