/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.entry.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import xaero.common.gui.IXaeroNarratableWidget;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.lib.client.gui.util.GuiUtils;

public class EditorTextField
extends TextFieldWidget
implements IXaeroNarratableWidget {
    private final UpdatedValueConsumer updatedValueConsumer;
    private int highlightPos;
    private final GuiCategoryEditor.SettingRowList rowList;
    private boolean pauseCallback;
    private final Predicate<String> validator;

    public EditorTextField(UpdatedValueConsumer updatedValueConsumer, String startValue, int startCursorPos, int startHighlighPos, int maxLength, FontRenderer font, int w, int h, ITextComponent message, Predicate<String> validator, GuiCategoryEditor.SettingRowList rowList) {
        super(font, 3, 3, w, h, message);
        this.setMaxLength(maxLength);
        this.setValue(startValue);
        this.setCursorPosition(startCursorPos);
        this.setHighlightPos(startHighlighPos);
        this.updatedValueConsumer = updatedValueConsumer;
        this.rowList = rowList;
        this.validator = validator;
        this.updateColorForValue(startValue);
        this.setResponder(s -> {
            if (this.pauseCallback) {
                return;
            }
            this.updateColorForValue((String)s);
            this.updatedValueConsumer.accept((String)s, this.getCursorPosition(), this.highlightPos, this.rowList);
        });
    }

    private void updateColorForValue(String value) {
        this.setTextColor(this.validator.test(value) ? 0xE0E0E0 : -43691);
    }

    public void setCursorPosition(int i) {
        super.setCursorPosition(i);
    }

    public void setHighlightPos(int i) {
        super.setHighlightPos(i);
        this.highlightPos = i;
    }

    @Override
    public IFormattableTextComponent createNarrationMessage() {
        return super.createNarrationMessage();
    }

    public void render(MatrixStack poseStack, int i, int j, float f) {
        super.render(poseStack, i, j, f);
        int o = this.x + 4;
        int p = this.y + (this.height - 8) / 2;
        if (this.getValue().isEmpty() && !this.isFocused()) {
            Minecraft.getInstance().font.drawShadow(poseStack, this.getMessage(), (float)o, (float)p, -11184811);
            GuiUtils.setFieldText((TextFieldWidget)this, (String)"");
            this.pauseCallback = false;
        }
    }

    @FunctionalInterface
    public static interface UpdatedValueConsumer {
        public void accept(String var1, int var2, int var3, GuiCategoryEditor.SettingRowList var4);
    }
}

