/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.common.config.util;

import java.util.function.BiFunction;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.platform.Services;
import xaero.hud.minimap.common.config.MinimapConfigConstants;
import xaero.hud.minimap.config.util.MinimapConfigClientUtils;
import xaero.lib.common.config.option.ConfigOption;

public class MinimapConfigUtils {
    public static BiFunction<ConfigOption<Integer>, Integer, ITextComponent> getUIScaleDisplayGetter(int auto, int max, boolean includeAutoValue) {
        return MinimapConfigUtils.getUIScaleDisplayGetter(auto, max, 1.0, includeAutoValue);
    }

    public static BiFunction<ConfigOption<Integer>, Integer, ITextComponent> getUIScaleDisplayGetter(int auto, int max, double autoScale, boolean includeAutoValue) {
        return (o, v) -> {
            if (v == auto) {
                IFormattableTextComponent result = MinimapConfigConstants.AUTO_SCALE_COMPONENT.copy();
                if (includeAutoValue && !Services.PLATFORM.isDedicatedServer()) {
                    MinimapConfigClientUtils.addAutoUIScaleValueToComponent(result, autoScale);
                }
                return result;
            }
            if (v == max) {
                IFormattableTextComponent result = MinimapConfigConstants.MINECRAFT_SCALE_COMPONENT.copy();
                if (!Services.PLATFORM.isDedicatedServer()) {
                    MinimapConfigClientUtils.addAutoMCScaleValueToComponent(result);
                }
                return result;
            }
            return new StringTextComponent(v.toString());
        };
    }

    public static BiFunction<ConfigOption<Integer>, Integer, ITextComponent> getUIScaleDisplayGetter(int auto, int max) {
        return MinimapConfigUtils.getUIScaleDisplayGetter(auto, max, 1.0);
    }

    public static BiFunction<ConfigOption<Integer>, Integer, ITextComponent> getUIScaleDisplayGetter(int auto, int max, double autoScale) {
        return MinimapConfigUtils.getUIScaleDisplayGetter(auto, max, autoScale, true);
    }

    public static ITextComponent getAutoMinimapSizeName() {
        TranslationTextComponent component = new TranslationTextComponent("gui.xaero_auto_map_size");
        if (!Services.PLATFORM.isDedicatedServer()) {
            component.getSiblings().add(new StringTextComponent(" (" + MinimapConfigClientUtils.getAutoMinimapSize() + ")"));
        }
        return component;
    }
}

