/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.element.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import xaero.hud.entity.EntityUtils;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;

public class MinimapElementRenderInfo {
    public final MinimapElementRenderLocation location;
    public final Entity renderEntity;
    public final Vector3d renderEntityPos;
    public final PlayerEntity player;
    public final Vector3d renderPos;
    public final boolean cave;
    public final float partialTicks;
    public final Framebuffer framebuffer;
    public final double renderEntityDimensionScale;
    public final RegistryKey<World> renderEntityDimension;
    public final double backgroundCoordinateScale;
    public final RegistryKey<World> mapDimension;

    public MinimapElementRenderInfo(MinimapElementRenderLocation location, Entity renderEntity, PlayerEntity player, Vector3d renderPos, boolean cave, float partialTicks, Framebuffer framebuffer, double backgroundCoordinateScale, RegistryKey<World> mapDimension) {
        this.location = location;
        this.renderEntity = renderEntity;
        this.renderEntityPos = EntityUtils.getEntityPos(renderEntity, partialTicks);
        this.player = player;
        this.renderPos = renderPos;
        this.cave = cave;
        this.partialTicks = partialTicks;
        this.framebuffer = framebuffer;
        this.renderEntityDimensionScale = Minecraft.getInstance().level.dimensionType().coordinateScale();
        this.renderEntityDimension = Minecraft.getInstance().level.dimension();
        this.backgroundCoordinateScale = backgroundCoordinateScale;
        this.mapDimension = mapDimension;
    }
}

