/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.element.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import xaero.common.HudMod;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.misc.OptimizedMath;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.element.render.MinimapElementReader;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderProvider;
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.module.MinimapSession;

public abstract class MinimapElementRendererHandler {
    private final HudMod modMain;
    private final List<MinimapElementRenderer<?, ?>> renderers;
    protected final MinimapElementRenderLocation location;
    private final int indexLimit;

    protected MinimapElementRendererHandler(HudMod modMain, List<MinimapElementRenderer<?, ?>> renderers, MinimapElementRenderLocation location, int indexLimit) {
        this.modMain = modMain;
        this.renderers = renderers;
        this.location = location;
        this.indexLimit = indexLimit;
    }

    public void add(MinimapElementRenderer<?, ?> renderer) {
        this.renderers.add(renderer);
        Collections.sort(this.renderers);
    }

    public void render(MatrixStack matrixStack, Vector3d renderPos, float partialTicks, Framebuffer framebuffer, double backgroundCoordinateScale, RegistryKey<World> mapDimension) {
        Minecraft mc = Minecraft.getInstance();
        Entity renderEntity = mc.getCameraEntity();
        ClientPlayerEntity player = mc.player;
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers = session.getMultiTextureRenderTypeRenderers();
        IRenderTypeBuffer.Impl vanillaBufferSource = mc.renderBuffers().bufferSource();
        boolean cave = session.getProcessor().isCaveModeDisplayed();
        MinimapElementRenderInfo renderInfo = new MinimapElementRenderInfo(this.location, renderEntity, (PlayerEntity)player, renderPos, cave, partialTicks, framebuffer, backgroundCoordinateScale, mapDimension);
        this.beforeRender(matrixStack, renderInfo, vanillaBufferSource);
        int indexLimit = this.getIndexLimit();
        for (int i = 0; i < this.renderers.size(); ++i) {
            MinimapElementRenderer<?, ?> renderer = this.renderers.get(i);
            int elementIndex = 0;
            elementIndex = this.renderForRenderer(renderer, matrixStack, elementIndex, multiTextureRenderTypeRenderers, indexLimit, renderInfo);
            matrixStack.translate(0.0, 0.0, this.getElementIndexDepth(elementIndex, indexLimit));
            if ((indexLimit -= elementIndex) >= 0) continue;
            indexLimit = 0;
        }
        this.afterRender(matrixStack, renderInfo, vanillaBufferSource);
    }

    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> int renderForRenderer(RR renderer, MatrixStack matrixStack, int elementIndex, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers, int indexLimit, MinimapElementRenderInfo renderInfo) {
        MinimapElementRenderLocation location = this.location;
        if (!renderer.shouldRender(location)) {
            return elementIndex;
        }
        IRenderTypeBuffer.Impl vanillaBufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        MinimapElementReader elementReader = renderer.elementReader;
        MinimapElementRenderProvider provider = renderer.provider;
        Object context = renderer.context;
        renderer.preRender(renderInfo, vanillaBufferSource, multiTextureRenderTypeRenderers);
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            double optionalDepth;
            Object element = provider.setupContextAndGetNext(location, context);
            if (element == null || elementReader.isHidden(element, context) || !this.transformAndRenderForRenderer(element, renderer, context, elementIndex, optionalDepth = this.getElementIndexDepth(elementIndex, indexLimit), renderInfo, matrixStack, vanillaBufferSource)) continue;
            ++elementIndex;
        }
        provider.end(location, context);
        renderer.postRender(renderInfo, vanillaBufferSource, multiTextureRenderTypeRenderers);
        return elementIndex;
    }

    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(E element, RR renderer, RRC context, int elementIndex, double optionalDepth, MinimapElementRenderInfo renderInfo, MatrixStack matrixStack, IRenderTypeBuffer.Impl vanillaBufferSource) {
        MinimapElementReader<E, RRC> elementReader = renderer.elementReader;
        double elementX = elementReader.getRenderX(element, context, renderInfo.partialTicks);
        double elementY = elementReader.getRenderY(element, context, renderInfo.partialTicks);
        double elementZ = elementReader.getRenderZ(element, context, renderInfo.partialTicks);
        double elementCoordinateScale = elementReader.getCoordinateScale(element, context, renderInfo);
        double coordinateMultiplier = elementCoordinateScale / renderInfo.backgroundCoordinateScale;
        if (coordinateMultiplier == 1.0) {
            return this.transformAndRenderForRenderer(element, elementX, elementY, elementZ, renderer, context, elementIndex, optionalDepth, renderInfo, matrixStack, vanillaBufferSource);
        }
        if (elementReader.shouldScalePartialCoordinates(element, context, renderInfo)) {
            elementX *= coordinateMultiplier;
            elementZ *= coordinateMultiplier;
        } else {
            int flooredRenderX = OptimizedMath.myFloor(elementX);
            int flooredRenderZ = OptimizedMath.myFloor(elementZ);
            elementX = (double)OptimizedMath.myFloor((double)flooredRenderX * coordinateMultiplier) + (elementX - (double)flooredRenderX);
            elementZ = (double)OptimizedMath.myFloor((double)flooredRenderZ * coordinateMultiplier) + (elementZ - (double)flooredRenderZ);
        }
        return this.transformAndRenderForRenderer(element, elementX, elementY, elementZ, renderer, context, elementIndex, optionalDepth, renderInfo, matrixStack, vanillaBufferSource);
    }

    protected double getElementIndexDepth(int elementIndex, int indexLimit) {
        return (double)(elementIndex >= indexLimit ? indexLimit : elementIndex) * 0.1;
    }

    protected int getIndexLimit() {
        return this.indexLimit;
    }

    protected abstract <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(E var1, double var2, double var4, double var6, RR var8, RRC var9, int var10, double var11, MinimapElementRenderInfo var13, MatrixStack var14, IRenderTypeBuffer.Impl var15);

    protected abstract void beforeRender(MatrixStack var1, MinimapElementRenderInfo var2, IRenderTypeBuffer.Impl var3);

    protected abstract void afterRender(MatrixStack var1, MinimapElementRenderInfo var2, IRenderTypeBuffer.Impl var3);

    public static abstract class Builder {
        protected Builder() {
        }

        protected Builder setDefault() {
            return this;
        }

        public MinimapElementRendererHandler build() {
            return this.buildInternally(new ArrayList());
        }

        protected abstract MinimapElementRendererHandler buildInternally(List<MinimapElementRenderer<?, ?>> var1);
    }
}

