/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.cache.id.variant;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import net.minecraft.entity.passive.horse.CoatTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class HorseVariant {
    public static final Map<CoatTypes, ResourceLocation> HORSE_MARKINGS = (Map)Util.make((Object)Maps.newEnumMap(CoatTypes.class), map -> {
        map.put(CoatTypes.NONE, null);
        map.put(CoatTypes.WHITE, new ResourceLocation("textures/entity/horse/horse_markings_white.png"));
        map.put(CoatTypes.WHITE_FIELD, new ResourceLocation("textures/entity/horse/horse_markings_whitefield.png"));
        map.put(CoatTypes.WHITE_DOTS, new ResourceLocation("textures/entity/horse/horse_markings_whitedots.png"));
        map.put(CoatTypes.BLACK_DOTS, new ResourceLocation("textures/entity/horse/horse_markings_blackdots.png"));
    });
    private final ResourceLocation texture;
    private final CoatTypes markings;

    public HorseVariant(ResourceLocation texture, CoatTypes markings) {
        this.texture = texture;
        this.markings = markings;
    }

    public String toString() {
        return this.texture + "%" + HORSE_MARKINGS.get(this.markings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorseVariant that = (HorseVariant)o;
        return Objects.equals(this.texture, that.texture) && this.markings == that.markings;
    }

    public int hashCode() {
        return Objects.hash(this.texture, this.markings);
    }
}

