/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.form.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import xaero.hud.minimap.radar.icon.creator.RadarIconCreator;
import xaero.hud.minimap.radar.icon.creator.render.form.IRadarIconFormPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.form.item.RadarIconItemForm;

public class RadarIconItemFormPrerenderer
implements IRadarIconFormPrerenderer {
    @Override
    public boolean requiresEntityModel() {
        return false;
    }

    @Override
    public boolean isFlipped() {
        return false;
    }

    @Override
    public boolean isOutlined() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Entity> boolean prerender(MatrixStack matrixStack, EntityRenderer<? super T> entityRenderer, @Nullable EntityModel<T> entityModel, T entity, @Nullable List<ModelRenderTrace> traceResult, RadarIconCreator.Parameters parameters) {
        RadarIconItemForm itemForm = (RadarIconItemForm)parameters.form;
        ItemStack itemStack = this.getItemToRender(entity, itemForm);
        if (itemStack == null || itemStack.isEmpty()) {
            return false;
        }
        int halfIcon = 32;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)halfIcon, (double)halfIcon, (double)1.0);
        float scale = parameters.scale;
        if (scale < 1.0f) {
            RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        }
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.translated((double)0.0, (double)0.0, (double)-300.0);
        try {
            mc.getItemRenderer().renderAndDecorateItem(itemStack, -8, -8);
        }
        finally {
            RenderSystem.popMatrix();
        }
        return true;
    }

    private ItemStack getItemToRender(Entity entity, RadarIconItemForm itemForm) {
        ResourceLocation itemKey = itemForm.getItemKey();
        if (itemKey != null) {
            Item item = (Item)Registry.ITEM.get(itemKey);
            if (item == null) {
                return null;
            }
            return new ItemStack((IItemProvider)item);
        }
        ItemStack selfStack = this.getSelfItem(entity);
        if (selfStack == null) {
            return null;
        }
        return new ItemStack((IItemProvider)selfStack.getItem());
    }

    private ItemStack getSelfItem(Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            return itemEntity.getItem();
        }
        if (entity instanceof ItemFrameEntity) {
            ItemFrameEntity itemFrame = (ItemFrameEntity)entity;
            return itemFrame.getItem();
        }
        return null;
    }
}

