/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.trace;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.SpriteAwareVertexBuilder;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.CustomRenderTypes;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.lib.client.graphics.XaeroRenderType;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class EntityRenderTracer {
    public static boolean TRACING_MODEL_RENDERS;
    private Entity tracedEntity;
    private EntityRenderer tracedEntityRenderer;
    private Class<?> tracedEntityModelClass;
    private List<ModelRenderTrace> traceResultList;
    private ModelRenderTrace lastModelRenderDetected;
    private IRenderTypeBuffer.Impl modelRenderDetectionRenderTypeBuffer;
    private Field lastStateField;
    private Class<?> compositeRenderTypeClass;
    private Field enderDragonModelField;
    private Field stateField;
    private Field compositeStateTextureStateField;
    private Field textureStateShardTextureField;
    private Field compositeStateDepthTestStateField;
    private Field compositeStateWriteMaskStateField;
    private Field compositeStateCullStateField;
    private Field compositeStateTransparencyStateField;
    private Field renderBuffersBufferSourceField;
    private Field spriteCoordinateExpanderSpriteField;
    private Class<?> irisRenderLayerWrapperClass;
    private Method irisRenderLayerWrapperUnwrapMethod;

    public EntityRenderTracer() {
        this.initReflection();
        this.traceResultList = new ArrayList<ModelRenderTrace>();
    }

    public <T extends Entity> List<ModelRenderTrace> trace(MatrixStack matrixStack, T entity, EntityRenderer<? super T> entityRenderer) {
        TRACING_MODEL_RENDERS = true;
        this.tracedEntity = entity;
        this.tracedEntityRenderer = entityRenderer;
        this.tracedEntityModelClass = null;
        this.traceResultList.clear();
        this.lastModelRenderDetected = null;
        MatrixStack.Entry matrixEntryToRestore = matrixStack.last();
        matrixStack.pushPose();
        try {
            IRenderTypeBuffer.Impl renderTypeBuffer = this.modelRenderDetectionRenderTypeBuffer = (IRenderTypeBuffer.Impl)ReflectionUtils.getReflectFieldValue((Object)Minecraft.getInstance().renderBuffers(), (Field)this.renderBuffersBufferSourceField);
            entityRenderer.render(entity, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, 0xF000F0);
            renderTypeBuffer.endBatch();
            OpenGLException.checkGLError();
        }
        catch (Throwable e) {
            this.traceResultList.clear();
            MinimapLogs.LOGGER.error("Exception when calling the full entity renderer for {} before prerendering the icon.", (Object)entity.getScoreboardName(), (Object)e);
        }
        TRACING_MODEL_RENDERS = false;
        this.tracedEntity = null;
        this.tracedEntityRenderer = null;
        while (matrixStack.last() != matrixEntryToRestore) {
            matrixStack.popPose();
        }
        while (GL11.glGetError() != 0) {
        }
        return this.traceResultList;
    }

    public void onModelRender(EntityModel<?> model, IVertexBuilder vertexConsumer, float red, float green, float blue, float alpha) {
        this.lastModelRenderDetected = null;
        if (this.tracedEntityModelClass == null) {
            EntityModel currentMainModel = this.getEntityRendererModel(this.tracedEntityRenderer);
            Class<?> clazz = this.tracedEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
            if (this.tracedEntityModelClass == null) {
                return;
            }
        }
        if (!model.getClass().isAssignableFrom(this.tracedEntityModelClass) && !this.tracedEntityModelClass.isAssignableFrom(model.getClass())) {
            return;
        }
        RenderType lastRenderType = this.getLastRenderType((IRenderTypeBuffer)this.modelRenderDetectionRenderTypeBuffer);
        if (lastRenderType == null && this.traceResultList.isEmpty()) {
            ResourceLocation textureLocation = null;
            try {
                ResourceLocation textureLocationUnchecked;
                textureLocation = textureLocationUnchecked = this.tracedEntityRenderer.getTextureLocation(this.tracedEntity);
            }
            catch (Throwable t) {
                MinimapLogs.LOGGER.error("Couldn't fetch main entity texture when trying to use an alternative render type for an icon!", t);
            }
            if (textureLocation != null) {
                lastRenderType = model.renderType(textureLocation);
            }
        }
        if (lastRenderType == null) {
            return;
        }
        RenderType.State renderState = this.getRenderState(lastRenderType);
        if (renderState == null) {
            return;
        }
        RenderState.TextureState renderTextureState = (RenderState.TextureState)ReflectionUtils.getReflectFieldValue((Object)renderState, (Field)this.compositeStateTextureStateField);
        ResourceLocation texture = this.getRenderStateTextureStateTexture(renderTextureState);
        RenderState.TransparencyState renderTransparencyState = (RenderState.TransparencyState)ReflectionUtils.getReflectFieldValue((Object)renderState, (Field)this.compositeStateTransparencyStateField);
        renderTransparencyState = this.fixAdditiveTransparency(renderTransparencyState);
        RenderState.DepthTestState renderDepthTestState = (RenderState.DepthTestState)ReflectionUtils.getReflectFieldValue((Object)renderState, (Field)this.compositeStateDepthTestStateField);
        RenderState.WriteMaskState renderWriteMaskState = (RenderState.WriteMaskState)ReflectionUtils.getReflectFieldValue((Object)renderState, (Field)this.compositeStateWriteMaskStateField);
        RenderState.CullState renderCullState = (RenderState.CullState)ReflectionUtils.getReflectFieldValue((Object)renderState, (Field)this.compositeStateCullStateField);
        CustomRenderTypes.EntityIconLayerPhases layerPhases = new CustomRenderTypes.EntityIconLayerPhases(renderTextureState, renderTransparencyState, renderDepthTestState, renderWriteMaskState, renderCullState);
        TextureAtlasSprite renderAtlasSprite = null;
        if (vertexConsumer instanceof SpriteAwareVertexBuilder) {
            renderAtlasSprite = (TextureAtlasSprite)ReflectionUtils.getReflectFieldValue((Object)vertexConsumer, (Field)this.spriteCoordinateExpanderSpriteField);
        }
        this.lastModelRenderDetected = new ModelRenderTrace(model, texture, renderAtlasSprite, layerPhases, red, green, blue, alpha);
        this.traceResultList.add(this.lastModelRenderDetected);
    }

    private RenderState.TransparencyState fixAdditiveTransparency(RenderState.TransparencyState renderTransparencyState) {
        int blendSrcFactor;
        RenderState.TransparencyState result = renderTransparencyState;
        renderTransparencyState.setupRenderState();
        int blendDestFactor = GL11.glGetInteger((int)32968);
        if (blendDestFactor == 1 && (blendSrcFactor = GL11.glGetInteger((int)32969)) != 0) {
            result = XaeroRenderType.getTransparencyPhase((int)blendSrcFactor, (int)blendDestFactor, (int)0, (int)1);
        }
        renderTransparencyState.clearRenderState();
        return result;
    }

    public void onModelPartRender(ModelRenderer modelRenderer, float red, float green, float blue, float alpha) {
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, red, green, blue, alpha);
        }
    }

    private RenderType getLastRenderType(IRenderTypeBuffer renderTypeBuffer) {
        if (!(renderTypeBuffer instanceof IRenderTypeBuffer.Impl)) {
            return null;
        }
        Object lastRenderTypeObject = ReflectionUtils.getReflectFieldValue((Object)renderTypeBuffer, (Field)this.lastStateField);
        if (lastRenderTypeObject instanceof Optional) {
            return ((Optional)lastRenderTypeObject).orElse(null);
        }
        return (RenderType)lastRenderTypeObject;
    }

    private RenderType.State getRenderState(RenderType renderType) {
        while (renderType.getClass() == this.irisRenderLayerWrapperClass && this.irisRenderLayerWrapperUnwrapMethod != null) {
            renderType = (RenderType)ReflectionUtils.getReflectMethodValue((Object)renderType, (Method)this.irisRenderLayerWrapperUnwrapMethod, (Object[])new Object[0]);
        }
        if (renderType.getClass() == this.compositeRenderTypeClass) {
            return (RenderType.State)ReflectionUtils.getReflectFieldValue((Object)renderType, (Field)this.stateField);
        }
        return null;
    }

    private ResourceLocation getRenderStateTextureStateTexture(RenderState.TextureState renderTextureState) {
        Object renderStateTextureObject = ReflectionUtils.getReflectFieldValue((Object)renderTextureState, (Field)this.textureStateShardTextureField);
        if (!(renderStateTextureObject instanceof Optional)) {
            return (ResourceLocation)renderStateTextureObject;
        }
        Optional optional = (Optional)renderStateTextureObject;
        return optional.orElse(null);
    }

    public <T extends Entity> EntityModel<T> getEntityRendererModel(EntityRenderer<? super T> entityRenderer) {
        if (entityRenderer instanceof LivingRenderer) {
            return ((LivingRenderer)entityRenderer).getModel();
        }
        if (entityRenderer instanceof EnderDragonRenderer) {
            return (EntityModel)ReflectionUtils.getReflectFieldValue(entityRenderer, (Field)this.enderDragonModelField);
        }
        return null;
    }

    private void initReflection() {
        this.enderDragonModelField = ReflectionUtils.getFieldReflection(EnderDragonRenderer.class, (String)"model", (String)"field_21008", (String)"Lnet/minecraft/class_895$class_625;", (String)"field_229058_m_");
        try {
            this.lastStateField = ReflectionUtils.getFieldReflection(IRenderTypeBuffer.Impl.class, (String)"lastState", (String)"field_20954", (String)"Ljava/util/Optional;", (String)"field_228459_c_");
        }
        catch (Exception e) {
            this.lastStateField = ReflectionUtils.getFieldReflection(IRenderTypeBuffer.Impl.class, (String)"lastState", (String)"c", (String)"Ljava/util/Optional;", (String)"field_228459_c_");
        }
        try {
            this.compositeRenderTypeClass = ReflectionUtils.getClassForName((String)"net.minecraft.class_1921$class_4687", (String)"net.minecraft.client.renderer.RenderType$Type");
            this.stateField = ReflectionUtils.getFieldReflection(this.compositeRenderTypeClass, (String)"state", (String)"field_21403", (String)"Lnet/minecraft/class_1921$class_4688;", (String)"field_228668_S_");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.compositeStateTextureStateField = ReflectionUtils.getFieldReflection(RenderType.State.class, (String)"textureState", (String)"field_21406", (String)"Lnet/minecraft/class_4668$class_4683;", (String)"field_228677_a_");
        this.textureStateShardTextureField = ReflectionUtils.getFieldReflection(RenderState.TextureState.class, (String)"texture", (String)"field_21397", (String)"Ljava/util/Optional;", (String)"field_228602_Q_");
        this.compositeStateTransparencyStateField = ReflectionUtils.getFieldReflection(RenderType.State.class, (String)"transparencyState", (String)"field_21407", (String)"Lnet/minecraft/class_4668$class_4685;", (String)"field_228678_b_");
        this.compositeStateDepthTestStateField = ReflectionUtils.getFieldReflection(RenderType.State.class, (String)"depthTestState", (String)"field_21411", (String)"Lnet/minecraft/class_4668$class_4672;", (String)"field_228682_f_");
        this.compositeStateWriteMaskStateField = ReflectionUtils.getFieldReflection(RenderType.State.class, (String)"writeMaskState", (String)"field_21419", (String)"Lnet/minecraft/class_4668$class_4686;", (String)"field_228690_n_");
        this.compositeStateCullStateField = ReflectionUtils.getFieldReflection(RenderType.State.class, (String)"cullState", (String)"field_21412", (String)"Lnet/minecraft/class_4668$class_4671;", (String)"field_228683_g_");
        this.renderBuffersBufferSourceField = ReflectionUtils.getFieldReflection(RenderTypeBuffers.class, (String)"bufferSource", (String)"field_20958", (String)"Lnet/minecraft/class_4597$class_4598;", (String)"field_228481_c_");
        this.spriteCoordinateExpanderSpriteField = ReflectionUtils.getFieldReflection(SpriteAwareVertexBuilder.class, (String)"sprite", (String)"field_21731", (String)"Lnet/minecraft/class_1058;", (String)"field_228788_b_");
        try {
            try {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderTypeWrapper");
            }
            catch (ClassNotFoundException e) {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderLayerWrapper");
            }
            this.irisRenderLayerWrapperUnwrapMethod = ReflectionUtils.getMethodReflection(this.irisRenderLayerWrapperClass, (String)"unwrap", (String)"unwrap", (String)"()Lnet/minecraft/class_1921;", (String)"unwrap", (Class[])new Class[0]);
            MinimapLogs.LOGGER.info("Old Iris detected and supported!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

