/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.util;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Difficulty;
import xaero.common.minimap.MinimapProcessor;
import xaero.hud.minimap.MinimapLogs;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class RadarUtils {
    public static DataParameter<Optional<UUID>> FOX_TRUSTED_UUID_SECONDARY;
    public static DataParameter<Optional<UUID>> FOX_TRUSTED_UUID_MAIN;

    public static double getMaxDistance(MinimapProcessor minimap, boolean circle) {
        int cullingSize = minimap.getMinimapSize() / 2 + 48;
        if (!circle) {
            cullingSize = (int)((double)cullingSize * Math.sqrt(2.0));
        }
        return (double)(cullingSize * cullingSize) / (minimap.getMinimapZoom() * minimap.getMinimapZoom());
    }

    public static boolean isHostileException(Entity e) {
        if (e instanceof PiglinEntity) {
            return ((PiglinEntity)e).isBaby();
        }
        return false;
    }

    public static boolean isTamed(Entity e, PlayerEntity p) {
        if (e instanceof TameableEntity) {
            TameableEntity tameable = (TameableEntity)e;
            return tameable.isTame() && p.getUUID().equals(tameable.getOwnerUUID());
        }
        if (e instanceof AbstractHorseEntity) {
            AbstractHorseEntity horse = (AbstractHorseEntity)e;
            return horse.isTamed() && p.getUUID().equals(horse.getOwnerUUID());
        }
        if (e instanceof FoxEntity) {
            FoxEntity fox = (FoxEntity)e;
            if (FOX_TRUSTED_UUID_SECONDARY != null && p.getUUID().equals(((Optional)fox.getEntityData().get(FOX_TRUSTED_UUID_SECONDARY)).orElse(null))) {
                return true;
            }
            return FOX_TRUSTED_UUID_MAIN != null && p.getUUID().equals(((Optional)fox.getEntityData().get(FOX_TRUSTED_UUID_MAIN)).orElse(null));
        }
        return false;
    }

    public static boolean isHostile(Entity e) {
        if (Minecraft.getInstance().level.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        if (RadarUtils.isHostileException(e)) {
            return false;
        }
        return e instanceof MonsterEntity || e instanceof IMob || e.getSoundSource() == SoundCategory.HOSTILE;
    }

    public static String getCustomName(Entity e, boolean nullable) {
        ITextComponent c = e.getCustomName();
        if (c != null && c instanceof StringTextComponent) {
            return ((StringTextComponent)c).getText();
        }
        return nullable ? null : "{non-plain}";
    }

    static {
        Field foxTrustSecondaryField = null;
        Field foxTrustMainField = null;
        try {
            foxTrustSecondaryField = ReflectionUtils.getFieldReflection(FoxEntity.class, (String)"DATA_TRUSTED_ID_0", (String)"field_17951", (String)"Lnet/minecraft/class_2940;", (String)"field_213509_bB");
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        try {
            foxTrustMainField = ReflectionUtils.getFieldReflection(FoxEntity.class, (String)"DATA_TRUSTED_ID_1", (String)"field_17952", (String)"Lnet/minecraft/class_2940;", (String)"field_213510_bD");
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (foxTrustSecondaryField != null) {
            FOX_TRUSTED_UUID_SECONDARY = (DataParameter)ReflectionUtils.getReflectFieldValue((Object)0, (Field)foxTrustSecondaryField);
        }
        if (foxTrustMainField != null) {
            FOX_TRUSTED_UUID_MAIN = (DataParameter)ReflectionUtils.getReflectFieldValue((Object)0, (Field)foxTrustMainField);
        }
    }
}

