/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.world;

import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;

public class MinimapDimensionHelper {
    public double getDimensionDivision(MinimapWorld minimapWorld) {
        if (Minecraft.getInstance().level == null) {
            return 1.0;
        }
        double dimCoordinateScale = this.getDimCoordinateScale(minimapWorld);
        return Minecraft.getInstance().level.dimensionType().coordinateScale() / dimCoordinateScale;
    }

    public double getDimCoordinateScale(MinimapWorld minimapWorld) {
        if (minimapWorld == null) {
            return 1.0;
        }
        MinimapWorldRootContainer rootContainer = minimapWorld.getContainer().getRoot();
        RegistryKey<World> dimKey = minimapWorld.getDimId();
        if (dimKey == null) {
            return 1.0;
        }
        return rootContainer.getDimensionScale(dimKey);
    }

    public String getDimensionDirectoryName(RegistryKey<World> dimKey) {
        if (dimKey == World.OVERWORLD) {
            return "dim%0";
        }
        if (dimKey == World.NETHER) {
            return "dim%-1";
        }
        if (dimKey == World.END) {
            return "dim%1";
        }
        ResourceLocation identifier = dimKey.location();
        return "dim%" + identifier.getNamespace() + "$" + identifier.getPath().replace('/', '%');
    }

    public RegistryKey<World> findDimensionKeyForOldName(ClientPlayerEntity player, String oldName) {
        Set allDimensions = player.connection.levels();
        for (RegistryKey dk : allDimensions) {
            if (!oldName.equals(dk.location().getPath().replaceAll("[^a-zA-Z0-9_]+", ""))) continue;
            return dk;
        }
        return null;
    }

    public RegistryKey<World> getDimensionKeyForDirectoryName(String dirName) {
        String dimIdPart = dirName.substring(4);
        if (dimIdPart.equals("0")) {
            return World.OVERWORLD;
        }
        if (dimIdPart.equals("1")) {
            return World.END;
        }
        if (dimIdPart.equals("-1")) {
            return World.NETHER;
        }
        String[] idArgs = dimIdPart.split("\\$");
        if (idArgs.length < 2) {
            return null;
        }
        return RegistryKey.create((RegistryKey)Registry.DIMENSION_REGISTRY, (ResourceLocation)new ResourceLocation(idArgs[0], idArgs[1].replace('%', '/')));
    }
}

