/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.packet.basic;

import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;

public class ClientboundRulesPacket {
    public final boolean allowCaveModeOnServer;
    public final boolean allowNetherCaveModeOnServer;
    public final boolean allowRadarOnServer;

    public ClientboundRulesPacket(boolean allowCaveModeOnServer, boolean allowNetherCaveModeOnServer, boolean allowRadarOnServer) {
        this.allowCaveModeOnServer = allowCaveModeOnServer;
        this.allowNetherCaveModeOnServer = allowNetherCaveModeOnServer;
        this.allowRadarOnServer = allowRadarOnServer;
    }

    public void write(PacketBuffer u) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.putBoolean("cm", this.allowCaveModeOnServer);
        nbt.putBoolean("ncm", this.allowNetherCaveModeOnServer);
        nbt.putBoolean("r", this.allowRadarOnServer);
        u.writeNbt(nbt);
    }

    public static ClientboundRulesPacket read(PacketBuffer buffer) {
        CompoundNBT nbt = buffer.readNbt();
        return new ClientboundRulesPacket(nbt.getBoolean("cm"), nbt.getBoolean("ncm"), nbt.getBoolean("r"));
    }

    public static class ClientHandler
    implements Consumer<ClientboundRulesPacket> {
        @Override
        public void accept(ClientboundRulesPacket message) {
            MinimapClientWorldDataHelper.getCurrentWorldData().setSyncedRules(message);
        }
    }
}

