/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import xaero.common.IXaeroMinimap;
import xaero.hud.category.ObjectCategory;
import xaero.hud.category.ui.EditorCategoryNodeConverter;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.ConnectionLineType;
import xaero.hud.category.ui.entry.EditorListEntry;
import xaero.hud.category.ui.entry.EditorListRootEntry;
import xaero.hud.category.ui.node.EditorCategoryNode;
import xaero.hud.category.ui.node.EditorNode;
import xaero.hud.category.ui.node.EditorSettingsNode;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.Tooltip;

public abstract class GuiCategoryEditor<C extends ObjectCategory<?, C>, ED extends EditorCategoryNode<C, SD, ED>, CB extends ObjectCategory.Builder<C, CB>, SD extends EditorSettingsNode<?>, SDB extends EditorSettingsNode.Builder<SD, SDB>, EDB extends EditorCategoryNode.Builder<C, ED, SD, SDB, EDB>>
extends ScreenBase {
    public static final Component READ_ONLY_COMPONENT = Component.m_237115_((String)"gui.xaero_category_editor_read_only").m_130940_(ChatFormatting.YELLOW);
    private static final int FRAME_TOP_SIZE = 32;
    private static final int FRAME_BOTTOM_SIZE = 48;
    public static final int ROW_HEIGHT = 24;
    public static final int ROW_WIDTH = 220;
    private SettingRowList rowList;
    private final EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter;
    private ED editorData;
    protected ED cutCategory;
    protected ED cutCategorySuper;
    protected final IXaeroMinimap modMain;
    protected final boolean readOnly;

    protected GuiCategoryEditor(IXaeroMinimap modMain, Screen parent, Screen escape, Component title, EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter, boolean readOnly) {
        super(parent, escape, title);
        this.modMain = modMain;
        this.dataConverter = dataConverter;
        this.readOnly = readOnly;
        this.editorData = this.constructEditorData(dataConverter);
    }

    protected abstract ED constructEditorData(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract ED constructDefaultData(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract void onConfigConfirmed(C var1);

    public void m_7856_() {
        super.m_7856_();
        if (this.readOnly) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 32, 200, 20, (Component)Component.m_237115_((String)"gui.xaero_back"), b -> this.cancel(this.parent)));
        } else {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ - 32, 150, 20, (Component)Component.m_237115_((String)"gui.xaero_category_settings_cancel"), b -> this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> {
                if (result) {
                    this.cancel(this.parent);
                } else {
                    this.f_96541_.m_91152_((Screen)this);
                }
            }, (Component)Component.m_237115_((String)"gui.xaero_category_settings_cancel_confirm"), (Component)Component.m_237113_((String)"")))));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155, this.f_96544_ - 32, 150, 20, (Component)Component.m_237115_((String)"gui.xaero_category_settings_confirm"), b -> this.confirm()));
        }
        Button resetButton = new Button(6, 6, 120, 20, (Component)Component.m_237115_((String)"gui.xaero_category_settings_reset"), b -> {
            if (this.readOnly) {
                return;
            }
            this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> {
                if (result) {
                    this.editorData = this.constructDefaultData(this.dataConverter);
                }
                this.f_96541_.m_91152_((Screen)this);
            }, (Component)Component.m_237115_((String)"gui.xaero_category_settings_reset_confirm1"), (Component)Component.m_237115_((String)"gui.xaero_category_settings_reset_confirm2")));
        });
        resetButton.f_93623_ = !this.readOnly;
        this.m_142416_((GuiEventListener)resetButton);
        this.rowList = new SettingRowList(this.dataConverter);
        this.m_7787_((GuiEventListener)this.rowList);
    }

    private void confirm() {
        super.onExit(this.parent);
        if (!this.readOnly) {
            this.onConfigConfirmed(((ObjectCategory.Builder)this.dataConverter.getConfiguredBuilder(this.editorData)).build());
        }
    }

    public void onExit(Screen screen) {
        if (this.readOnly) {
            super.onExit(screen);
            return;
        }
        this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> {
            if (result) {
                this.confirm();
            }
            this.cancel(screen);
        }, (Component)Component.m_237115_((String)"gui.xaero_category_settings_save_confirm"), (Component)Component.m_237113_((String)"")){

            public boolean m_7933_(int i, int j, int k) {
                if (i == 256) {
                    return true;
                }
                return super.m_7933_(i, j, k);
            }
        });
    }

    protected void cancel(Screen screen) {
        super.onExit(screen);
    }

    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        this.rowList.m_6305_(poseStack, i, j, f);
        GuiCategoryEditor.m_93215_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)5, (int)0xFFFFFF);
        super.m_6305_(poseStack, i, j, f);
        if (this.readOnly) {
            GuiCategoryEditor.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)READ_ONLY_COMPONENT, (int)(this.f_96543_ - 5 - this.f_96547_.m_92852_((FormattedText)READ_ONLY_COMPONENT)), (int)5, (int)-1);
        }
        if (this.rowList.hovered == null) {
            return;
        }
        Supplier<Tooltip> tooltipSupplier = this.rowList.hovered.getTooltipSupplier();
        if (tooltipSupplier == null) {
            return;
        }
        Tooltip tooltip = tooltipSupplier.get();
        if (tooltip == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.1);
        tooltip.drawBox(poseStack, i, j, this.f_96543_, this.f_96544_);
        poseStack.m_85849_();
    }

    public boolean m_7933_(int i, int j, int k) {
        if (this.rowList.m_5694_() && i == 257 && this.rowList.confirmSelection()) {
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    public void m_86600_() {
        this.rowList.tick();
        super.m_86600_();
    }

    public SettingRowList getRowList() {
        return this.rowList;
    }

    public boolean m_6375_(double d, double e, int i) {
        if (super.m_6375_(d, e, i)) {
            return true;
        }
        return this.rowList.m_6375_(d, e, i);
    }

    public boolean m_6348_(double d, double e, int i) {
        if (super.m_6348_(d, e, i)) {
            return true;
        }
        return this.rowList.m_6348_(d, e, i);
    }

    public boolean m_7979_(double d, double e, int i, double f, double g) {
        if (super.m_7979_(d, e, i, f, g)) {
            return true;
        }
        return this.rowList.m_7979_(d, e, i, f, g);
    }

    public boolean m_6050_(double d, double e, double f) {
        if (super.m_6050_(d, e, f)) {
            return true;
        }
        return this.rowList.m_6050_(d, e, f);
    }

    public class SettingRowList
    extends ObjectSelectionList<xaero.hud.category.ui.GuiCategoryEditor$SettingRowList.Entry> {
        private EditorNode lastExpandedData;
        private boolean restoreScrollAfterUpdate;
        private EditorListEntry hovered;
        private final EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter;
        public final boolean readOnly;
        private static final Component USAGE_NARRATION = Component.m_237115_((String)"narration.selection.usage");
        private static final Component LEFT_RIGHT_USAGE = Component.m_237115_((String)"narration.xaero_ui_list_left_right_usage");

        public SettingRowList(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter) {
            super(GuiCategoryEditor.this.f_96541_, GuiCategoryEditor.this.f_96543_, GuiCategoryEditor.this.f_96544_, 32, Math.max(36, GuiCategoryEditor.this.f_96544_ - 48), 24);
            this.dataConverter = dataConverter;
            this.readOnly = GuiCategoryEditor.this.readOnly;
            this.updateEntries();
            this.m_93471_(false);
        }

        public boolean hasCut() {
            if (GuiCategoryEditor.this.cutCategory == null) {
                return false;
            }
            if (((EditorCategoryNode)GuiCategoryEditor.this.cutCategorySuper).getSubCategories().contains(GuiCategoryEditor.this.cutCategory)) {
                return true;
            }
            this.setCutCategory(null, null);
            return false;
        }

        public ED getCut() {
            return GuiCategoryEditor.this.cutCategory;
        }

        public boolean isCut(ED category) {
            if (GuiCategoryEditor.this.cutCategory == category) {
                return this.hasCut();
            }
            return false;
        }

        public void setCutCategory(ED cutCategory, ED cutCategorySuper) {
            GuiCategoryEditor.this.cutCategory = cutCategory;
            GuiCategoryEditor.this.cutCategorySuper = cutCategorySuper;
        }

        public void pasteTo(ED destination) {
            if (GuiCategoryEditor.this.cutCategory == null) {
                return;
            }
            if (destination == GuiCategoryEditor.this.cutCategory || destination == GuiCategoryEditor.this.cutCategorySuper) {
                this.setCutCategory(null, null);
                this.updateEntries();
                return;
            }
            ((EditorNode)destination).getExpandAction(this).run();
            this.setLastExpandedData((EditorNode)GuiCategoryEditor.this.cutCategory);
            ((EditorCategoryNode)GuiCategoryEditor.this.cutCategorySuper).getSubCategories().remove(GuiCategoryEditor.this.cutCategory);
            ((EditorCategoryNode)destination).getSubCategories().add(0, GuiCategoryEditor.this.cutCategory);
            this.setCutCategory(null, null);
        }

        public boolean m_5694_() {
            return GuiCategoryEditor.this.m_7222_() == this;
        }

        public void setLastExpandedData(EditorNode lastExpandedData) {
            this.lastExpandedData = lastExpandedData;
        }

        public void restoreScrollAfterUpdate() {
            this.restoreScrollAfterUpdate = true;
        }

        public void updateEntries() {
            double scrollBackup = this.m_93517_();
            this.m_93516_();
            ((EditorNode)GuiCategoryEditor.this.editorData).setExpanded(true);
            this.addEntriesForExpanded((EditorNode)GuiCategoryEditor.this.editorData, null);
            if (this.m_93511_() != null) {
                this.m_93494_((AbstractSelectionList.Entry)((Entry)this.m_93511_()));
            }
            if (this.restoreScrollAfterUpdate) {
                this.m_93410_(scrollBackup);
                this.restoreScrollAfterUpdate = false;
            }
        }

        private void addEntriesForExpanded(EditorNode data, EditorNode parent) {
            int nextIndex = this.m_6702_().size();
            List<EditorNode> subExpandables = data.getSubNodes();
            if (subExpandables == null) {
                return;
            }
            EditorNode expandedData = null;
            for (EditorNode sed : subExpandables) {
                if (!sed.isExpanded()) continue;
                expandedData = sed;
                break;
            }
            EditorListRootEntry wrappedEntry = data.getListEntryFactory().get(data, parent, nextIndex, nextIndex == 0 ? ConnectionLineType.NONE : ConnectionLineType.PATH, this, this.f_93388_, expandedData == null);
            Entry currentEntry = new Entry(wrappedEntry, nextIndex++);
            this.m_7085_((AbstractSelectionList.Entry)currentEntry);
            if (data == this.lastExpandedData) {
                this.setSelected(currentEntry);
            }
            if (expandedData != null) {
                this.addEntriesForExpanded(expandedData, data);
                return;
            }
            if (this.lastExpandedData == null && data.isExpanded()) {
                this.setSelected(currentEntry);
            }
            boolean first = true;
            for (EditorNode sed : subExpandables) {
                wrappedEntry = sed.getListEntryFactory().get(sed, data, nextIndex, first ? ConnectionLineType.HEAD_LEAF : ConnectionLineType.TAIL_LEAF, this, this.f_93388_, false);
                Entry leafEntry = new Entry(wrappedEntry, nextIndex++);
                this.m_7085_((AbstractSelectionList.Entry)leafEntry);
                if (sed == this.lastExpandedData) {
                    this.setSelected(leafEntry);
                }
                first = false;
            }
        }

        public boolean m_6375_(double d, double e, int i) {
            if (!this.m_5953_(d, e)) {
                this.setSelected(null);
            }
            return super.m_6375_(d, e, i);
        }

        public void m_94757_(double d, double e) {
            if (this.m_93511_() != null) {
                ((Entry)this.m_93511_()).m_94757_(d, e);
            }
            super.m_94757_(d, e);
        }

        public boolean m_7920_(int i, int j, int k) {
            if (this.m_93511_() != null && ((Entry)this.m_93511_()).m_7920_(i, j, k)) {
                return true;
            }
            return super.m_7920_(i, j, k);
        }

        public boolean m_5534_(char c, int i) {
            boolean result;
            if (this.m_93511_() != null && (result = ((Entry)this.m_93511_()).m_5534_(c, i))) {
                return true;
            }
            return super.m_5534_(c, i);
        }

        public void tick() {
            if (this.m_93511_() != null) {
                ((Entry)this.m_93511_()).tick();
            }
        }

        public boolean confirmSelection() {
            Entry entry = (Entry)this.m_93511_();
            if (entry == null) {
                return false;
            }
            EditorListEntry selectedSubEntry = entry.wrappedEntry.confirmSelection();
            return selectedSubEntry != null;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public void setSelected(Entry entry) {
            if (this.m_93511_() != null) {
                ((Entry)this.m_93511_()).wrappedEntry.unfocusRecursively();
            }
            if (this.m_7222_() != null) {
                ((Entry)this.m_7222_()).m_5755_(false);
            }
            if (entry != null) {
                entry.wrappedEntry.focusFirstRecursively();
            }
            super.m_6987_((AbstractSelectionList.Entry)entry);
            super.m_7522_((GuiEventListener)entry);
            this.narrateSelection();
        }

        public void m_7522_(GuiEventListener guiEventListener) {
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + 164;
        }

        public void narrateSelection() {
            GuiCategoryEditor.this.m_169416_();
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
            super.m_142291_(narrationElementOutput);
            if (this.m_5694_()) {
                narrationElementOutput.m_169149_(NarratedElementType.USAGE, new Component[]{USAGE_NARRATION, LEFT_RIGHT_USAGE});
            }
        }

        public void m_6305_(PoseStack poseStack, int i, int j, float f) {
            this.hovered = null;
            super.m_6305_(poseStack, i, j, f);
        }

        public EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> getDataConverter() {
            return this.dataConverter;
        }

        public class Entry
        extends ObjectSelectionList.Entry<xaero.hud.category.ui.GuiCategoryEditor$SettingRowList.Entry> {
            private EditorListRootEntry wrappedEntry;
            private int index;
            private int lastX;
            private int lastY;

            public Entry(EditorListRootEntry entryInfo, int index) {
                this.wrappedEntry = entryInfo;
                this.index = index;
            }

            public void m_6311_(PoseStack poseStack, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                this.lastX = x;
                this.lastY = y;
                poseStack.m_85836_();
                poseStack.m_85837_((double)x, (double)y, 0.0);
                boolean includesSelected = SettingRowList.this.m_93511_() == this;
                this.wrappedEntry.preRender(poseStack, includesSelected, true);
                EditorListEntry hoveredInRow = this.wrappedEntry.render(poseStack, index, rowWidth, rowHeight, mouseX - x - this.wrappedEntry.getEntryRelativeX(), mouseY - y - this.wrappedEntry.getEntryRelativeY(), isMouseOver, partialTicks, GuiCategoryEditor.this.f_96547_, mouseX, mouseY, includesSelected, true);
                this.wrappedEntry.postRender(poseStack);
                poseStack.m_85849_();
                if (hoveredInRow != null) {
                    SettingRowList.this.hovered = hoveredInRow;
                }
            }

            public boolean m_6375_(double mouseX, double mouseY, int i) {
                SettingRowList.this.setSelected(this);
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                double relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY();
                this.wrappedEntry.mouseClicked(this, relativeMouseX, relativeMouseY, i);
                return true;
            }

            public boolean m_6348_(double mouseX, double mouseY, int i) {
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                double relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY();
                this.wrappedEntry.mouseReleased(relativeMouseX, relativeMouseY, i);
                return super.m_6348_(mouseX, mouseY, i);
            }

            public boolean m_6050_(double mouseX, double mouseY, double f) {
                double relativeMouseY;
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                if (this.wrappedEntry.mouseScrolled(relativeMouseX, relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY(), f)) {
                    return true;
                }
                return super.m_6050_(mouseX, mouseY, f);
            }

            public boolean m_7979_(double mouseX, double mouseY, int i, double f, double g) {
                double relativeMouseY;
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                if (this.wrappedEntry.mouseDragged(relativeMouseX, relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY(), i, f, g)) {
                    return true;
                }
                return super.m_7979_(mouseX, mouseY, i, f, g);
            }

            public boolean m_7933_(int i, int j, int k) {
                if (this.wrappedEntry.keyPressed(i, j, k, true)) {
                    return true;
                }
                return super.m_7933_(i, j, k);
            }

            public boolean m_7920_(int i, int j, int k) {
                if (this.wrappedEntry.keyReleased(i, j, k)) {
                    return true;
                }
                return super.m_7920_(i, j, k);
            }

            public boolean m_5534_(char c, int i) {
                if (this.wrappedEntry.charTyped(c, i)) {
                    return true;
                }
                return super.m_5534_(c, i);
            }

            public boolean m_5755_(boolean bl) {
                this.wrappedEntry.changeFocus(bl);
                return super.m_5755_(bl);
            }

            public void tick() {
                this.wrappedEntry.tick();
            }

            public Component m_142172_() {
                String selectedNarrationString = this.wrappedEntry.getSubNarration();
                if (selectedNarrationString == null) {
                    return Component.m_237113_((String)"");
                }
                return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{selectedNarrationString});
            }
        }
    }
}

