/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.form.model.part;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import org.lwjgl.opengl.GL11;
import xaero.common.graphics.CustomRenderTypes;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.render.form.model.part.ModelPartUtil;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelPartRenderTrace;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class RadarIconModelPartPrerenderer {
    public final Method ageableModelHeadPartsMethod = ReflectionUtils.getMethodReflection(AgeableListModel.class, (String)"headParts", (String)"method_22946", (String)"()Ljava/lang/Iterable;", (String)"m_5607_", (Class[])new Class[0]);
    public final Method ageableModelBodyPartsMethod = ReflectionUtils.getMethodReflection(AgeableListModel.class, (String)"bodyParts", (String)"method_22948", (String)"()Ljava/lang/Iterable;", (String)"m_5608_", (Class[])new Class[0]);
    public final Method listModelPartsMethod = ReflectionUtils.getMethodReflection(ListModel.class, (String)"parts", (String)"method_22960", (String)"()Ljava/lang/Iterable;", (String)"m_6195_", (Class[])new Class[0]);
    private final VertexConsumerWrapper vertexConsumerWrapper = new VertexConsumerWrapper();
    private boolean testedRenderEngineWrapperCompatibility;
    private boolean renderEngineIsWrapperCompatible;
    private MultiBufferSource.BufferSource testBufferSource = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(256));

    public void renderPart(PoseStack matrixStack, VertexConsumer vertexConsumer, ModelPart part, ModelPart mainPart, Parameters parameters) {
        if (part == null) {
            return;
        }
        if (parameters.renderedDest.contains(part)) {
            return;
        }
        ModelPartRenderTrace renderInfo = parameters.mrt.getModelPartRenderInfo(part);
        if (renderInfo == null) {
            return;
        }
        if (!ModelPartUtil.hasCubes(part)) {
            return;
        }
        boolean showModelBU = part.f_104207_;
        boolean skipDrawBU = part.f_233556_;
        if (!this.testedRenderEngineWrapperCompatibility) {
            this.testRenderEngineWrapperCompatibility(part, parameters.mrt, renderInfo);
        }
        float centerPointX = mainPart.f_104200_;
        float centerPointY = mainPart.f_104201_;
        float centerPointZ = mainPart.f_104202_;
        ModelPart.Cube biggestMainPartCuboid = ModelPartUtil.getBiggestCuboid(mainPart);
        if (biggestMainPartCuboid != null) {
            centerPointY += (biggestMainPartCuboid.f_104339_ + biggestMainPartCuboid.f_104336_) / 2.0f;
            centerPointZ += (biggestMainPartCuboid.f_104340_ + biggestMainPartCuboid.f_104337_) / 2.0f;
        }
        float xRotBU = 0.0f;
        float yRotBU = 0.0f;
        float zRotBU = 0.0f;
        if (parameters.config.modelPartsRotationReset) {
            xRotBU = part.f_104203_;
            yRotBU = part.f_104204_;
            zRotBU = part.f_104205_;
            PartPose initPose = part.m_233566_();
            part.m_171327_(initPose.f_171408_, initPose.f_171409_, initPose.f_171410_);
        }
        part.f_104207_ = true;
        part.f_233556_ = false;
        float xBU = part.f_104200_;
        float yBU = part.f_104201_;
        float zBU = part.f_104202_;
        part.m_104227_(part.f_104200_ - centerPointX, part.f_104201_ - centerPointY, part.f_104202_ - centerPointZ);
        try {
            if (this.renderEngineIsWrapperCompatible) {
                vertexConsumer = this.vertexConsumerWrapper.prepareDetection(vertexConsumer, 3.0, 61.0, 3.0, 61.0, -497.0, -2.0);
            }
            part.m_104306_(matrixStack, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
            if ((!this.renderEngineIsWrapperCompatible || this.vertexConsumerWrapper.hasDetectedVertex()) && renderInfo.alpha > 0.0f) {
                parameters.renderedDest.add(part);
            }
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.info("Exception when rendering entity part. " + part + " " + t.getMessage());
        }
        part.m_104227_(xBU, yBU, zBU);
        while (GL11.glGetError() != 0) {
        }
        if (parameters.config.modelPartsRotationReset) {
            part.m_171327_(xRotBU, yRotBU, zRotBU);
        }
        part.f_104207_ = showModelBU;
        part.f_233556_ = skipDrawBU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRenderEngineWrapperCompatibility(ModelPart part, ModelRenderTrace mrt, ModelPartRenderTrace renderInfo) {
        boolean normalWorks = false;
        try {
            PoseStack testMatrix = new PoseStack();
            testMatrix.m_252880_(0.0f, 0.0f, -2500.0f);
            VertexConsumer actualVertexConsumer = this.testBufferSource.m_6299_(CustomRenderTypes.entityIconRenderType(mrt.renderTexture, mrt.layerPhases));
            part.m_104306_(testMatrix, actualVertexConsumer, 0xF000F0, OverlayTexture.f_118083_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
            normalWorks = true;
            testMatrix = new PoseStack();
            testMatrix.m_252880_(0.0f, 0.0f, -2500.0f);
            this.vertexConsumerWrapper.prepareDetection(actualVertexConsumer, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            part.f_104207_ = true;
            part.f_233556_ = false;
            part.m_104306_(testMatrix, (VertexConsumer)this.vertexConsumerWrapper, 0xF000F0, OverlayTexture.f_118083_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
            this.renderEngineIsWrapperCompatible = this.vertexConsumerWrapper.hasDetectedVertex();
            if (!this.renderEngineIsWrapperCompatible) {
                throw new Exception("can't detect vertices");
            }
        }
        catch (Throwable t) {
            if (normalWorks) {
                MinimapLogs.LOGGER.warn("Render engine used for entities is not fully compatible with the minimap entity icons. Using fallback. " + t.getMessage());
            }
        }
        finally {
            this.testBufferSource.m_173043_();
        }
        if (normalWorks) {
            this.testedRenderEngineWrapperCompatibility = true;
        }
    }

    public <T extends Entity> ModelPart renderDeclaredMethod(PoseStack matrixStack, VertexConsumer vertexConsumer, Method method, EntityModel<T> model, ModelPart mainPart, Parameters parameters) {
        if (method == null) {
            return mainPart;
        }
        return this.renderPartsIterable((Iterable)ReflectionUtils.getReflectMethodValue(model, (Method)method, (Object[])new Object[0]), matrixStack, vertexConsumer, mainPart, parameters);
    }

    public ModelPart renderPartsIterable(Iterable<ModelPart> parts, PoseStack matrixStack, VertexConsumer vertexConsumer, ModelPart mainPart, Parameters parameters) {
        if (parts == null) {
            return mainPart;
        }
        Iterator<ModelPart> partsIterator = parts.iterator();
        if (!partsIterator.hasNext()) {
            return mainPart;
        }
        if (mainPart == null) {
            mainPart = partsIterator.next();
            this.renderPart(matrixStack, vertexConsumer, mainPart, mainPart, parameters);
        }
        while (partsIterator.hasNext()) {
            this.renderPart(matrixStack, vertexConsumer, partsIterator.next(), mainPart, parameters);
        }
        return mainPart;
    }

    public static class VertexConsumerWrapper
    implements VertexConsumer {
        private VertexConsumer consumer;
        private boolean detectedVertex;
        private double detectionMinX;
        private double detectionMaxX;
        private double detectionMinY;
        private double detectionMaxY;
        private double detectionMinZ;
        private double detectionMaxZ;

        public VertexConsumerWrapper prepareDetection(VertexConsumer consumer, double detectionMinX, double detectionMaxX, double detectionMinY, double detectionMaxY, double detectionMinZ, double detectionMaxZ) {
            this.consumer = consumer;
            this.detectionMinX = detectionMinX;
            this.detectionMaxX = detectionMaxX;
            this.detectionMinY = detectionMinY;
            this.detectionMaxY = detectionMaxY;
            this.detectionMinZ = detectionMinZ;
            this.detectionMaxZ = detectionMaxZ;
            this.detectedVertex = false;
            return this;
        }

        public VertexConsumer m_5483_(double d, double e, double f) {
            if (d >= this.detectionMinX && d <= this.detectionMaxX && e >= this.detectionMinY && e <= this.detectionMaxY && f >= this.detectionMinZ && f <= this.detectionMaxZ) {
                this.detectedVertex = true;
            }
            return this.consumer.m_5483_(d, e, f);
        }

        public VertexConsumer m_6122_(int i, int j, int k, int l) {
            return this.consumer.m_6122_(i, j, k, l);
        }

        public VertexConsumer m_7421_(float f, float g) {
            return this.consumer.m_7421_(f, g);
        }

        public VertexConsumer m_7122_(int i, int j) {
            return this.consumer.m_7122_(i, j);
        }

        public VertexConsumer m_7120_(int i, int j) {
            return this.consumer.m_7120_(i, j);
        }

        public VertexConsumer m_5601_(float f, float g, float h) {
            return this.consumer.m_5601_(f, g, h);
        }

        public void m_5752_() {
            this.consumer.m_5752_();
        }

        public boolean hasDetectedVertex() {
            return this.detectedVertex;
        }

        public void m_7404_(int i, int j, int k, int l) {
            this.consumer.m_7404_(i, j, k, l);
        }

        public void m_141991_() {
            this.consumer.m_141991_();
        }
    }

    public static class Parameters {
        public final RadarIconModelConfig config;
        public final ModelRenderTrace mrt;
        public final List<ModelPart> renderedDest;

        public Parameters(RadarIconModelConfig config, ModelRenderTrace mrt, List<ModelPart> renderedDest) {
            this.config = config;
            this.mrt = mrt;
            this.renderedDest = renderedDest;
        }
    }
}

