/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.trace;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.SpriteCoordinateExpander;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.rendertype.LayeringTransform;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.TextureTransform;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import org.lwjgl.opengl.GL11;
import xaero.common.core.IBufferSource;
import xaero.common.exception.OpenGLException;
import xaero.common.misc.CachedFunction;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.render.pipeline.RenderPipelineWrapper;
import xaero.lib.client.graphics.IRenderType;
import xaero.lib.client.graphics.XaeroRenderType;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class EntityRenderTracer {
    public static boolean TRACING_MODEL_RENDERS;
    private Entity tracedEntity;
    private EntityRenderState tracedEntityRenderState;
    private EntityRenderer tracedEntityRenderer;
    private Class<?> tracedEntityModelClass;
    private List<ModelRenderTrace> traceResultList;
    private ModelRenderTrace lastModelRenderDetected;
    private MultiBufferSource.BufferSource modelRenderDetectionRenderTypeBuffer;
    private Field enderDragonModelField;
    private Field renderBuffersBufferSourceField;
    private Field spriteCoordinateExpanderSpriteField;
    private Class<?> irisRenderLayerWrapperClass;
    private Method irisRenderLayerWrapperUnwrapMethod;
    private CachedFunction<RenderPipeline, RenderPipeline> fixAdditiveBlendFunction;

    public EntityRenderTracer() {
        this.initReflection();
        this.traceResultList = new ArrayList<ModelRenderTrace>();
        this.fixAdditiveBlendFunction = new CachedFunction<RenderPipeline, RenderPipeline>(this::fixAdditiveBlendUncached);
    }

    public <S extends EntityRenderState> List<ModelRenderTrace> trace(PoseStack matrixStack, Entity entity, EntityRenderer<?, ? super S> entityRenderer, S entityRenderState) {
        TRACING_MODEL_RENDERS = true;
        this.tracedEntity = entity;
        this.tracedEntityRenderState = entityRenderState;
        this.tracedEntityRenderer = entityRenderer;
        this.tracedEntityModelClass = null;
        this.traceResultList.clear();
        this.lastModelRenderDetected = null;
        PoseStack.Pose matrixEntryToRestore = matrixStack.last();
        matrixStack.pushPose();
        try {
            MultiBufferSource.BufferSource renderTypeBuffer = this.modelRenderDetectionRenderTypeBuffer = (MultiBufferSource.BufferSource)ReflectionUtils.getReflectFieldValue((Object)Minecraft.getInstance().renderBuffers(), (Field)this.renderBuffersBufferSourceField);
            ((IBufferSource)renderTypeBuffer).setXaero_lastRenderType(null);
            Minecraft mc = Minecraft.getInstance();
            EntityRenderDispatcher renderDispatcher = mc.getEntityRenderDispatcher();
            FeatureRenderDispatcher featureRenderDispatcher = Minecraft.getInstance().gameRenderer.getFeatureRenderDispatcher();
            CameraRenderState cameraState = new CameraRenderState();
            renderDispatcher.submit(entityRenderState, cameraState, 0.0, 0.0, 0.0, matrixStack, (SubmitNodeCollector)featureRenderDispatcher.getSubmitNodeStorage());
            featureRenderDispatcher.renderAllFeatures();
            renderTypeBuffer.endBatch();
            OpenGLException.checkGLError();
        }
        catch (Throwable e) {
            this.traceResultList.clear();
            MinimapLogs.LOGGER.error("Exception when calling the full entity renderer for {} before prerendering the icon.", (Object)entity.getScoreboardName(), (Object)e);
        }
        TRACING_MODEL_RENDERS = false;
        this.tracedEntity = null;
        this.tracedEntityRenderState = null;
        this.tracedEntityRenderer = null;
        while (matrixStack.last() != matrixEntryToRestore) {
            matrixStack.popPose();
        }
        while (GL11.glGetError() != 0) {
        }
        return this.traceResultList;
    }

    public void onModelRender(Model model, VertexConsumer vertexConsumer, int color) {
        this.lastModelRenderDetected = null;
        if (this.tracedEntityModelClass == null) {
            EntityModel currentMainModel = this.getEntityRendererModel(this.tracedEntityRenderer);
            Class<?> clazz = this.tracedEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
            if (this.tracedEntityModelClass == null) {
                return;
            }
        }
        if (!model.getClass().isAssignableFrom(this.tracedEntityModelClass) && !this.tracedEntityModelClass.isAssignableFrom(model.getClass())) {
            return;
        }
        RenderType lastRenderType = this.getLastRenderType((MultiBufferSource)this.modelRenderDetectionRenderTypeBuffer);
        if (lastRenderType == null && this.traceResultList.isEmpty()) {
            Identifier textureLocation = null;
            try {
                Identifier textureLocationUnchecked;
                Identifier identifier;
                EntityRenderer entityRenderer = this.tracedEntityRenderer;
                if (entityRenderer instanceof LivingEntityRenderer) {
                    LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)entityRenderer;
                    identifier = livingEntityRenderer.getTextureLocation((LivingEntityRenderState)this.tracedEntityRenderState);
                } else {
                    identifier = null;
                }
                textureLocation = textureLocationUnchecked = identifier;
            }
            catch (Throwable t) {
                MinimapLogs.LOGGER.error("Couldn't fetch main entity texture when trying to use an alternative render type for an icon!", t);
            }
            if (textureLocation != null) {
                lastRenderType = model.renderType(textureLocation);
            }
        }
        if (lastRenderType == null) {
            return;
        }
        RenderSetup renderState = this.getRenderState(lastRenderType);
        if (renderState == null) {
            return;
        }
        RenderPipeline renderPipeline = lastRenderType.pipeline();
        Map textures = XaeroRenderType.getSetupTextures((RenderSetup)renderState);
        TextureTransform textureTransform = XaeroRenderType.getSetupTextureTransform((RenderSetup)renderState);
        boolean useOverlay = XaeroRenderType.getSetupUseOverlay((RenderSetup)renderState);
        LayeringTransform layeringTransform = XaeroRenderType.getSetupLayeringTransform((RenderSetup)renderState);
        renderPipeline = this.fixAdditiveBlendFunction.apply(renderPipeline);
        TextureAtlasSprite renderAtlasSprite = null;
        if (vertexConsumer instanceof SpriteCoordinateExpander) {
            renderAtlasSprite = (TextureAtlasSprite)ReflectionUtils.getReflectFieldValue((Object)vertexConsumer, (Field)this.spriteCoordinateExpanderSpriteField);
        }
        this.lastModelRenderDetected = new ModelRenderTrace(model, textures, textureTransform, useOverlay, lastRenderType.affectsCrumbling(), lastRenderType.sortOnUpload(), layeringTransform, renderAtlasSprite, renderPipeline, color);
        this.traceResultList.add(this.lastModelRenderDetected);
    }

    private RenderPipeline fixAdditiveBlendUncached(RenderPipeline renderPipeline) {
        SourceFactor blendSrcFactor;
        RenderPipeline result = renderPipeline;
        BlendFunction blendFunction = renderPipeline.getBlendFunction().orElse(null);
        if (blendFunction == null) {
            return result;
        }
        DestFactor blendDestFactor = blendFunction.destColor();
        if (blendDestFactor == DestFactor.ONE && (blendSrcFactor = blendFunction.sourceColor()) != SourceFactor.ZERO) {
            blendFunction = new BlendFunction(blendSrcFactor, blendDestFactor, SourceFactor.ZERO, DestFactor.ONE);
            RenderPipelineWrapper wrapper = new RenderPipelineWrapper(Identifier.fromNamespaceAndPath((String)"xaerominimap", (String)("wrapper/" + result.getLocation().getPath())), result);
            wrapper.setBlendFunctionOverride(Optional.of(blendFunction));
            result = wrapper;
        }
        return result;
    }

    public void onModelPartRender(ModelPart modelRenderer, int color) {
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, color);
        }
    }

    private RenderType getLastRenderType(MultiBufferSource renderTypeBuffer) {
        if (renderTypeBuffer instanceof IBufferSource) {
            IBufferSource xaeroBufferSource = (IBufferSource)renderTypeBuffer;
            return xaeroBufferSource.getXaero_lastRenderType();
        }
        return null;
    }

    private RenderSetup getRenderState(RenderType renderType) {
        while (renderType.getClass() == this.irisRenderLayerWrapperClass && this.irisRenderLayerWrapperUnwrapMethod != null) {
            renderType = (RenderType)ReflectionUtils.getReflectMethodValue((Object)renderType, (Method)this.irisRenderLayerWrapperUnwrapMethod, (Object[])new Object[0]);
        }
        return ((IRenderType)renderType).xaero_lib_getSetup();
    }

    public <S extends EntityRenderState> EntityModel<S> getEntityRendererModel(EntityRenderer<?, ? super S> entityRenderer) {
        if (entityRenderer instanceof LivingEntityRenderer) {
            return ((LivingEntityRenderer)entityRenderer).getModel();
        }
        if (entityRenderer instanceof EnderDragonRenderer) {
            return (EntityModel)ReflectionUtils.getReflectFieldValue(entityRenderer, (Field)this.enderDragonModelField);
        }
        return null;
    }

    private void initReflection() {
        this.enderDragonModelField = ReflectionUtils.getFieldReflection(EnderDragonRenderer.class, (String)"model", (String)"field_21008", (String)"Lnet/minecraft/class_625;", (String)"f_114183_");
        this.renderBuffersBufferSourceField = ReflectionUtils.getFieldReflection(RenderBuffers.class, (String)"bufferSource", (String)"field_46901", (String)"Lnet/minecraft/class_4597$class_4598;", (String)"f_110094_");
        this.spriteCoordinateExpanderSpriteField = ReflectionUtils.getFieldReflection(SpriteCoordinateExpander.class, (String)"sprite", (String)"field_21731", (String)"Lnet/minecraft/class_1058;", (String)"f_110796_");
        try {
            try {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderTypeWrapper");
            }
            catch (ClassNotFoundException e) {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderLayerWrapper");
            }
            this.irisRenderLayerWrapperUnwrapMethod = ReflectionUtils.getMethodReflection(this.irisRenderLayerWrapperClass, (String)"unwrap", (String)"unwrap", (String)"()Lnet/minecraft/class_1921;", (String)"unwrap", (Class[])new Class[0]);
            MinimapLogs.LOGGER.info("Old Iris detected and supported!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset() {
        this.fixAdditiveBlendFunction = new CachedFunction<RenderPipeline, RenderPipeline>(this::fixAdditiveBlendUncached);
    }
}

