/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import xaero.pac.client.gui.SimpleValueWidgetListElement;
import xaero.pac.client.gui.widget.dropdown.DropDownWidget;
import xaero.pac.client.gui.widget.dropdown.IDropDownContainer;
import xaero.pac.client.gui.widget.dropdown.IDropDownWidgetCallback;

public final class DropdownWidgetListElement<T>
extends SimpleValueWidgetListElement<T, DropdownWidgetListElement<T>>
implements IDropDownWidgetCallback {
    private final Consumer<T> valueChangeConsumer;
    private final List<T> options;
    private int currentIndex;
    private final Component title;

    private DropdownWidgetListElement(int w, int h, boolean mutable, BiFunction<DropdownWidgetListElement<T>, Vec3i, AbstractWidget> widgetSupplier, List<FormattedCharSequence> tooltip, T startValue, int startIndex, List<T> options, Consumer<T> valueChangeConsumer, Component title) {
        super(startValue, w, h, mutable, widgetSupplier, tooltip);
        this.options = options;
        this.currentIndex = startIndex;
        this.valueChangeConsumer = valueChangeConsumer;
        this.title = title;
    }

    @Override
    public void render(PoseStack poseStack) {
        super.render(poseStack);
        Minecraft.getInstance().font.drawShadow(poseStack, this.title, (float)this.x, (float)(this.y + 6), this.mutable ? -1 : 0xE0E0E0);
    }

    @Override
    public boolean onSelected(DropDownWidget menu, int selected) {
        this.currentIndex = selected;
        this.draftValue = this.options.get(this.currentIndex);
        this.valueChangeConsumer.accept(this.draftValue);
        return true;
    }

    public static final class Builder<T>
    extends SimpleValueWidgetListElement.Builder<T, DropdownWidgetListElement<T>, Builder<T>> {
        private int startIndex;
        private List<T> options;
        private Consumer<T> valueChangeConsumer;
        private Component title;

        @Override
        public Builder<T> setDefault() {
            super.setDefault();
            this.setStartIndex(-1);
            this.setOptions(null);
            this.setValueChangeConsumer(v -> {});
            this.setTitle(null);
            return (Builder)this.self;
        }

        @Override
        public Builder<T> setStartValue(T startValue) {
            if (startValue != null) {
                throw new IllegalArgumentException();
            }
            return (Builder)super.setStartValue(startValue);
        }

        public Builder<T> setStartIndex(int startIndex) {
            this.startIndex = startIndex;
            return (Builder)this.self;
        }

        public Builder<T> setOptions(List<T> options) {
            this.options = options;
            return (Builder)this.self;
        }

        public Builder<T> setValueChangeConsumer(Consumer<T> valueChangeConsumer) {
            this.valueChangeConsumer = valueChangeConsumer;
            return (Builder)this.self;
        }

        public Builder<T> setTitle(Component title) {
            this.title = title;
            return (Builder)this.self;
        }

        @Override
        public DropdownWidgetListElement<T> build() {
            if (this.startIndex == -1 || this.options == null || this.valueChangeConsumer == null || this.title == null) {
                throw new IllegalStateException();
            }
            this.startValue = this.options.get(this.startIndex);
            return (DropdownWidgetListElement)super.build();
        }

        @Override
        protected DropdownWidgetListElement<T> buildInternal() {
            String[] stringOptions = new String[this.options.size()];
            for (int i = 0; i < this.options.size(); ++i) {
                stringOptions[i] = Objects.toString(this.options.get(i));
            }
            int titleWidth = Minecraft.getInstance().font.width((FormattedText)this.title);
            int margin = 4;
            BiFunction widgetSupplier = (el, xy) -> DropDownWidget.Builder.begin().setX(xy.getX() + titleWidth + margin).setY(xy.getY() + 4).setW(this.w - titleWidth - margin - 1).setOptions(stringOptions).setNarrationTitle(this.title).setCallback((IDropDownWidgetCallback)el).setContainer((IDropDownContainer)Minecraft.getInstance().screen).setSelected(el.currentIndex).build();
            return new DropdownWidgetListElement<Object>(this.w, this.h, this.mutable, widgetSupplier, this.tooltip, this.startValue, this.startIndex, List.copyOf(this.options), this.valueChangeConsumer, this.title);
        }

        public static <T> Builder<T> begin() {
            return new Builder<T>().setDefault();
        }
    }
}

