/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.Vec3i;
import net.minecraft.util.FormattedCharSequence;
import xaero.pac.client.gui.WidgetListScreen;

public abstract class WidgetListElement<E extends WidgetListElement<E>> {
    protected final E self = this;
    private final BiFunction<E, Vec3i, AbstractWidget> widgetSupplier;
    private final List<FormattedCharSequence> tooltip;
    protected int x;
    protected int y;
    protected final int w;
    protected final int h;
    protected final boolean mutable;

    protected WidgetListElement(int w, int h, boolean mutable, BiFunction<E, Vec3i, AbstractWidget> widgetSupplier, List<FormattedCharSequence> tooltip) {
        this.w = w;
        this.h = h;
        this.mutable = mutable;
        this.widgetSupplier = widgetSupplier;
        this.tooltip = tooltip;
    }

    public AbstractWidget screenInit(int x, int y, WidgetListScreen screen, List<EditBox> tickableBoxes) {
        this.x = x;
        this.y = y;
        AbstractWidget widget = this.widgetSupplier.apply(this.self, new Vec3i(x, y, 0));
        screen.addRenderableWidget(widget);
        widget.active = this.mutable;
        if (widget instanceof EditBox) {
            tickableBoxes.add((EditBox)widget);
            ((EditBox)widget).setEditable(this.mutable);
        }
        return widget;
    }

    public boolean isOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseX < this.x + this.w && mouseY >= this.y && mouseY < this.y + this.h;
    }

    public List<FormattedCharSequence> getTooltip() {
        return this.tooltip;
    }

    public void render(PoseStack poseStack) {
    }

    public static abstract class Builder<E extends WidgetListElement<E>, B extends Builder<E, B>> {
        protected final B self = this;
        protected BiFunction<E, Vec3i, AbstractWidget> widgetSupplier;
        protected int w;
        protected int h;
        protected List<FormattedCharSequence> tooltip;
        protected boolean mutable;

        public B setDefault() {
            this.setW(0);
            this.setH(0);
            this.setTooltip(null);
            this.setMutable(true);
            this.setWidgetSupplier(null);
            return this.self;
        }

        public B setWidgetSupplier(BiFunction<E, Vec3i, AbstractWidget> widgetSupplier) {
            this.widgetSupplier = widgetSupplier;
            return this.self;
        }

        public B setW(int w) {
            this.w = w;
            return this.self;
        }

        public B setH(int h) {
            this.h = h;
            return this.self;
        }

        public B setTooltip(List<FormattedCharSequence> tooltip) {
            this.tooltip = tooltip;
            return this.self;
        }

        public B setMutable(boolean mutable) {
            this.mutable = mutable;
            return this.self;
        }

        public E build() {
            return this.buildInternal();
        }

        protected abstract E buildInternal();
    }
}

