/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.packet.config.ClientboundPlayerConfigHelpPacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.command.ConfigCommandUtil;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.config.sub.PlayerSubConfig;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ConfigGetOrHelpCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment) {
        SuggestionProvider<CommandSourceStack> optionSuggestor = ConfigGetOrHelpCommand.getOptionSuggestor();
        SuggestionProvider<CommandSourceStack> playerSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.PLAYER);
        SuggestionProvider<CommandSourceStack> serverSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.SERVER);
        this.registerGetCommands(false, optionSuggestor, playerSubConfigSuggestionProvider, serverSubConfigSuggestionProvider, dispatcher);
        this.registerGetCommands(true, optionSuggestor, playerSubConfigSuggestionProvider, serverSubConfigSuggestionProvider, dispatcher);
    }

    private void registerGetCommands(boolean help, SuggestionProvider<CommandSourceStack> optionSuggestor, SuggestionProvider<CommandSourceStack> playerSubConfigSuggestionProvider, SuggestionProvider<CommandSourceStack> serverSubConfigSuggestionProvider, CommandDispatcher<CommandSourceStack> dispatcher) {
        String literalPrefix = help ? "help" : "get";
        Command<CommandSourceStack> regularExecutor = ConfigGetOrHelpCommand.getExecutor(PlayerConfigType.PLAYER, help);
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(((LiteralArgumentBuilder)Commands.literal((String)literalPrefix).requires(sourceStack -> true)).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(regularExecutor))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(Commands.literal((String)"sub").then(((LiteralArgumentBuilder)Commands.literal((String)literalPrefix).requires(sourceStack -> true)).then(Commands.argument((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(playerSubConfigSuggestionProvider).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(regularExecutor))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(((LiteralArgumentBuilder)Commands.literal((String)"for").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.literal((String)literalPrefix).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(regularExecutor))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(((LiteralArgumentBuilder)Commands.literal((String)"for").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.literal((String)"sub").then(Commands.literal((String)literalPrefix).then(Commands.argument((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(playerSubConfigSuggestionProvider).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(regularExecutor))))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(((LiteralArgumentBuilder)Commands.literal((String)"default").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)literalPrefix).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(ConfigGetOrHelpCommand.getExecutor(PlayerConfigType.DEFAULT_PLAYER, help))))));
        dispatcher.register(command);
        Command<CommandSourceStack> serverExecutor = ConfigGetOrHelpCommand.getExecutor(PlayerConfigType.SERVER, help);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(((LiteralArgumentBuilder)Commands.literal((String)"server-claims-config").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)literalPrefix).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(serverExecutor))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(((LiteralArgumentBuilder)Commands.literal((String)"server-claims-config").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)"sub").then(Commands.literal((String)literalPrefix).then(Commands.argument((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(serverSubConfigSuggestionProvider).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(serverExecutor))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(((LiteralArgumentBuilder)Commands.literal((String)"expired-claims-config").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)literalPrefix).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(ConfigGetOrHelpCommand.getExecutor(PlayerConfigType.EXPIRED, help)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(((LiteralArgumentBuilder)Commands.literal((String)"wilderness-config").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)literalPrefix).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(ConfigGetOrHelpCommand.getExecutor(PlayerConfigType.WILDERNESS, help)))));
        dispatcher.register(command);
    }

    static SuggestionProvider<CommandSourceStack> getOptionSuggestor() {
        return (context, builder) -> {
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(((CommandSourceStack)context.getSource()).getServer());
            return SharedSuggestionProvider.suggest(serverData.getPlayerConfigs().getAllOptionsStream().map(IPlayerConfigOptionSpecAPI::getShortenedId), (SuggestionsBuilder)builder);
        };
    }

    private static Command<CommandSourceStack> getExecutor(PlayerConfigType type, boolean help) {
        return context -> {
            PlayerSubConfig subConfig;
            IPlayerConfig playerConfig;
            IPlayerConfig effectivePlayerConfig;
            UUID configPlayerUUID;
            ServerPlayer sourcePlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            String targetConfigOptionId = StringArgumentType.getString((CommandContext)context, (String)"key");
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            PlayerConfigOptionSpec option = (PlayerConfigOptionSpec)serverData.getPlayerConfigs().getOptionForId(targetConfigOptionId);
            if (option == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_get_invalid_key", new Object[0]));
                return 0;
            }
            GameProfile inputPlayer = null;
            UUID uUID = configPlayerUUID = type == PlayerConfigType.SERVER ? PlayerConfig.SERVER_CLAIM_UUID : null;
            if (type == PlayerConfigType.PLAYER) {
                inputPlayer = ConfigCommandUtil.getConfigInputPlayer((CommandContext<CommandSourceStack>)context, sourcePlayer, "gui.xaero_pac_config_option_get_too_many_targets", "gui.xaero_pac_config_option_get_invalid_target", adaptiveLocalizer);
                if (inputPlayer == null) {
                    return 0;
                }
                configPlayerUUID = inputPlayer.getId();
            }
            if ((effectivePlayerConfig = ConfigCommandUtil.getEffectiveConfig((CommandContext<CommandSourceStack>)context, playerConfig = type == PlayerConfigType.DEFAULT_PLAYER ? serverData.getPlayerConfigs().getDefaultConfig() : (type == PlayerConfigType.EXPIRED ? serverData.getPlayerConfigs().getExpiredClaimConfig() : serverData.getPlayerConfigs().getLoadedConfig(configPlayerUUID)))) == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_get_invalid_sub", new Object[0]));
                return 0;
            }
            if (help) {
                ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(sourcePlayer);
                if (playerData.hasMod()) {
                    OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToPlayer(sourcePlayer, new ClientboundPlayerConfigHelpPacket(option.getId()));
                } else {
                    String translatedComment = serverData.getAdaptiveLocalizer().getDefaultTranslation(option.getCommentTranslation());
                    if (translatedComment.equals("default")) {
                        translatedComment = option.getComment();
                    }
                    sourcePlayer.sendMessage((Component)new TextComponent(""), sourcePlayer.getUUID());
                    sourcePlayer.sendMessage((Component)new TranslatableComponent(translatedComment, (Object[])option.getCommentTranslationArgs()), sourcePlayer.getUUID());
                }
                return 1;
            }
            if (!effectivePlayerConfig.isOptionAllowed(option)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_get_not_allowed", new Object[0]));
                return 0;
            }
            Object optionValue = effectivePlayerConfig.getFromEffectiveConfig(option);
            if (effectivePlayerConfig instanceof PlayerSubConfig && (subConfig = (PlayerSubConfig)effectivePlayerConfig).isInherited(option)) {
                optionValue = null;
            }
            Component optionValueName = option.getValueDisplayName(optionValue);
            if (type == PlayerConfigType.PLAYER) {
                sourcePlayer.sendMessage((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_get", inputPlayer.getName(), targetConfigOptionId, optionValueName), sourcePlayer.getUUID());
            } else {
                sourcePlayer.sendMessage((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_get", type.getName(), targetConfigOptionId, optionValueName), sourcePlayer.getUUID());
            }
            return 1;
        };
    }
}

