/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.localization;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.localization.api.IAdaptiveLocalizerAPI;

public class AdaptiveLocalizer
implements IAdaptiveLocalizerAPI {
    private final Map<String, String> defaultTranslations;

    public AdaptiveLocalizer(Map<String, String> defaultTranslations) {
        this.defaultTranslations = defaultTranslations;
    }

    @Override
    @Nonnull
    public MutableComponent getFor(@Nonnull ServerPlayer player, @Nonnull String key, Object ... args) {
        ServerPlayerData playerDataAPI = (ServerPlayerData)ServerPlayerData.from(player);
        if (playerDataAPI.hasMod()) {
            return new TranslatableComponent(key, args);
        }
        return this.getServerLocalizedComponent(key, args);
    }

    @Override
    @Nonnull
    public Component getFor(@Nonnull ServerPlayer player, @Nonnull Component component) {
        if (!(component instanceof TranslatableComponent)) {
            return component;
        }
        TranslatableComponent translatableComponent = (TranslatableComponent)component;
        ServerPlayerData playerDataAPI = (ServerPlayerData)ServerPlayerData.from(player);
        if (playerDataAPI.hasMod()) {
            return translatableComponent;
        }
        String key = translatableComponent.getKey();
        Object[] args = translatableComponent.getArgs();
        MutableComponent result = this.getServerLocalizedComponent(key, args).setStyle(component.getStyle());
        if (component.getSiblings() != null) {
            result.getSiblings().addAll(component.getSiblings());
        }
        return result;
    }

    private MutableComponent getServerLocalizedComponent(String key, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (!(object instanceof TranslatableComponent)) continue;
            TranslatableComponent translatableComponent = (TranslatableComponent)object;
            args[i] = this.getServerLocalizedComponent(translatableComponent.getKey(), translatableComponent.getArgs());
        }
        return new TranslatableComponent(this.defaultTranslations.getOrDefault(key, key), args);
    }

    public String getDefaultTranslation(String key) {
        return this.defaultTranslations.getOrDefault(key, key);
    }
}

