/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.mixin;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.pac.common.server.core.ServerCore;

@Mixin(value={EntityGetter.class})
public interface MixinOptionalEntityGetter {
    @Inject(at={@At(value="RETURN")}, method={"getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;"})
    default public void onGetEntitiesOfClass(Class<? extends Entity> c, AABB aabb, CallbackInfoReturnable<List<? extends Entity>> cir) {
        if (ServerCore.CALCULATING_PRESSURE_PLATE_WEIGHT != null) {
            if (!(this instanceof ServerLevel)) {
                return;
            }
            ServerCore.onEntitiesPushBlock((List)cir.getReturnValue(), ServerCore.CALCULATING_PRESSURE_PLATE_WEIGHT, ServerCore.CALCULATING_PRESSURE_PLATE_WEIGHT_POS);
            ServerCore.CALCULATING_PRESSURE_PLATE_WEIGHT = null;
        }
    }

    @ModifyVariable(method={"getEntityCollisions"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/level/EntityGetter;getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"))
    default public List<Entity> onGetEntityCollisions(List<Entity> collidingEntities, Entity entity, AABB aABB) {
        ServerCore.onEntitiesPushEntity(collidingEntities, entity);
        return collidingEntities;
    }
}

