/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import xaero.pac.client.player.config.PlayerConfigClientStorage;
import xaero.pac.common.packet.config.ClientboundPlayerConfigDynamicOptionsPacket;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigOptionCategory;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.PlayerConfigType;

public final class PlayerConfigStringOptionSpec
extends PlayerConfigOptionSpec<String> {
    private final int maxLength;

    private PlayerConfigStringOptionSpec(Class<String> type, String id, String shortenedId, List<String> path, String defaultValue, BiFunction<PlayerConfig<?>, String, String> defaultReplacer, String comment, String translation, String[] translationArgs, String commentTranslation, String[] commentTranslationArgs, PlayerConfigOptionCategory category, Function<String, String> commandInputParser, Function<String, Component> commandOutputWriter, BiPredicate<PlayerConfig<?>, String> serverSideValidator, BiPredicate<PlayerConfigClientStorage, String> clientSideValidator, int maxLength, String tooltipPrefix, Predicate<PlayerConfigType> configTypeFilter, ClientboundPlayerConfigDynamicOptionsPacket.OptionType syncOptionType, boolean dynamic) {
        super(type, id, shortenedId, path, defaultValue, defaultReplacer, comment, translation, translationArgs, commentTranslation, commentTranslationArgs, category, commandInputParser, commandOutputWriter, serverSideValidator, clientSideValidator, tooltipPrefix, configTypeFilter, syncOptionType, dynamic);
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public static final class Builder
    extends PlayerConfigOptionSpec.Builder<String, Builder> {
        private int maxLength;

        protected Builder() {
            super(String.class);
        }

        @Override
        public Builder setDefault() {
            this.setMaxLength(32);
            return (Builder)super.setDefault();
        }

        public Builder setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public static <T> Builder begin() {
            return new Builder().setDefault();
        }

        @Override
        protected Predicate<String> buildValueValidator() {
            Predicate normalValidator = super.buildValueValidator();
            return v -> {
                if (!normalValidator.test(v)) {
                    return false;
                }
                return v.length() <= this.maxLength;
            };
        }

        public PlayerConfigStringOptionSpec build(Map<String, PlayerConfigOptionSpec<?>> dest) {
            if (this.tooltipPrefix == null) {
                this.tooltipPrefix = String.format("~%s", this.maxLength);
            }
            return (PlayerConfigStringOptionSpec)super.build(dest);
        }

        protected PlayerConfigStringOptionSpec buildInternally(List<String> path, String shortenedId, Function<String, String> commandInputParser) {
            return new PlayerConfigStringOptionSpec(this.type, this.id, shortenedId, path, (String)((Object)this.defaultValue), this.defaultReplacer, this.comment, this.translation, this.translationArgs, this.commentTranslation, this.commentTranslationArgs, this.category, commandInputParser, this.commandOutputWriter, this.serverSideValidator, this.clientSideValidator, this.maxLength, this.tooltipPrefix, this.configTypeFilter, ClientboundPlayerConfigDynamicOptionsPacket.OptionType.STRING, this.dynamic);
        }
    }
}

