/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config.io;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.platform.Services;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.io.FileIOHelper;
import xaero.pac.common.server.io.FilePathConfig;
import xaero.pac.common.server.io.IOThreadWorker;
import xaero.pac.common.server.io.ObjectManagerIO;
import xaero.pac.common.server.io.serialization.SerializationHandler;
import xaero.pac.common.server.io.serialization.SerializedDataFileIO;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigManager;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.config.io.serialization.PlayerConfigDeserializationInfo;
import xaero.pac.common.server.player.config.io.serialization.PlayerConfigSerializationHandler;
import xaero.pac.common.server.player.config.sub.PlayerSubConfig;

public final class PlayerConfigIO<P extends IServerParty<?, ?, ?>, CM extends IServerClaimsManager<?, ?, ?>>
extends ObjectManagerIO<String, PlayerConfigDeserializationInfo, PlayerConfig<P>, PlayerConfigManager<P, CM>> {
    private final Path configsPath;
    private final Path configSubConfigPath;
    private final FilePathConfig defaultConfigPathConfig;
    private final FilePathConfig wildernessConfigPathConfig;
    private final FilePathConfig serverClaimConfigPathConfig;
    private final FilePathConfig expiredClaimConfigPathConfig;
    private final Path defaultConfigs;

    private PlayerConfigIO(SerializationHandler<String, PlayerConfigDeserializationInfo, PlayerConfig<P>, PlayerConfigManager<P, CM>> serializationHandler, SerializedDataFileIO<String, PlayerConfigDeserializationInfo> serializedDataFileIO, IOThreadWorker ioThreadWorker, MinecraftServer server, String fileExtension, PlayerConfigManager<P, CM> manager, FileIOHelper fileIOHelper) {
        super(serializationHandler, serializedDataFileIO, ioThreadWorker, server, fileExtension, manager, fileIOHelper);
        this.configsPath = server.getWorldPath(LevelResource.ROOT).resolve("data").resolve("openpartiesandclaims").resolve("player-configs");
        this.configSubConfigPath = server.getWorldPath(LevelResource.ROOT).resolve("data").resolve("openpartiesandclaims").resolve("player-configs").resolve("sub-configs");
        Path serverconfigPath = server.getWorldPath(LevelResource.ROOT).resolve("serverconfig");
        this.defaultConfigPathConfig = new FilePathConfig(serverconfigPath.resolve("openpartiesandclaims-default-player-config.toml"), false);
        this.wildernessConfigPathConfig = new FilePathConfig(serverconfigPath.resolve("openpartiesandclaims-wilderness-config.toml"), false);
        this.serverClaimConfigPathConfig = new FilePathConfig(serverconfigPath.resolve("openpartiesandclaims-server-claim-config.toml"), false);
        this.expiredClaimConfigPathConfig = new FilePathConfig(serverconfigPath.resolve("openpartiesandclaims-expired-claim-config.toml"), false);
        this.defaultConfigs = Services.PLATFORM.getDefaultConfigFolder();
    }

    @Override
    protected Stream<FilePathConfig> getObjectFolderPaths() {
        return Stream.of(new FilePathConfig(this.configsPath, false), new FilePathConfig(this.configSubConfigPath, true));
    }

    @Override
    public void load() {
        OpenPartiesAndClaims.LOGGER.info("Loading player configs...");
        this.loadGlobalConfig(PlayerConfigType.DEFAULT_PLAYER, this.defaultConfigPathConfig, ((PlayerConfigManager)this.manager)::setDefaultConfig);
        this.loadGlobalConfig(PlayerConfigType.WILDERNESS, this.wildernessConfigPathConfig, ((PlayerConfigManager)this.manager)::setWildernessConfig);
        this.loadGlobalConfig(PlayerConfigType.SERVER, this.serverClaimConfigPathConfig, ((PlayerConfigManager)this.manager)::setServerClaimConfig);
        this.loadGlobalConfig(PlayerConfigType.EXPIRED, this.expiredClaimConfigPathConfig, ((PlayerConfigManager)this.manager)::setExpiredClaimConfig);
        this.saveFile(((PlayerConfigManager)this.manager).getDefaultConfig(), this.defaultConfigPathConfig.getPath());
        this.saveFile(((PlayerConfigManager)this.manager).getWildernessConfig(), this.wildernessConfigPathConfig.getPath());
        this.saveFile(((PlayerConfigManager)this.manager).getServerClaimConfig(), this.serverClaimConfigPathConfig.getPath());
        this.saveFile(((PlayerConfigManager)this.manager).getExpiredClaimConfig(), this.expiredClaimConfigPathConfig.getPath());
        super.load();
        ((PlayerConfigManager)this.manager).onLoad();
        OpenPartiesAndClaims.LOGGER.info("Loaded player configs!");
    }

    private void loadGlobalConfig(PlayerConfigType type, FilePathConfig filePathConfig, Consumer<PlayerConfig<P>> resultConsumer) {
        this.loadGlobalConfig(type, filePathConfig.getPath(), filePathConfig, resultConsumer);
    }

    private void loadGlobalConfig(PlayerConfigType type, Path path, FilePathConfig filePathConfig, Consumer<PlayerConfig<P>> resultConsumer) {
        if (Files.exists(path, new LinkOption[0])) {
            PlayerConfig config = (PlayerConfig)this.loadFile(path, filePathConfig, false);
            if (config == null) {
                throw new RuntimeException("Server, expired, default and wilderness claim configs must load properly! Check the game logs for errors.");
            }
            resultConsumer.accept(config);
        } else {
            Path fileInDefaultConfigs;
            if (filePathConfig.getPath() == path && Files.exists(fileInDefaultConfigs = this.defaultConfigs.resolve(path.getFileName()), new LinkOption[0])) {
                this.loadGlobalConfig(type, fileInDefaultConfigs, filePathConfig, resultConsumer);
                return;
            }
            PlayerConfig config = ((PlayerConfig.FinalBuilder)((PlayerConfig.FinalBuilder)((PlayerConfig.FinalBuilder)PlayerConfig.FinalBuilder.begin().setType(type)).setPlayerId(type == PlayerConfigType.SERVER ? PlayerConfig.SERVER_CLAIM_UUID : (type == PlayerConfigType.EXPIRED ? PlayerConfig.EXPIRED_CLAIM_UUID : null))).setManager((PlayerConfigManager)this.manager)).build();
            CommentedConfig storage = CommentedConfig.of(LinkedHashMap::new, (ConfigFormat)TomlFormat.instance());
            ((PlayerConfigManager)this.manager).getPlayerConfigSpec().correct(storage);
            config.setStorage((Config)storage);
            if (filePathConfig == this.wildernessConfigPathConfig) {
                config.tryToSet(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS, false);
            }
            resultConsumer.accept(config);
        }
    }

    @Override
    public boolean save() {
        OpenPartiesAndClaims.LOGGER.debug("Saving player configs...");
        if (((PlayerConfig)((PlayerConfigManager)this.manager).getDefaultConfig()).isDirty()) {
            this.saveFile(((PlayerConfigManager)this.manager).getDefaultConfig(), this.defaultConfigPathConfig.getPath());
        }
        if (((PlayerConfig)((PlayerConfigManager)this.manager).getWildernessConfig()).isDirty()) {
            this.saveFile(((PlayerConfigManager)this.manager).getWildernessConfig(), this.wildernessConfigPathConfig.getPath());
        }
        if (((PlayerConfig)((PlayerConfigManager)this.manager).getServerClaimConfig()).isDirty()) {
            this.saveFile(((PlayerConfigManager)this.manager).getServerClaimConfig(), this.serverClaimConfigPathConfig.getPath());
        }
        this.saveGlobalConfigSubConfigs((PlayerConfig<P>)((PlayerConfigManager)this.manager).getServerClaimConfig());
        if (((PlayerConfig)((PlayerConfigManager)this.manager).getExpiredClaimConfig()).isDirty()) {
            this.saveFile(((PlayerConfigManager)this.manager).getExpiredClaimConfig(), this.expiredClaimConfigPathConfig.getPath());
        }
        return super.save();
    }

    private void saveGlobalConfigSubConfigs(PlayerConfig<P> globalConfig) {
        globalConfig.getSubConfigStream().filter(PlayerConfig::isDirty).forEach(co -> this.saveFile(co, this.getFilePath((PlayerConfig<P>)co, co.getFileName())));
    }

    @Override
    public void onServerTick() {
        super.onServerTick();
    }

    @Override
    protected PlayerConfigDeserializationInfo getObjectId(String fileNameNoExtension, Path file, FilePathConfig filePathConfig) {
        boolean isSub;
        if (filePathConfig == this.defaultConfigPathConfig || filePathConfig == this.wildernessConfigPathConfig) {
            return new PlayerConfigDeserializationInfo(null, filePathConfig == this.defaultConfigPathConfig ? PlayerConfigType.DEFAULT_PLAYER : PlayerConfigType.WILDERNESS, null, -1);
        }
        if (filePathConfig == this.serverClaimConfigPathConfig) {
            return new PlayerConfigDeserializationInfo(PlayerConfig.SERVER_CLAIM_UUID, PlayerConfigType.SERVER, null, -1);
        }
        if (filePathConfig == this.expiredClaimConfigPathConfig) {
            return new PlayerConfigDeserializationInfo(PlayerConfig.EXPIRED_CLAIM_UUID, PlayerConfigType.EXPIRED, null, -1);
        }
        boolean bl = isSub = filePathConfig.getPath() == this.configSubConfigPath;
        if (!isSub) {
            return new PlayerConfigDeserializationInfo(UUID.fromString(fileNameNoExtension), PlayerConfigType.PLAYER, null, -1);
        }
        UUID playerId = UUID.fromString(file.getParent().getFileName().toString());
        String[] fileNameArgs = fileNameNoExtension.split("\\$");
        String subId = fileNameArgs[0];
        String subIndexString = fileNameArgs[1];
        int subIndex = Integer.parseInt(subIndexString);
        if (Objects.equals(playerId, PlayerConfig.SERVER_CLAIM_UUID)) {
            return new PlayerConfigDeserializationInfo(playerId, PlayerConfigType.SERVER, subId, subIndex);
        }
        return new PlayerConfigDeserializationInfo(playerId, PlayerConfigType.PLAYER, subId, subIndex);
    }

    @Override
    protected Path getFilePath(PlayerConfig<P> object, String fileName) {
        if (object instanceof PlayerSubConfig) {
            PlayerSubConfig subConfig = (PlayerSubConfig)object;
            Path folder = this.configSubConfigPath.resolve(fileName);
            return folder.resolve(subConfig.getSubId() + "$" + subConfig.getSubIndex() + this.fileExtension);
        }
        return this.configsPath.resolve(fileName + this.fileExtension);
    }

    @Override
    protected void onObjectLoad(PlayerConfig<P> loadedObject) {
    }

    public static final class Builder<P extends IServerParty<?, ?, ?>, CM extends IServerClaimsManager<?, ?, ?>>
    extends ObjectManagerIO.Builder<String, PlayerConfigDeserializationInfo, PlayerConfig<P>, PlayerConfigManager<P, CM>, Builder<P, CM>> {
        private Builder() {
        }

        @Override
        public Builder<P, CM> setDefault() {
            super.setDefault();
            this.setFileExtension(".toml");
            return this;
        }

        public PlayerConfigIO<P, CM> build() {
            if (this.serializationHandler == null) {
                this.setSerializationHandler(PlayerConfigSerializationHandler.Builder.begin().build());
            }
            return (PlayerConfigIO)super.build();
        }

        protected PlayerConfigIO<P, CM> buildInternally() {
            PlayerConfigIO result = new PlayerConfigIO(this.serializationHandler, this.serializedDataFileIO, this.ioThreadWorker, this.server, this.fileExtension, (PlayerConfigManager)this.manager, this.fileIOHelper);
            ((PlayerConfigManager)this.manager).setIO(result);
            return result;
        }

        public static <P extends IServerParty<?, ?, ?>, CM extends IServerClaimsManager<?, ?, ?>> Builder<P, CM> begin() {
            return new Builder<P, CM>().setDefault();
        }
    }
}

