/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.mixin;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.pac.common.server.core.ServerCore;

@Mixin(value={LivingEntity.class}, priority=1000001)
public class MixinLivingEntity {
    @Inject(at={@At(value="HEAD")}, method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, cancellable=true)
    public void onAddEffect(MobEffectInstance mobEffectInstance, Entity entity, CallbackInfoReturnable<Boolean> info) {
        if (!ServerCore.canAddLivingEntityEffect((LivingEntity)this, mobEffectInstance, entity)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"die"})
    public void onDiePre(DamageSource source, CallbackInfo info) {
        ServerCore.onLivingEntityDiePre((LivingEntity)this, source);
    }

    @Inject(at={@At(value="RETURN")}, method={"die"})
    public void onDiePost(DamageSource source, CallbackInfo info) {
        ServerCore.onLivingEntityDiePost((LivingEntity)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"dropAllDeathLoot"})
    public void onDropAllDeathLoot(ServerLevel level, DamageSource source, CallbackInfo info) {
        ServerCore.onLivingEntityDropDeathLootPre((LivingEntity)this, source);
    }

    @Inject(at={@At(value="RETURN")}, method={"dropAllDeathLoot"})
    public void onDie(ServerLevel level, DamageSource source, CallbackInfo info) {
        ServerCore.onLivingEntityDropDeathLootPost((LivingEntity)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"stabAttack"}, cancellable=true)
    public void onStabAttack(EquipmentSlot slot, Entity targetEntity, float baseDamage, boolean hurt, boolean knockback, boolean dismount, CallbackInfoReturnable<Boolean> info) {
        if (ServerCore.onStabAttack((LivingEntity)this, targetEntity, slot)) {
            info.setReturnValue((Object)false);
        }
    }
}

