/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.packet.ClientboundModesPacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.command.CommandRequirementHelper;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.data.api.ServerPlayerDataAPI;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;
import xaero.pac.common.server.world.ServerLevelHelper;

public class ClaimsAdminModeCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"openpac-claims").requires(context -> (Boolean)ServerConfig.CONFIG.claimsEnabled.get())).then(((LiteralArgumentBuilder)Commands.literal((String)"admin-mode").requires(CommandRequirementHelper.onServerThread(context -> {
            if (Commands.LEVEL_GAMEMASTERS.check(context.permissions())) {
                return true;
            }
            try {
                ServerPlayer player = context.getPlayerOrException();
                MinecraftServer server = ServerLevelHelper.getServer((Entity)player);
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
                if (serverData.getServerClaimsManager().getPermissionHandler().playerHasAdminModePermission(player)) {
                    return true;
                }
                return ServerPlayerDataAPI.from(player).isClaimsAdminMode();
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        }))).executes(context -> {
            ServerPlayerData mainCapability;
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            MinecraftServer server = ServerLevelHelper.getServer((Entity)player);
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            mainCapability.setClaimsAdminMode(!(mainCapability = (ServerPlayerData)ServerPlayerDataAPI.from(player)).isClaimsAdminMode());
            mainCapability.setClaimsNonallyMode(false);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            player.sendSystemMessage((Component)adaptiveLocalizer.getFor(player, mainCapability.isClaimsAdminMode() ? "gui.xaero_claims_admin_mode_enabled" : "gui.xaero_claims_admin_mode_disabled", new Object[0]));
            OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToPlayer(player, new ClientboundModesPacket(mainCapability.isClaimsAdminMode(), mainCapability.isClaimsServerMode()));
            return 1;
        }));
        dispatcher.register(command);
    }
}

