/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.command;

import com.google.common.collect.Sets;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.claims.result.api.AreaClaimResult;
import xaero.pac.common.claims.result.api.ClaimResult;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.sync.ClaimsManagerSynchronizer;
import xaero.pac.common.server.command.CommandRequirementHelper;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.data.api.ServerPlayerDataAPI;
import xaero.pac.common.server.world.ServerLevelHelper;

public class ClaimsClaimCommands {
    protected static ArgumentBuilder<CommandSourceStack, ?> createClaimCommand(ArgumentBuilder<CommandSourceStack, ?> builder, boolean shouldClaim, boolean serverClaim, boolean opReplaceCurrent) {
        return builder.executes(arg_0 -> ClaimsClaimCommands.lambda$createClaimCommand$0(serverClaim, opReplaceCurrent, shouldClaim, arg_0));
    }

    public static Predicate<CommandSourceStack> getServerClaimCommandRequirement() {
        return CommandRequirementHelper.onServerThread(source -> {
            if (Commands.LEVEL_GAMEMASTERS.check(source.permissions())) {
                return true;
            }
            try {
                ServerPlayer player = source.getPlayerOrException();
                MinecraftServer server = ServerLevelHelper.getServer((Entity)player);
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
                if (serverData.getServerClaimsManager().getPermissionHandler().playerHasServerClaimPermission(player)) {
                    return true;
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static /* synthetic */ int lambda$createClaimCommand$0(boolean serverClaim, boolean opReplaceCurrent, boolean shouldClaim, CommandContext context) throws CommandSyntaxException {
        block19: {
            block17: {
                block18: {
                    block15: {
                        block16: {
                            block13: {
                                block14: {
                                    player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
                                    world = player.level();
                                    chunkX = player.chunkPosition().x;
                                    chunkZ = player.chunkPosition().z;
                                    try {
                                        columnPos = ColumnPosArgument.getColumnPos((CommandContext)context, (String)"block pos");
                                        chunkX = columnPos.x() >> 4;
                                        chunkZ = columnPos.z() >> 4;
                                    }
                                    catch (IllegalArgumentException columnPos) {
                                        // empty catch block
                                    }
                                    server = ((CommandSourceStack)context.getSource()).getServer();
                                    serverData = ServerData.from(server);
                                    playerData = (ServerPlayerData)ServerPlayerDataAPI.from(player);
                                    adaptiveLocalizer = serverData.getAdaptiveLocalizer();
                                    shouldServerClaim = serverClaim;
                                    if (playerData.isClaimsServerMode()) {
                                        shouldServerClaim = true;
                                    }
                                    if (shouldServerClaim && serverData.getServerClaimsManager().getPermissionHandler().shouldPreventServerClaim(player, playerData, server)) {
                                        ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(player, "gui.xaero_claims_claim_no_server_permission", new Object[0]));
                                        return 0;
                                    }
                                    v0 = playerId = shouldServerClaim != false ? PlayerConfig.SERVER_CLAIM_UUID : player.getUUID();
                                    if (serverData.getServerTickHandler().getTickCounter() == playerData.getClaimActionRequestHandler().getLastRequestTickCounter()) {
                                        return 0;
                                    }
                                    playerData.getClaimActionRequestHandler().setLastRequestTickCounter(serverData.getServerTickHandler().getTickCounter());
                                    claimsManager = serverData.getServerClaimsManager();
                                    claimsManager.getPermissionHandler().ensureAdminModeStatusPermission(player, playerData);
                                    shouldReplace = opReplaceCurrent != false || playerData.isClaimsAdminMode() != false;
                                    result = null;
                                    try {
                                        if (!shouldClaim) ** GOTO lbl51
                                        playerConfig = serverData.getPlayerConfigs().getLoadedConfig(player.getUUID());
                                        usedSubConfig = shouldServerClaim != false ? playerConfig.getUsedServerSubConfig() : playerConfig.getUsedSubConfig();
                                        subConfigIndex = usedSubConfig.getSubIndex();
                                        result = claimsManager.tryToClaimTyped(world.dimension().identifier(), playerId, subConfigIndex, player.chunkPosition().x, player.chunkPosition().z, chunkX, chunkZ, shouldReplace);
                                        if (result.getResultType() != ClaimResult.Type.ALREADY_CLAIMED) break block13;
                                        claimOwnerInfo = (IServerPlayerClaimInfo)claimsManager.getPlayerInfo(result.getClaimResult().getPlayerId());
                                        ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(player, "gui.xaero_claims_claim_already_claimed_by", new Object[]{claimOwnerInfo.getPlayerUsername()}));
                                        var21_25 = 0;
                                        if (result == null) break block14;
                                    }
                                    catch (Throwable var22_26) {
                                        if (result != null) {
                                            ((ClaimsManagerSynchronizer)claimsManager.getClaimsManagerSynchronizer()).syncToPlayerClaimActionResult(new AreaClaimResult(Sets.newHashSet((Object[])new ClaimResult.Type[]{result.getResultType()}), chunkX, chunkZ, chunkX, chunkZ), player);
                                        }
                                        throw var22_26;
                                    }
                                    ((ClaimsManagerSynchronizer)claimsManager.getClaimsManagerSynchronizer()).syncToPlayerClaimActionResult(new AreaClaimResult(Sets.newHashSet((Object[])new ClaimResult.Type[]{result.getResultType()}), chunkX, chunkZ, chunkX, chunkZ), player);
                                }
                                return var21_25;
                            }
                            break block15;
lbl51:
                            // 1 sources

                            result = claimsManager.tryToUnclaimTyped(world.dimension().identifier(), playerId, player.chunkPosition().x, player.chunkPosition().z, chunkX, chunkZ, shouldReplace);
                            if (result.getResultType().success) break block15;
                            ((CommandSourceStack)context.getSource()).sendFailure(adaptiveLocalizer.getFor(player, result.getResultType().message));
                            var17_19 = 0;
                            if (result == null) break block16;
                            ((ClaimsManagerSynchronizer)claimsManager.getClaimsManagerSynchronizer()).syncToPlayerClaimActionResult(new AreaClaimResult(Sets.newHashSet((Object[])new ClaimResult.Type[]{result.getResultType()}), chunkX, chunkZ, chunkX, chunkZ), player);
                        }
                        return var17_19;
                    }
                    if (!result.getResultType().success) break block17;
                    player.sendSystemMessage((Component)adaptiveLocalizer.getFor(player, shouldClaim != false ? "gui.xaero_claims_claimed_at" : "gui.xaero_claims_unclaimed_at", new Object[]{chunkX, chunkZ}));
                    var17_20 = 1;
                    if (result == null) break block18;
                    ((ClaimsManagerSynchronizer)claimsManager.getClaimsManagerSynchronizer()).syncToPlayerClaimActionResult(new AreaClaimResult(Sets.newHashSet((Object[])new ClaimResult.Type[]{result.getResultType()}), chunkX, chunkZ, chunkX, chunkZ), player);
                }
                return var17_20;
            }
            if (result.getResultType().fail) {
                ((CommandSourceStack)context.getSource()).sendFailure(adaptiveLocalizer.getFor(player, result.getResultType().message));
            } else {
                player.sendSystemMessage(adaptiveLocalizer.getFor(player, result.getResultType().message));
            }
            var17_21 = 0;
            if (result == null) break block19;
            ((ClaimsManagerSynchronizer)claimsManager.getClaimsManagerSynchronizer()).syncToPlayerClaimActionResult(new AreaClaimResult(Sets.newHashSet((Object[])new ClaimResult.Type[]{result.getResultType()}), chunkX, chunkZ, chunkX, chunkZ), player);
        }
        return var17_21;
    }
}

