/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.util.nbt;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;

public class XaeroNbtUtil {
    public static Optional<UUID> getUUID(CompoundTag tag, String id) {
        int[] intArray = tag.getIntArray(id).orElse(null);
        if (intArray == null) {
            long[] longArray = tag.getLongArray(id).orElse(null);
            if (longArray == null || longArray.length != 2) {
                return Optional.empty();
            }
            return Optional.of(new UUID(longArray[0], longArray[1]));
        }
        if (intArray.length != 4) {
            return Optional.empty();
        }
        return Optional.of(UUIDUtil.uuidFromIntArray((int[])intArray));
    }

    public static void putUUID(CompoundTag tag, String id, UUID uuid) {
        tag.putIntArray(id, UUIDUtil.uuidToIntArray((UUID)uuid));
    }

    public static IntArrayTag createUUIDTag(UUID partyId) {
        return new IntArrayTag(UUIDUtil.uuidToIntArray((UUID)partyId));
    }

    public static Optional<UUID> getUUIDFromTag(Tag tag) {
        if (tag instanceof IntArrayTag) {
            IntArrayTag intArrayTag = (IntArrayTag)tag;
            return Optional.of(UUIDUtil.uuidFromIntArray((int[])intArrayTag.getAsIntArray()));
        }
        if (tag instanceof LongArrayTag) {
            LongArrayTag longArrayTag = (LongArrayTag)tag;
            long[] longArray = longArrayTag.getAsLongArray();
            return Optional.of(new UUID(longArray[0], longArray[1]));
        }
        return Optional.empty();
    }
}

